/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security;

import java.security.Key;
import java.security.interfaces.DSAParams;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.opensaml.xml.security.SecurityConfiguration;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xml.util.DatatypeHelper;

public class BasicSecurityConfiguration
implements SecurityConfiguration {
    private static Logger log = Logger.getLogger(BasicSecurityConfiguration.class);
    private Map<String, String> signatureAlgorithms = new HashMap<String, String>();
    private String signatureCanonicalization;
    private String signatureReferenceDigestMethod;
    private Integer signatureHMACOutputLength;
    private Map<DataEncryptionIndex, String> dataEncryptionAlgorithms = new HashMap<DataEncryptionIndex, String>();
    private Map<KeyTransportEncryptionIndex, String> keyTransportEncryptionAlgorithms = new HashMap<KeyTransportEncryptionIndex, String>();
    private String autoGenEncryptionURI;
    private NamedKeyInfoGeneratorManager keyInfoGeneratorManager;
    private DSAParams dsaParams;

    public String getSignatureAlgorithmURI(String jcaAlgorithmName) {
        return this.signatureAlgorithms.get(jcaAlgorithmName);
    }

    public String getSignatureAlgorithmURI(Credential credential) {
        Key key = SecurityHelper.extractSigningKey(credential);
        if (key == null) {
            log.debug((Object)"Could not extract signing key from credential, unable to map to algorithm URI");
            return null;
        }
        if (key.getAlgorithm() == null) {
            log.debug((Object)"Signing key algorithm value was not available, unable to map to algorithm URI");
            return null;
        }
        return this.getSignatureAlgorithmURI(key.getAlgorithm());
    }

    public void registerSignatureAlgorithmURI(String jcaAlgorithmName, String algorithmURI) {
        this.signatureAlgorithms.put(jcaAlgorithmName, algorithmURI);
    }

    public void deregisterSignatureAlgorithmURI(String jcaAlgorithmName) {
        this.signatureAlgorithms.remove(jcaAlgorithmName);
    }

    public String getSignatureCanonicalizationAlgorithm() {
        return this.signatureCanonicalization;
    }

    public void setSignatureCanonicalizationAlgorithm(String algorithmURI) {
        this.signatureCanonicalization = algorithmURI;
    }

    public String getSignatureReferenceDigestMethod() {
        return this.signatureReferenceDigestMethod;
    }

    public void setSignatureReferenceDigestMethod(String algorithmURI) {
        this.signatureReferenceDigestMethod = algorithmURI;
    }

    public Integer getSignatureHMACOutputLength() {
        return this.signatureHMACOutputLength;
    }

    public void setSignatureHMACOutputLength(Integer length) {
        this.signatureHMACOutputLength = length;
    }

    public String getDataEncryptionAlgorithmURI(String jcaAlgorithmName, Integer keyLength) {
        DataEncryptionIndex index = new DataEncryptionIndex(jcaAlgorithmName, keyLength);
        String algorithmURI = this.dataEncryptionAlgorithms.get(index);
        if (algorithmURI != null) {
            return algorithmURI;
        }
        if (keyLength != null) {
            log.debug((Object)"No data encryption algorithm mapping available for JCA name + key length, trying JCA name alone");
            index = new DataEncryptionIndex(jcaAlgorithmName, null);
            return this.dataEncryptionAlgorithms.get(index);
        }
        return null;
    }

    public String getDataEncryptionAlgorithmURI(Credential credential) {
        Key key = SecurityHelper.extractEncryptionKey(credential);
        if (key == null) {
            log.debug((Object)"Could not extract data encryption key from credential, unable to map to algorithm URI");
            return null;
        }
        if (key.getAlgorithm() == null) {
            log.debug((Object)"Data encryption key algorithm value was not available, unable to map to algorithm URI");
            return null;
        }
        Integer length = SecurityHelper.getKeyLength(key);
        return this.getDataEncryptionAlgorithmURI(key.getAlgorithm(), length);
    }

    public void registerDataEncryptionAlgorithmURI(String jcaAlgorithmName, Integer keyLength, String algorithmURI) {
        DataEncryptionIndex index = new DataEncryptionIndex(jcaAlgorithmName, keyLength);
        this.dataEncryptionAlgorithms.put(index, algorithmURI);
    }

    public void deregisterDataEncryptionAlgorithmURI(String jcaAlgorithmName, Integer keyLength) {
        DataEncryptionIndex index = new DataEncryptionIndex(jcaAlgorithmName, keyLength);
        this.dataEncryptionAlgorithms.remove(index);
    }

    public String getKeyTransportEncryptionAlgorithmURI(String jcaAlgorithmName, Integer keyLength, String wrappedKeyAlgorithm) {
        KeyTransportEncryptionIndex index = new KeyTransportEncryptionIndex(jcaAlgorithmName, keyLength, wrappedKeyAlgorithm);
        String algorithmURI = this.keyTransportEncryptionAlgorithms.get(index);
        if (algorithmURI != null) {
            return algorithmURI;
        }
        if (wrappedKeyAlgorithm != null) {
            log.debug((Object)"No data encryption algorithm mapping available for JCA name + key length + wrapped algorithm, trying JCA name + key length");
            index = new KeyTransportEncryptionIndex(jcaAlgorithmName, keyLength, null);
            algorithmURI = this.keyTransportEncryptionAlgorithms.get(index);
            if (algorithmURI != null) {
                return algorithmURI;
            }
        }
        if (keyLength != null) {
            log.debug((Object)"No data encryption algorithm mapping available for JCA name + key length + wrapped algorithm, trying JCA name + wrapped algorithm");
            index = new KeyTransportEncryptionIndex(jcaAlgorithmName, null, wrappedKeyAlgorithm);
            algorithmURI = this.keyTransportEncryptionAlgorithms.get(index);
            if (algorithmURI != null) {
                return algorithmURI;
            }
        }
        log.debug((Object)"No data encryption algorithm mapping available for JCA name + key length + wrapped algorithm, trying JCA name alone");
        index = new KeyTransportEncryptionIndex(jcaAlgorithmName, null, null);
        return this.keyTransportEncryptionAlgorithms.get(index);
    }

    public String getKeyTransportEncryptionAlgorithmURI(Credential credential, String wrappedKeyAlgorithm) {
        Key key = SecurityHelper.extractEncryptionKey(credential);
        if (key == null) {
            log.debug((Object)"Could not extract key transport encryption key from credential, unable to map to algorithm URI");
            return null;
        }
        if (key.getAlgorithm() == null) {
            log.debug((Object)"Key transport encryption key algorithm value was not available, unable to map to algorithm URI");
            return null;
        }
        Integer length = SecurityHelper.getKeyLength(key);
        return this.getKeyTransportEncryptionAlgorithmURI(key.getAlgorithm(), length, wrappedKeyAlgorithm);
    }

    public void registerKeyTransportEncryptionAlgorithmURI(String jcaAlgorithmName, Integer keyLength, String wrappedKeyAlgorithm, String algorithmURI) {
        KeyTransportEncryptionIndex index = new KeyTransportEncryptionIndex(jcaAlgorithmName, keyLength, wrappedKeyAlgorithm);
        this.keyTransportEncryptionAlgorithms.put(index, algorithmURI);
    }

    public void deregisterKeyTransportEncryptionAlgorithmURI(String jcaAlgorithmName, Integer keyLength, String wrappedKeyAlgorithm) {
        KeyTransportEncryptionIndex index = new KeyTransportEncryptionIndex(jcaAlgorithmName, keyLength, wrappedKeyAlgorithm);
        this.keyTransportEncryptionAlgorithms.remove(index);
    }

    public String getAutoGeneratedKeyEncryptionAlgorithmURI() {
        return this.autoGenEncryptionURI;
    }

    public void setAutoGeneratedKeyEncryptionAlgorithmURI(String algorithmURI) {
        this.autoGenEncryptionURI = algorithmURI;
    }

    public NamedKeyInfoGeneratorManager getKeyInfoGeneratorManager() {
        return this.keyInfoGeneratorManager;
    }

    public void setKeyInfoGeneratorManager(NamedKeyInfoGeneratorManager keyInfoManager) {
        this.keyInfoGeneratorManager = keyInfoManager;
    }

    public DSAParams getDSAParams() {
        return this.dsaParams;
    }

    public void setDSAParams(DSAParams params) {
        this.dsaParams = params;
    }

    protected class KeyTransportEncryptionIndex {
        private String keyAlgorithm;
        private Integer keyLength;
        private String wrappedAlgorithm;

        protected KeyTransportEncryptionIndex(String jcaAlgorithmName, Integer length, String wrappedKeyAlgorithm) {
            if (DatatypeHelper.isEmpty(jcaAlgorithmName)) {
                throw new IllegalArgumentException("JCA Algorithm name may not be null or empty");
            }
            this.keyAlgorithm = DatatypeHelper.safeTrimOrNullString(jcaAlgorithmName);
            this.keyLength = length;
            this.wrappedAlgorithm = DatatypeHelper.safeTrimOrNullString(wrappedKeyAlgorithm);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DataEncryptionIndex)) {
                return false;
            }
            KeyTransportEncryptionIndex other = (KeyTransportEncryptionIndex)obj;
            if (!this.keyAlgorithm.equals(other.keyAlgorithm)) {
                return false;
            }
            if (this.keyLength == null ? other.keyLength != null : !this.keyLength.equals(other.keyLength)) {
                return false;
            }
            if (this.wrappedAlgorithm == null && other.wrappedAlgorithm != null) {
                return false;
            }
            return this.wrappedAlgorithm.equals(other.wrappedAlgorithm);
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.keyAlgorithm.hashCode();
            if (this.keyLength != null) {
                result = 37 * result + this.keyLength.hashCode();
            }
            if (this.wrappedAlgorithm != null) {
                result = 37 * result + this.wrappedAlgorithm.hashCode();
            }
            return result;
        }

        public String toString() {
            return String.format("[%s,%s,%s]", this.keyAlgorithm, this.keyLength, this.wrappedAlgorithm);
        }
    }

    protected class DataEncryptionIndex {
        private String keyAlgorithm;
        private Integer keyLength;

        protected DataEncryptionIndex(String jcaAlgorithmName, Integer length) {
            if (DatatypeHelper.isEmpty(jcaAlgorithmName)) {
                throw new IllegalArgumentException("JCA Algorithm name may not be null or empty");
            }
            this.keyAlgorithm = DatatypeHelper.safeTrimOrNullString(jcaAlgorithmName);
            this.keyLength = length;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DataEncryptionIndex)) {
                return false;
            }
            DataEncryptionIndex other = (DataEncryptionIndex)obj;
            if (!this.keyAlgorithm.equals(other.keyAlgorithm)) {
                return false;
            }
            if (this.keyLength == null && other.keyLength != null) {
                return false;
            }
            return this.keyLength.equals(other.keyLength);
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.keyAlgorithm.hashCode();
            if (this.keyLength != null) {
                result = 37 * result + this.keyLength.hashCode();
            }
            return result;
        }

        public String toString() {
            return String.format("[%s,%s]", this.keyAlgorithm, this.keyLength);
        }
    }
}

