/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security;

import java.security.Key;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Set;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.log4j.Logger;
import org.apache.xml.security.algorithms.JCEMapper;
import org.opensaml.xml.security.Criteria;
import org.opensaml.xml.security.credential.BasicCredential;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialCriteria;
import org.opensaml.xml.security.credential.CredentialCriteriaSet;
import org.opensaml.xml.security.x509.PKIXCriteria;
import org.opensaml.xml.security.x509.PKIXCriteriaSet;
import org.opensaml.xml.util.DatatypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SecurityHelper {
    private static Logger log = Logger.getLogger(SecurityHelper.class);

    private SecurityHelper() {
    }

    public static boolean isHMAC(String signatureAlgorithm) {
        String algoClass = DatatypeHelper.safeTrimOrNullString(JCEMapper.getAlgorithmClassFromURI((String)signatureAlgorithm));
        return "Mac".equals(algoClass);
    }

    public static String getKeyAlgorithmFromURI(String algorithmURI) {
        return DatatypeHelper.safeTrimOrNullString(JCEMapper.getJCEKeyAlgorithmFromURI((String)algorithmURI));
    }

    public static Integer getKeyLengthFromURI(String algorithmURI) {
        String algoClass = DatatypeHelper.safeTrimOrNullString(JCEMapper.getAlgorithmClassFromURI((String)algorithmURI));
        if ("BlockEncryption".equals(algoClass) || "SymmetricKeyWrap".equals(algoClass)) {
            try {
                int keyLength = JCEMapper.getKeyLengthFromURI((String)algorithmURI);
                return new Integer(keyLength);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("XML Security config contained invalid key length value for algorithm URI: " + algorithmURI));
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Mapping from algorithm URI '" + algorithmURI + "' to key length not available"));
        }
        return null;
    }

    public static SecretKey generateSymmetricKey(String algoURI) throws NoSuchAlgorithmException, KeyException {
        String jceAlgorithmName = SecurityHelper.getKeyAlgorithmFromURI(algoURI);
        if (DatatypeHelper.isEmpty(jceAlgorithmName)) {
            log.error((Object)("Mapping from algorithm URI '" + algoURI + "' to key algorithm not available, key generation failed"));
            throw new NoSuchAlgorithmException("Algorithm URI'" + algoURI + "' is invalid for key generation");
        }
        Integer keyLength = SecurityHelper.getKeyLengthFromURI(algoURI);
        if (keyLength == null) {
            log.error((Object)"Key length could not be determined from algorithm URI, can't generate key");
            throw new KeyException("Key length not determinable from algorithm URI, could not generate new key");
        }
        KeyGenerator keyGenerator = KeyGenerator.getInstance(jceAlgorithmName);
        keyGenerator.init(keyLength);
        return keyGenerator.generateKey();
    }

    public static Key extractEncryptionKey(Credential credential) {
        if (credential == null) {
            return null;
        }
        if (credential.getPublicKey() != null) {
            return credential.getPublicKey();
        }
        return credential.getSecretKey();
    }

    public static Key extractDecryptionKey(Credential credential) {
        if (credential == null) {
            return null;
        }
        if (credential.getPrivateKey() != null) {
            return credential.getPrivateKey();
        }
        return credential.getSecretKey();
    }

    public static Key extractSigningKey(Credential credential) {
        if (credential == null) {
            return null;
        }
        if (credential.getPrivateKey() != null) {
            return credential.getPrivateKey();
        }
        return credential.getSecretKey();
    }

    public static Key extractVerificationKey(Credential credential) {
        if (credential == null) {
            return null;
        }
        if (credential.getPublicKey() != null) {
            return credential.getPublicKey();
        }
        return credential.getSecretKey();
    }

    public static Integer getKeyLength(Key key) {
        if (key instanceof SecretKey && "RAW".equals(key.getFormat())) {
            return key.getEncoded().length;
        }
        log.debug((Object)"Unable to determine length in bits of specified Key instance");
        return null;
    }

    public static BasicCredential getSimpleCredential(SecretKey secretKey) {
        if (secretKey == null) {
            throw new IllegalArgumentException("A secret key is required");
        }
        BasicCredential cred = new BasicCredential();
        cred.setSecretKey(secretKey);
        return cred;
    }

    public static BasicCredential getSimpleCredential(PublicKey publicKey, PrivateKey privateKey) {
        if (publicKey == null) {
            throw new IllegalArgumentException("A public key is required");
        }
        BasicCredential cred = new BasicCredential();
        cred.setPublicKey(publicKey);
        cred.setPrivateKey(privateKey);
        return cred;
    }

    public static CredentialCriteriaSet getCredentialCriteria(Set<Criteria> generalCriteria) {
        CredentialCriteriaSet criteriaSet = new CredentialCriteriaSet();
        for (Criteria criteria : generalCriteria) {
            if (!(criteria instanceof CredentialCriteria)) continue;
            criteriaSet.add((CredentialCriteria)criteria);
        }
        return criteriaSet;
    }

    public static PKIXCriteriaSet getPKIXCriteria(Set<Criteria> generalCriteria) {
        PKIXCriteriaSet criteriaSet = new PKIXCriteriaSet();
        for (Criteria criteria : generalCriteria) {
            if (!(criteria instanceof PKIXCriteria)) continue;
            criteriaSet.add((PKIXCriteria)criteria);
        }
        return criteriaSet;
    }
}

