/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.keyinfo.provider;

import java.security.KeyException;
import java.security.PublicKey;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.BasicCredential;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialCriteriaSet;
import org.opensaml.xml.security.credential.KeyAlgorithmCriteria;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.provider.AbstractKeyInfoProvider;
import org.opensaml.xml.signature.DSAKeyValue;
import org.opensaml.xml.signature.KeyInfoHelper;
import org.opensaml.xml.signature.KeyValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSAKeyValueProvider
extends AbstractKeyInfoProvider {
    private static Logger log = Logger.getLogger(DSAKeyValueProvider.class);

    @Override
    public boolean handles(XMLObject keyInfoChild) {
        return this.getDSAKeyValue(keyInfoChild) != null;
    }

    @Override
    public Collection<Credential> process(KeyInfoCredentialResolver resolver, XMLObject keyInfoChild, CredentialCriteriaSet criteriaSet, KeyInfoCredentialResolver.KeyInfoResolutionContext kiContext) throws SecurityException {
        DSAKeyValue keyValue = this.getDSAKeyValue(keyInfoChild);
        if (keyValue == null) {
            return null;
        }
        KeyAlgorithmCriteria algorithmCriteria = criteriaSet.get(KeyAlgorithmCriteria.class);
        if (algorithmCriteria != null && algorithmCriteria.getKeyAlgorithm() != null && !algorithmCriteria.getKeyAlgorithm().equals("DSA")) {
            log.debug((Object)"Criteria specified non-DSA key algorithm, skipping");
            return null;
        }
        log.debug((Object)"Attempting to extract credential from a DSAKeyValue");
        PublicKey pubKey = null;
        try {
            pubKey = KeyInfoHelper.getDSAKey(keyValue);
        }
        catch (KeyException e) {
            log.error((Object)"Error extracting DSA key value", (Throwable)e);
            throw new SecurityException("Error extracting DSA key value", e);
        }
        BasicCredential cred = new BasicCredential();
        cred.setPublicKey(pubKey);
        cred.getKeyNames().addAll(kiContext.getKeyNames());
        cred.getCredentalContextSet().add(resolver.buildCredentialContext(kiContext));
        log.debug((Object)"Credential successfully extracted from DSAKeyValue");
        return this.singletonSet(cred);
    }

    protected DSAKeyValue getDSAKeyValue(XMLObject xmlObject) {
        if (xmlObject == null) {
            return null;
        }
        if (xmlObject instanceof DSAKeyValue) {
            return (DSAKeyValue)xmlObject;
        }
        if (xmlObject instanceof KeyValue) {
            return ((KeyValue)xmlObject).getDSAKeyValue();
        }
        return null;
    }
}

