/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.keyinfo.provider;

import java.security.KeyException;
import java.security.PublicKey;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.BasicCredential;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialCriteriaSet;
import org.opensaml.xml.security.credential.KeyAlgorithmCriteria;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.provider.AbstractKeyInfoProvider;
import org.opensaml.xml.signature.KeyInfoHelper;
import org.opensaml.xml.signature.KeyValue;
import org.opensaml.xml.signature.RSAKeyValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSAKeyValueProvider
extends AbstractKeyInfoProvider {
    private static Logger log = Logger.getLogger(RSAKeyValueProvider.class);

    @Override
    public boolean handles(XMLObject keyInfoChild) {
        return this.getRSAKeyValue(keyInfoChild) != null;
    }

    @Override
    public Collection<Credential> process(KeyInfoCredentialResolver resolver, XMLObject keyInfoChild, CredentialCriteriaSet criteriaSet, KeyInfoCredentialResolver.KeyInfoResolutionContext kiContext) throws SecurityException {
        RSAKeyValue keyValue = this.getRSAKeyValue(keyInfoChild);
        if (keyValue == null) {
            return null;
        }
        KeyAlgorithmCriteria algorithmCriteria = criteriaSet.get(KeyAlgorithmCriteria.class);
        if (algorithmCriteria != null && algorithmCriteria.getKeyAlgorithm() != null && !algorithmCriteria.getKeyAlgorithm().equals("RSA")) {
            log.debug((Object)"Criteria specified non-RSA key algorithm, skipping");
            return null;
        }
        log.debug((Object)"Attempting to extract credential from an RSAKeyValue");
        PublicKey pubKey = null;
        try {
            pubKey = KeyInfoHelper.getRSAKey(keyValue);
        }
        catch (KeyException e) {
            log.error((Object)"Error extracting RSA key value", (Throwable)e);
            throw new SecurityException("Error extracting RSA key value", e);
        }
        BasicCredential cred = new BasicCredential();
        cred.setPublicKey(pubKey);
        cred.getKeyNames().addAll(kiContext.getKeyNames());
        cred.getCredentalContextSet().add(resolver.buildCredentialContext(kiContext));
        log.debug((Object)"Credential successfully extracted from RSAKeyValue");
        return this.singletonSet(cred);
    }

    protected RSAKeyValue getRSAKeyValue(XMLObject xmlObject) {
        if (xmlObject == null) {
            return null;
        }
        if (xmlObject instanceof RSAKeyValue) {
            return (RSAKeyValue)xmlObject;
        }
        if (xmlObject instanceof KeyValue) {
            return ((KeyValue)xmlObject).getRSAKeyValue();
        }
        return null;
    }
}

