/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.keyinfo.provider;

import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialCriteriaSet;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.provider.AbstractKeyInfoProvider;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.security.x509.InternalX500DNHandler;
import org.opensaml.xml.security.x509.X500DNHandler;
import org.opensaml.xml.security.x509.X509Util;
import org.opensaml.xml.signature.KeyInfoHelper;
import org.opensaml.xml.signature.X509Data;
import org.opensaml.xml.signature.X509IssuerSerial;
import org.opensaml.xml.signature.X509SKI;
import org.opensaml.xml.signature.X509SubjectName;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.DatatypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509DataProvider
extends AbstractKeyInfoProvider {
    private static Logger log = Logger.getLogger(X509DataProvider.class);
    private X500DNHandler x500DNHandler = new InternalX500DNHandler();

    public X500DNHandler getX500DNHandler() {
        return this.x500DNHandler;
    }

    public void setX500DNHandler(X500DNHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("X500DNHandler may not be null");
        }
        this.x500DNHandler = handler;
    }

    @Override
    public boolean handles(XMLObject keyInfoChild) {
        return keyInfoChild instanceof X509Data;
    }

    @Override
    public Collection<Credential> process(KeyInfoCredentialResolver resolver, XMLObject keyInfoChild, CredentialCriteriaSet criteriaSet, KeyInfoCredentialResolver.KeyInfoResolutionContext kiContext) throws SecurityException {
        X509Certificate entityCert;
        if (!this.handles(keyInfoChild)) {
            return null;
        }
        X509Data x509Data = (X509Data)keyInfoChild;
        log.debug((Object)"Attempting to extract credential from an X509Data");
        List<X509Certificate> certs = this.extractCertificates(x509Data);
        if (certs.isEmpty()) {
            log.info((Object)"The X509Data contained no X509Certificate elements, skipping credential extraction");
            return null;
        }
        List<X509CRL> crls = this.extractCRLs(x509Data);
        PublicKey resolvedPublicKey = null;
        if (kiContext.getKeyValueCredential() != null) {
            resolvedPublicKey = kiContext.getKeyValueCredential().getPublicKey();
        }
        if ((entityCert = this.findEntityCert(certs, x509Data, resolvedPublicKey)) == null) {
            log.warn((Object)"The end-entity cert could not be identified, skipping credential extraction");
            return null;
        }
        BasicX509Credential cred = new BasicX509Credential();
        cred.setEntityCertificate(entityCert);
        cred.setCRLs(crls);
        cred.setEntityCertificateChain(certs);
        cred.getKeyNames().addAll(kiContext.getKeyNames());
        cred.getCredentalContextSet().add(resolver.buildCredentialContext(kiContext));
        return this.singletonSet(cred);
    }

    private List<X509CRL> extractCRLs(X509Data x509Data) throws SecurityException {
        List<X509CRL> crls = null;
        try {
            crls = KeyInfoHelper.getCRLs(x509Data);
        }
        catch (CRLException e) {
            log.error((Object)"Error extracting CRL's from X509Data", (Throwable)e);
            throw new SecurityException("Error extracting CRL's from X509Data", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + crls.size() + " X509CRLs"));
        }
        return crls;
    }

    private List<X509Certificate> extractCertificates(X509Data x509Data) throws SecurityException {
        List<X509Certificate> certs = null;
        try {
            certs = KeyInfoHelper.getCertificates(x509Data);
        }
        catch (CertificateException e) {
            log.error((Object)"Error extracting certificates from X509Data", (Throwable)e);
            throw new SecurityException("Error extracting certificates from X509Data", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + certs.size() + " X509Certificates"));
        }
        return certs;
    }

    protected X509Certificate findEntityCert(List<X509Certificate> certs, X509Data x509Data, PublicKey resolvedKey) {
        if (certs == null || certs.isEmpty()) {
            return null;
        }
        if (certs.size() == 1) {
            log.debug((Object)"Single certificate was present, treating as end-entity certificate");
            return certs.get(0);
        }
        X509Certificate cert = null;
        cert = this.findCertFromKey(certs, resolvedKey);
        if (cert != null) {
            log.debug((Object)"End-entity certificate resolved by matching previously resolved public key");
            return cert;
        }
        cert = this.findCertFromSubjectNames(certs, x509Data.getX509SubjectNames());
        if (cert != null) {
            log.debug((Object)"End-entity certificate resolved by matching X509SubjectName");
            return cert;
        }
        cert = this.findCertFromIssuerSerials(certs, x509Data.getX509IssuerSerials());
        if (cert != null) {
            log.debug((Object)"End-entity certificate resolved by matching X509IssuerSerial");
            return cert;
        }
        cert = this.findCertFromSubjectKeyIdentifier(certs, x509Data.getX509SKIs());
        if (cert != null) {
            log.debug((Object)"End-entity certificate resolved by matching X509SKI");
            return cert;
        }
        log.debug((Object)"Treating the first certificate in the X509Data as the end-entity certificate");
        return certs.get(0);
    }

    protected X509Certificate findCertFromKey(List<X509Certificate> certs, PublicKey key) {
        if (key != null) {
            for (X509Certificate cert : certs) {
                if (!cert.getPublicKey().equals(key)) continue;
                return cert;
            }
        }
        return null;
    }

    protected X509Certificate findCertFromSubjectNames(List<X509Certificate> certs, List<X509SubjectName> names) {
        for (X509SubjectName subjectName : names) {
            if (DatatypeHelper.isEmpty(subjectName.getValue())) continue;
            X500Principal subjectX500Principal = this.x500DNHandler.parse(subjectName.getValue());
            for (X509Certificate cert : certs) {
                if (!cert.getSubjectX500Principal().equals(subjectX500Principal)) continue;
                return cert;
            }
        }
        return null;
    }

    protected X509Certificate findCertFromIssuerSerials(List<X509Certificate> certs, List<X509IssuerSerial> serials) {
        for (X509IssuerSerial issuerSerial : serials) {
            if (issuerSerial.getX509IssuerName() == null || issuerSerial.getX509SerialNumber() == null) continue;
            String issuerNameValue = issuerSerial.getX509IssuerName().getValue();
            BigInteger serialNumber = issuerSerial.getX509SerialNumber().getValue();
            if (DatatypeHelper.isEmpty(issuerNameValue)) continue;
            X500Principal issuerX500Principal = this.x500DNHandler.parse(issuerNameValue);
            for (X509Certificate cert : certs) {
                if (!cert.getIssuerX500Principal().equals(issuerX500Principal) || !cert.getSerialNumber().equals(serialNumber)) continue;
                return cert;
            }
        }
        return null;
    }

    protected X509Certificate findCertFromSubjectKeyIdentifier(List<X509Certificate> certs, List<X509SKI> skis) {
        for (X509SKI ski : skis) {
            if (DatatypeHelper.isEmpty(ski.getValue())) continue;
            byte[] xmlValue = Base64.decode(ski.getValue());
            for (X509Certificate cert : certs) {
                byte[] certValue = X509Util.getSubjectKeyIdentifier(cert);
                if (certValue == null || !Arrays.equals(xmlValue, certValue)) continue;
                return cert;
            }
        }
        return null;
    }
}

