/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.trust;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.trust.TrustEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingTrustEngine<TokenType>
implements TrustEngine<TokenType> {
    private static Logger log = Logger.getLogger(ChainingTrustEngine.class);
    private List<TrustEngine<TokenType>> engines = new ArrayList<TrustEngine<TokenType>>();

    public List<TrustEngine<TokenType>> getChain() {
        return this.engines;
    }

    @Override
    public boolean validate(TokenType token, CriteriaSet trustBasisCriteria) throws SecurityException {
        for (TrustEngine<TokenType> engine : this.engines) {
            if (!engine.validate(token, trustBasisCriteria)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Token was trusted by chain member: " + engine.getClass().getName()));
            }
            return true;
        }
        return false;
    }
}

