/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.trust;

import java.security.Key;
import org.apache.log4j.Logger;
import org.opensaml.xml.security.credential.Credential;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplicitKeyTrustEvaluator {
    private static Logger log = Logger.getLogger(ExplicitKeyTrustEvaluator.class);

    public boolean validate(Key untrustedKey, Key trustedKey) {
        return untrustedKey.equals(trustedKey);
    }

    public boolean validate(Key untrustedKey, Iterable<Key> trustedKeys) {
        for (Key trustedKey : trustedKeys) {
            if (!untrustedKey.equals(trustedKey)) continue;
            return true;
        }
        return false;
    }

    public boolean validate(Credential untrustedCredential, Credential trustedCredential) {
        Key untrustedKey = null;
        Key trustedKey = null;
        if (untrustedCredential.getPublicKey() != null) {
            untrustedKey = untrustedCredential.getPublicKey();
            trustedKey = trustedCredential.getPublicKey();
        } else {
            untrustedKey = untrustedCredential.getSecretKey();
            trustedKey = trustedCredential.getSecretKey();
        }
        if (untrustedKey == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Untrusted credential contained no key, unable to evaluate");
            }
            return false;
        }
        if (trustedKey == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Trusted credential contained no key of the appropriate type, unable to evaluate");
            }
            return false;
        }
        if (this.validate(untrustedKey, trustedKey)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Validated credential for entity " + untrustedCredential.getEntityId() + " against trusted key"));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Credential for entity " + untrustedCredential.getEntityId() + " did not validate against trusted key"));
        }
        return false;
    }

    public boolean validate(Credential untrustedCredential, Iterable<Credential> trustedCredentials) {
        for (Credential trustedCredential : trustedCredentials) {
            if (!this.validate(untrustedCredential, trustedCredential)) continue;
            return true;
        }
        return false;
    }
}

