/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.x509;

import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.opensaml.xml.security.x509.InternalX500DNHandler;
import org.opensaml.xml.security.x509.PKIXValidationInformation;
import org.opensaml.xml.security.x509.X500DNHandler;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.security.x509.X509Util;
import org.opensaml.xml.util.DatatypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PKIXTrustEvaluator {
    private static Logger log = Logger.getLogger(PKIXTrustEvaluator.class);
    private boolean checkSubjectAltNames;
    private boolean checkSubjectDNCommonName;
    private boolean checkSubjectDN;
    private Set<Integer> subjectAltNameTypes;
    private X500DNHandler x500DNHandler = new InternalX500DNHandler();

    public PKIXTrustEvaluator() {
        this.subjectAltNameTypes = new HashSet<Integer>();
        this.setCheckSubjectAltNames(true);
        this.setCheckSubjectDNCommonName(true);
        this.setCheckSubjectDN(true);
        this.subjectAltNameTypes.add(X509Util.DNS_ALT_NAME);
        this.subjectAltNameTypes.add(X509Util.URI_ALT_NAME);
    }

    public boolean isNameChecking() {
        return this.checkSubjectAltNames() || this.checkSubjectDNCommonName() || this.checkSubjectDN();
    }

    public Set<Integer> getSubjectAltNameTypes() {
        return this.subjectAltNameTypes;
    }

    public boolean checkSubjectAltNames() {
        return this.checkSubjectAltNames;
    }

    public void setCheckSubjectAltNames(boolean check) {
        this.checkSubjectAltNames = check;
    }

    public boolean checkSubjectDNCommonName() {
        return this.checkSubjectDNCommonName;
    }

    public void setCheckSubjectDNCommonName(boolean check) {
        this.checkSubjectDNCommonName = check;
    }

    public boolean checkSubjectDN() {
        return this.checkSubjectDN;
    }

    public void setCheckSubjectDN(boolean check) {
        this.checkSubjectDN = check;
    }

    public X500DNHandler getX500DNHandler() {
        return this.x500DNHandler;
    }

    public void setX500DNHandler(X500DNHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("X500DNHandler may not be null");
        }
        this.x500DNHandler = handler;
    }

    protected boolean checkName(X509Credential untrustedCredential, Set<String> trustedNames) {
        if (!this.isNameChecking() || trustedNames == null || trustedNames.isEmpty()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking untrusted " + untrustedCredential.getEntityId() + " credential against trusted names"));
            log.debug((Object)("Trusted names being evaluated are: " + trustedNames.toString()));
        }
        X509Certificate entityCertificate = untrustedCredential.getEntityCertificate();
        if (this.checkSubjectAltNames() && this.processSubjectAltNames(entityCertificate, trustedNames)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Untrusted credential for entity " + untrustedCredential.getEntityId() + " passed name checking based on subject alt names."));
            }
            return true;
        }
        if (this.checkSubjectDNCommonName() && this.processSubjectDNCommonName(entityCertificate, trustedNames)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Untrusted credential for entity " + untrustedCredential.getEntityId() + " passed name checking based on subject DN's common name."));
            }
            return true;
        }
        if (this.checkSubjectDN() && this.processSubjectDN(entityCertificate, trustedNames)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Untrusted credential for entity " + untrustedCredential.getEntityId() + " passed name checking based on matching subject DN."));
            }
            return true;
        }
        log.error((Object)("Untrusted credential for entity " + untrustedCredential.getEntityId() + " failed name checking."));
        return false;
    }

    protected boolean processSubjectDNCommonName(X509Certificate untrustedCertificate, Set<String> trustedNames) {
        X500Principal subjectPrincipal = untrustedCertificate.getSubjectX500Principal();
        List<String> commonNames = X509Util.getCommonNames(subjectPrincipal);
        if (commonNames == null || commonNames.isEmpty()) {
            return false;
        }
        String commonName = commonNames.get(0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extracted common name from certificate: " + commonName));
        }
        if (DatatypeHelper.isEmpty(commonName)) {
            return false;
        }
        if (trustedNames.contains(commonName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Matched subject DN common name to trusted names: " + commonName));
            }
            return true;
        }
        return false;
    }

    protected boolean processSubjectDN(X509Certificate untrustedCertificate, Set<String> trustedNames) {
        X500Principal subjectPrincipal = untrustedCertificate.getSubjectX500Principal();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extracted X500Principal from certificate: " + this.x500DNHandler.getName(subjectPrincipal)));
        }
        for (String trustedName : trustedNames) {
            X500Principal keyNamePrincipal = null;
            try {
                keyNamePrincipal = this.x500DNHandler.parse(trustedName);
                if (!subjectPrincipal.equals(keyNamePrincipal)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Matched subject DN to trusted names: " + this.x500DNHandler.getName(subjectPrincipal)));
                }
                return true;
            }
            catch (IllegalArgumentException e) {
            }
        }
        return false;
    }

    protected boolean processSubjectAltNames(X509Certificate untrustedCertificate, Set<String> trustedNames) {
        Integer[] nameTypes = new Integer[this.subjectAltNameTypes.size()];
        this.subjectAltNameTypes.toArray(nameTypes);
        List altNames = X509Util.getAltNames(untrustedCertificate, nameTypes);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extracted subject alt names from certificate: " + altNames));
        }
        for (Object altName : altNames) {
            if (!trustedNames.contains(altName)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Matched subject alt name to trusted names: " + altName.toString()));
            }
            return true;
        }
        return false;
    }

    public boolean pkixValidate(PKIXValidationInformation validationInfo, Set<String> trustedNames, X509Credential untrustedCredential) throws SecurityException {
        if (!this.checkName(untrustedCredential, trustedNames)) {
            log.debug((Object)"Name checking failed, aborting PKIX validation");
            return false;
        }
        return this.pkixValidate(validationInfo, untrustedCredential);
    }

    public boolean pkixValidate(PKIXValidationInformation validationInfo, X509Credential untrustedCredential) throws SecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attempting PKIX path validation on untrusted credential " + untrustedCredential.getEntityId()));
        }
        try {
            PKIXBuilderParameters params = this.getPKIXBuilderParameters(validationInfo, untrustedCredential);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Building certificate validation path");
            }
            CertPathBuilder builder = CertPathBuilder.getInstance("PKIX");
            PKIXCertPathBuilderResult buildResult = (PKIXCertPathBuilderResult)builder.build(params);
            CertPath certificatePath = buildResult.getCertPath();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Validating given entity credentials using built PKIX validator");
            }
            CertPathValidator validator = CertPathValidator.getInstance("PKIX");
            validator.validate(certificatePath, params);
            if (log.isDebugEnabled()) {
                log.debug((Object)("PKIX validation of credentials for " + untrustedCredential.getEntityId() + " successful"));
            }
            return true;
        }
        catch (CertPathValidatorException e) {
            log.error((Object)("PKIX validation of credentials for entity " + untrustedCredential + " failed."), (Throwable)e);
            return false;
        }
        catch (GeneralSecurityException e) {
            log.error((Object)"Unable to create PKIX validator", (Throwable)e);
            throw new SecurityException("Unable to create PKIX validator", e);
        }
    }

    protected PKIXBuilderParameters getPKIXBuilderParameters(PKIXValidationInformation validationInfo, X509Credential untrustedCredential) throws GeneralSecurityException {
        Set<TrustAnchor> trustAnchors = this.getTrustAnchors(validationInfo);
        if (trustAnchors.size() < 1) {
            throw new GeneralSecurityException("Unable to validate signature, no trust anchors found in the PKIX validation information");
        }
        X509CertSelector selector = new X509CertSelector();
        selector.setCertificate(untrustedCredential.getEntityCertificate());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Adding trust anchors to PKIX validator parameters");
        }
        PKIXBuilderParameters params = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting verification depth to " + validationInfo.getVerificationDepth()));
        }
        params.setMaxPathLength(validationInfo.getVerificationDepth());
        params.addCertStore(this.buildCertStore(validationInfo, untrustedCredential));
        if (validationInfo.getCRLs() == null || validationInfo.getCRLs().size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No CRLs available in PKIX validation information, disable revocation checking");
            }
            params.setRevocationEnabled(false);
        }
        return params;
    }

    protected Set<TrustAnchor> getTrustAnchors(PKIXValidationInformation validationInfo) {
        Collection<X509Certificate> trustChain = validationInfo.getTrustChain();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Constructring trust anchors");
        }
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        for (X509Certificate cert : trustChain) {
            trustAnchors.add(new TrustAnchor(cert, null));
        }
        return trustAnchors;
    }

    protected CertStore buildCertStore(PKIXValidationInformation validationInfo, X509Credential untrustedCredential) throws GeneralSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating cert store to use during path validation");
            log.debug((Object)"Adding entity ceritifcate chain to certificate store");
        }
        ArrayList<X509Certificate> storeMaterial = new ArrayList<X509Certificate>(untrustedCredential.getEntityCertificateChain());
        storeMaterial.addAll(validationInfo.getTrustChain());
        return CertStore.getInstance("Collection", new CollectionCertStoreParameters(storeMaterial));
    }
}

