/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.x509;

import java.util.Set;
import org.apache.log4j.Logger;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.x509.PKIXCriteriaSet;
import org.opensaml.xml.security.x509.PKIXTrustEngine;
import org.opensaml.xml.security.x509.PKIXTrustEvaluator;
import org.opensaml.xml.security.x509.PKIXValidationInformation;
import org.opensaml.xml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.xml.security.x509.X509Credential;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PKIXX509CredentialTrustEngine
implements PKIXTrustEngine<X509Credential> {
    private static Logger log = Logger.getLogger(PKIXX509CredentialTrustEngine.class);
    private PKIXValidationInformationResolver pkixResolver;
    private PKIXTrustEvaluator pkixTrustEvaluator;

    public PKIXX509CredentialTrustEngine(PKIXValidationInformationResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException("PKIX trust information resolver may not be null");
        }
        this.pkixResolver = resolver;
        this.pkixTrustEvaluator = new PKIXTrustEvaluator();
    }

    @Override
    public PKIXValidationInformationResolver getPKIXResolver() {
        return this.pkixResolver;
    }

    public PKIXTrustEvaluator getPKIXTrustEvaluator() {
        return this.pkixTrustEvaluator;
    }

    @Override
    public boolean validate(X509Credential untrustedCredential, CriteriaSet trustBasisCriteria) throws SecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("PKIX validating credential for entity " + untrustedCredential.getEntityId()));
        }
        if (untrustedCredential == null) {
            log.error((Object)"X.509 credential was null, unable to perform validation");
            return false;
        }
        if (untrustedCredential.getEntityCertificate() == null) {
            log.error((Object)"Untrusted X.509 credential's entity certificate was null, unable to perform validation");
            return false;
        }
        PKIXCriteriaSet pkixCriteria = SecurityHelper.getPKIXCriteria(trustBasisCriteria);
        Set<String> trustedNames = null;
        if (this.pkixTrustEvaluator.isNameChecking()) {
            if (this.pkixResolver.supportsTrustedNameResolution()) {
                trustedNames = this.pkixResolver.resolveTrustedNames(pkixCriteria);
            } else {
                log.debug((Object)"PKIX resolver does not support resolution of trusted names, skipping name checking");
            }
        }
        return this.validate(untrustedCredential, trustedNames, this.pkixResolver.resolve(pkixCriteria));
    }

    protected boolean validate(X509Credential untrustedX509Credential, Set<String> trustedNames, Iterable<PKIXValidationInformation> validationInfoSet) {
        log.debug((Object)"Beginning PKIX validation using trusted validation information");
        for (PKIXValidationInformation validationInfo : validationInfoSet) {
            if (!this.pkixTrustEvaluator.pkixValidate(validationInfo, trustedNames, untrustedX509Credential)) continue;
            return true;
        }
        return false;
    }
}

