/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.x509;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.x509.extension.SubjectKeyIdentifierStructure;
import org.opensaml.xml.security.SecurityException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509Util {
    public static final String CN_OID = "2.5.4.3";
    public static final Integer OTHER_ALT_NAME = new Integer(0);
    public static final Integer RFC822_ALT_NAME = new Integer(1);
    public static final Integer DNS_ALT_NAME = new Integer(2);
    public static final Integer X400ADDRESS_ALT_NAME = new Integer(3);
    public static final Integer DIRECTORY_ALT_NAME = new Integer(4);
    public static final Integer EDI_PARTY_ALT_NAME = new Integer(5);
    public static final Integer URI_ALT_NAME = new Integer(6);
    public static final Integer IP_ADDRESS_ALT_NAME = new Integer(7);
    public static final Integer REGISTERED_ID_ALT_NAME = new Integer(8);
    private static Logger log = Logger.getLogger(X509Util.class);

    protected X509Util() {
    }

    public static List<String> getCommonNames(X500Principal dn) {
        if (dn == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extracting CNs from the following DN: " + dn.toString()));
        }
        LinkedList<String> commonNames = new LinkedList<String>();
        try {
            ASN1InputStream asn1Stream = new ASN1InputStream(dn.getEncoded());
            DERObject parent = asn1Stream.readObject();
            String cn = null;
            for (int i = 0; i < ((DERSequence)parent).size(); ++i) {
                DERObject dnComponent = ((DERSequence)parent).getObjectAt(i).getDERObject();
                if (!(dnComponent instanceof DERSet)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"No DN components.");
                    continue;
                }
                for (int j = 0; j < ((DERSet)dnComponent).size(); ++j) {
                    DERObjectIdentifier componentId;
                    DERSequence grandChild = (DERSequence)((DERSet)dnComponent).getObjectAt(j).getDERObject();
                    if (grandChild.getObjectAt(0) == null || !(grandChild.getObjectAt(0).getDERObject() instanceof DERObjectIdentifier) || !CN_OID.equals((componentId = (DERObjectIdentifier)grandChild.getObjectAt(0).getDERObject()).getId()) || grandChild.getObjectAt(1) == null || !(grandChild.getObjectAt(1).getDERObject() instanceof DERString)) continue;
                    cn = ((DERString)grandChild.getObjectAt(1).getDERObject()).getString();
                    commonNames.add(cn);
                }
            }
            asn1Stream.close();
            return commonNames;
        }
        catch (IOException e) {
            log.error((Object)("Unable to extract common names from DN: ASN.1 parsing failed: " + e));
            return null;
        }
    }

    public static List getAltNames(X509Certificate certificate, Integer[] nameTypes) {
        if (certificate == null) {
            return null;
        }
        LinkedList names = new LinkedList();
        try {
            Collection<List<?>> altNames = certificate.getSubjectAlternativeNames();
            if (altNames != null) {
                block2: for (List<?> altName : altNames) {
                    for (int i = 0; i < nameTypes.length; ++i) {
                        if (!altName.get(0).equals(nameTypes[i])) continue;
                        names.add(altName.get(1));
                        continue block2;
                    }
                }
            }
        }
        catch (CertificateParsingException e1) {
            log.error((Object)("Encountered an problem trying to extract Subject Alternate Name from supplied certificate: " + e1));
        }
        return names;
    }

    public static List getSubjectNames(X509Certificate certificate, Integer[] altNameTypes) {
        LinkedList<String> issuerNames = new LinkedList<String>();
        List<String> entityCertCNs = X509Util.getCommonNames(certificate.getSubjectX500Principal());
        issuerNames.add(entityCertCNs.get(0));
        issuerNames.addAll(X509Util.getAltNames(certificate, altNameTypes));
        return issuerNames;
    }

    public static byte[] getSubjectKeyIdentifier(X509Certificate certificate) {
        byte[] derValue = certificate.getExtensionValue(X509Extensions.SubjectKeyIdentifier.getId());
        if (derValue == null || derValue.length == 0) {
            return null;
        }
        SubjectKeyIdentifierStructure ski = null;
        try {
            ski = new SubjectKeyIdentifierStructure(derValue);
        }
        catch (IOException e) {
            log.error((Object)("Unable to extract subject key identifier from certificate: ASN.1 parsing failed: " + e));
            return null;
        }
        if (ski != null) {
            return ski.getKeyIdentifier();
        }
        return null;
    }

    public static Key getKey(File keyFile, String passphrase) throws SecurityException {
        if (keyFile.exists() && keyFile.canRead()) {
            try {
                return X509Util.getKey(new FileInputStream(keyFile), passphrase);
            }
            catch (FileNotFoundException e) {
                throw new SecurityException("Key file " + keyFile.getAbsolutePath() + " does not exist", e);
            }
        }
        return null;
    }

    public static Key getKey(InputStream keyStream, String passphrase) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ENCODING_FORMAT {
        PEM,
        DER;

    }
}

