/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.signature;

import java.security.Key;
import org.apache.log4j.Logger;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.impl.SignatureImpl;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureValidator
implements Validator<Signature> {
    private static Logger log = Logger.getLogger(SignatureValidator.class);
    private Credential validationCredential;

    public SignatureValidator(Credential validatingCredential) {
        this.validationCredential = validatingCredential;
    }

    @Override
    public void validate(Signature signature) throws ValidationException {
        log.debug((Object)"Attempting to validate signature using key from supplied credential");
        XMLSignature xmlSig = this.buildSignature(signature);
        Key validationKey = SecurityHelper.extractVerificationKey(this.validationCredential);
        if (validationKey == null) {
            log.debug((Object)"Supplied credential contained no key suitable for signature validation");
            throw new ValidationException("No key available to validate signature");
        }
        try {
            if (xmlSig.checkSignatureValue(validationKey)) {
                log.debug((Object)"Signature validated with key from supplied credential");
                return;
            }
        }
        catch (XMLSignatureException e) {
            throw new ValidationException("Unable to evaluate key against signature", (Exception)((Object)e));
        }
        log.debug((Object)"Signature did not validate against the credential's key");
        throw new ValidationException("Signature did not validate against the credential's key");
    }

    protected XMLSignature buildSignature(Signature signature) {
        log.debug((Object)"Creating XMLSignature object");
        return ((SignatureImpl)signature).getXMLSignature();
    }
}

