/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.signature.impl;

import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.impl.SignatureImpl;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Element;

public class SignatureUnmarshaller
implements Unmarshaller {
    private static Logger log = Logger.getLogger(SignatureUnmarshaller.class);

    public SignatureUnmarshaller() {
        if (!Init.isInitialized()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Initializing XML security library");
            }
            Init.init();
        }
    }

    public Signature unmarshall(Element signatureElement) throws UnmarshallingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting to unmarshall XMLSecSignatureImpl element");
        }
        SignatureImpl signature = new SignatureImpl(signatureElement.getNamespaceURI(), signatureElement.getLocalName(), signatureElement.getPrefix());
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Constructing XMLSignature object");
            }
            XMLSignature xmlSignature = new XMLSignature(signatureElement, "");
            SignedInfo signedInfo = xmlSignature.getSignedInfo();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Adding Canonicalization, Digest, and XMLSecSignatureImpl methods to signing context");
            }
            signature.setCanonicalizationAlgorithm(signedInfo.getCanonicalizationMethodURI());
            signature.setSignatureAlgorithm(signedInfo.getSignatureMethodURI());
            signature.setHMACOutputLength(this.getHMACOutputLengthValue(signedInfo.getSignatureMethodElement()));
            org.apache.xml.security.keys.KeyInfo xmlSecKeyInfo = xmlSignature.getKeyInfo();
            if (xmlSecKeyInfo != null) {
                Unmarshaller unmarshaller = Configuration.getUnmarshallerFactory().getUnmarshaller(xmlSecKeyInfo.getElement());
                KeyInfo keyInfo = (KeyInfo)unmarshaller.unmarshall(xmlSecKeyInfo.getElement());
                signature.setKeyInfo(keyInfo);
            }
            signature.setXMLSignature(xmlSignature);
            signature.setDOM(signatureElement);
            return signature;
        }
        catch (XMLSecurityException e) {
            throw new UnmarshallingException("Unable to unmarshall XMLSecSignatureImpl", (Exception)((Object)e));
        }
    }

    private Integer getHMACOutputLengthValue(Element signatureMethodElement) {
        Element hmacElement;
        String value;
        if (signatureMethodElement == null) {
            return null;
        }
        List<Element> children = XMLHelper.getChildElementsByTagNameNS(signatureMethodElement, "http://www.w3.org/2000/09/xmldsig#", "HMACOutputLength");
        if (!children.isEmpty() && (value = DatatypeHelper.safeTrimOrNullString((hmacElement = children.get(0)).getTextContent())) != null) {
            return new Integer(value);
        }
        return null;
    }
}

