/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.util;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.util.DatatypeHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLHelper {
    private XMLHelper() {
    }

    public static boolean hasXSIType(Element e) {
        return e != null && e.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "type") != null;
    }

    public static QName getXSIType(Element e) {
        if (XMLHelper.hasXSIType(e)) {
            String localPart;
            Attr attribute = e.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            String attributeValue = attribute.getTextContent().trim();
            StringTokenizer tokenizer = new StringTokenizer(attributeValue, ":");
            String prefix = null;
            if (tokenizer.countTokens() > 1) {
                prefix = tokenizer.nextToken();
                localPart = tokenizer.nextToken();
            } else {
                localPart = tokenizer.nextToken();
            }
            return XMLHelper.constructQName(e.lookupNamespaceURI(prefix), localPart, prefix);
        }
        return null;
    }

    public static Attr getIdAttribute(Element domElement) {
        if (!domElement.hasAttributes()) {
            return null;
        }
        NamedNodeMap attributes = domElement.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            if (!attribute.isId()) continue;
            return attribute;
        }
        return null;
    }

    public static QName getNodeQName(Node domNode) {
        if (domNode != null) {
            return XMLHelper.constructQName(domNode.getNamespaceURI(), domNode.getLocalName(), domNode.getPrefix());
        }
        return null;
    }

    public static Attr constructAttribute(Document owningDocument, QName attributeName) {
        return XMLHelper.constructAttribute(owningDocument, attributeName.getNamespaceURI(), attributeName.getLocalPart(), attributeName.getPrefix());
    }

    public static Attr constructAttribute(Document document, String namespaceURI, String localName, String prefix) {
        String trimmedLocalName = DatatypeHelper.safeTrimOrNullString(localName);
        if (trimmedLocalName == null) {
            throw new IllegalArgumentException("Local name may not be null or empty");
        }
        String trimmedPrefix = DatatypeHelper.safeTrimOrNullString(prefix);
        String qualifiedName = trimmedPrefix != null ? trimmedPrefix + ":" + DatatypeHelper.safeTrimOrNullString(trimmedLocalName) : DatatypeHelper.safeTrimOrNullString(trimmedLocalName);
        if (DatatypeHelper.isEmpty(namespaceURI)) {
            return document.createAttribute(qualifiedName);
        }
        return document.createAttributeNS(namespaceURI, qualifiedName);
    }

    public static QName getAttributeValueAsQName(Attr attribute) {
        if (attribute == null || DatatypeHelper.isEmpty(attribute.getValue())) {
            return null;
        }
        String attributeValue = attribute.getTextContent();
        String[] valueComponents = attributeValue.split(":");
        if (valueComponents.length == 1) {
            return XMLHelper.constructQName(attribute.lookupNamespaceURI(null), valueComponents[0], null);
        }
        return XMLHelper.constructQName(attribute.lookupNamespaceURI(valueComponents[0]), valueComponents[1], valueComponents[0]);
    }

    public static Boolean getAttributeValueAsBoolean(Attr attribute) {
        String valueStr = attribute.getValue();
        if (valueStr.equals("0") || valueStr.equals("false")) {
            return Boolean.FALSE;
        }
        if (valueStr.equals("1") || valueStr.equals("true")) {
            return Boolean.TRUE;
        }
        return null;
    }

    public static QName getElementContentAsQName(Element element) {
        if (element == null) {
            return null;
        }
        String elementContent = null;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            elementContent = DatatypeHelper.safeTrimOrNullString(((Text)node).getWholeText());
            break;
        }
        if (elementContent == null) {
            return null;
        }
        String[] valueComponents = elementContent.split(":");
        if (valueComponents.length == 1) {
            return XMLHelper.constructQName(element.lookupNamespaceURI(null), valueComponents[0], null);
        }
        return XMLHelper.constructQName(element.lookupNamespaceURI(valueComponents[0]), valueComponents[1], valueComponents[0]);
    }

    public static QName constructQName(String namespaceURI, String localName, String prefix) {
        if (DatatypeHelper.isEmpty(prefix)) {
            return new QName(namespaceURI, localName);
        }
        if (DatatypeHelper.isEmpty(namespaceURI)) {
            return new QName(localName);
        }
        return new QName(namespaceURI, localName, prefix);
    }

    public static QName constructQName(String qname, XMLObject owningObject) {
        String name;
        String nsPrefix;
        Element objectDOM = owningObject.getDOM();
        if (qname.indexOf(":") > -1) {
            StringTokenizer qnameTokens = new StringTokenizer(qname, ":");
            nsPrefix = qnameTokens.nextToken();
            name = qnameTokens.nextToken();
        } else {
            nsPrefix = "";
            name = qname;
        }
        String nsURI = XMLHelper.lookupNamespaceURI(objectDOM, nsPrefix);
        return XMLHelper.constructQName(nsURI, name, nsPrefix);
    }

    public static Element constructElement(Document document, QName elementName) {
        return XMLHelper.constructElement(document, elementName.getNamespaceURI(), elementName.getLocalPart(), elementName.getPrefix());
    }

    public static Element constructElement(Document document, String namespaceURI, String localName, String prefix) {
        String trimmedLocalName = DatatypeHelper.safeTrimOrNullString(localName);
        if (trimmedLocalName == null) {
            throw new IllegalArgumentException("Local name may not be null or empty");
        }
        String trimmedPrefix = DatatypeHelper.safeTrimOrNullString(prefix);
        String qualifiedName = trimmedPrefix != null ? trimmedPrefix + ":" + DatatypeHelper.safeTrimOrNullString(trimmedLocalName) : DatatypeHelper.safeTrimOrNullString(trimmedLocalName);
        if (!DatatypeHelper.isEmpty(namespaceURI)) {
            return document.createElementNS(namespaceURI, qualifiedName);
        }
        return document.createElementNS(null, qualifiedName);
    }

    public static void appendChildElement(Element parentElement, Element childElement) {
        Document parentDocument = parentElement.getOwnerDocument();
        XMLHelper.adoptElement(childElement, parentDocument);
        parentElement.appendChild(childElement);
    }

    public static void adoptElement(Element adoptee, Document adopter) {
        if (!adoptee.getOwnerDocument().equals(adopter)) {
            adopter.adoptNode(adoptee);
        }
    }

    public static void appendTextContent(Element domElement, String textContent) {
        if (textContent == null) {
            return;
        }
        Document parentDocument = domElement.getOwnerDocument();
        Text textNode = parentDocument.createTextNode(textContent);
        domElement.appendChild(textNode);
    }

    public static void appendNamespaceDecleration(Element domElement, String namespaceURI, String prefix) {
        String nsURI = DatatypeHelper.safeTrimOrNullString(namespaceURI);
        String nsPrefix = DatatypeHelper.safeTrimOrNullString(prefix);
        String attributeName = nsPrefix == null ? "xmlns" : "xmlns:" + nsPrefix;
        String attributeValue = nsURI == null ? "" : nsURI;
        domElement.setAttributeNS("http://www.w3.org/2000/xmlns/", attributeName, attributeValue);
    }

    public static String lookupNamespaceURI(Element startingElement, String prefix) {
        return XMLHelper.lookupNamespaceURI(startingElement, null, prefix);
    }

    public static String lookupNamespaceURI(Element startingElement, Element stopingElement, String prefix) {
        Element ancestor;
        if (startingElement == stopingElement) {
            return null;
        }
        if (startingElement.hasAttributes()) {
            NamedNodeMap map = startingElement.getAttributes();
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = map.item(i);
                String attrPrefix = attr.getPrefix();
                String value = attr.getNodeValue();
                String namespaceURI = attr.getNamespaceURI();
                if (namespaceURI == null || !namespaceURI.equals("http://www.w3.org/2000/xmlns/")) continue;
                if (prefix == null && attr.getNodeName().equals("xmlns")) {
                    return value;
                }
                if (attrPrefix == null || !attrPrefix.equals("xmlns") || !attr.getLocalName().equals(prefix)) continue;
                return value;
            }
        }
        if ((ancestor = XMLHelper.getElementAncestor(startingElement)) != null) {
            return XMLHelper.lookupNamespaceURI(ancestor, stopingElement, prefix);
        }
        return null;
    }

    public static String lookupPrefix(Element startingElement, String namespaceURI) {
        return XMLHelper.lookupPrefix(startingElement, null, namespaceURI);
    }

    public static String lookupPrefix(Element startingElement, Element stopingElement, String namespaceURI) {
        Element ancestor;
        if (startingElement == stopingElement) {
            return null;
        }
        if (startingElement.hasAttributes()) {
            NamedNodeMap map = startingElement.getAttributes();
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                String localname;
                String foundNamespace;
                Node attr = map.item(i);
                String attrPrefix = attr.getPrefix();
                String value = attr.getNodeValue();
                String namespace = attr.getNamespaceURI();
                if (namespace == null || !namespace.equals("http://www.w3.org/2000/xmlns/") || !attr.getNodeName().equals("xmlns") && (attrPrefix == null || !attrPrefix.equals("xmlns") || !value.equals(namespaceURI)) || (foundNamespace = startingElement.lookupNamespaceURI(localname = attr.getLocalName())) == null || !foundNamespace.equals(namespaceURI)) continue;
                return localname;
            }
        }
        if ((ancestor = XMLHelper.getElementAncestor(startingElement)) != null) {
            return XMLHelper.lookupPrefix(ancestor, stopingElement, namespaceURI);
        }
        return null;
    }

    public static List<Element> getChildElementsByTagNameNS(Element root, String namespaceURI, String localName) {
        ArrayList<Element> children = new ArrayList<Element>();
        NodeList childNodes = root.getChildNodes();
        int numOfNodes = childNodes.getLength();
        for (int i = 0; i < numOfNodes; ++i) {
            Element e;
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1 || !(e = (Element)childNode).getNamespaceURI().equals(namespaceURI) || !e.getLocalName().equals(localName)) continue;
            children.add(e);
        }
        return children;
    }

    public static List<Element> getChildElementsByTagName(Element root, String localName) {
        ArrayList<Element> children = new ArrayList<Element>();
        NodeList childNodes = root.getChildNodes();
        int numOfNodes = childNodes.getLength();
        for (int i = 0; i < numOfNodes; ++i) {
            Element e;
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1 || !(e = (Element)childNode).getLocalName().equals(localName)) continue;
            children.add(e);
        }
        return children;
    }

    public static Map<QName, List<Element>> getChildElements(Element root) {
        HashMap<QName, List<Element>> children = new HashMap<QName, List<Element>>();
        NodeList childNodes = root.getChildNodes();
        int numOfNodes = childNodes.getLength();
        for (int i = 0; i < numOfNodes; ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1) continue;
            Element e = (Element)childNode;
            QName qname = XMLHelper.getNodeQName(e);
            ArrayList<Element> elements = (ArrayList<Element>)children.get(qname);
            if (elements == null) {
                elements = new ArrayList<Element>();
                children.put(qname, elements);
            }
            elements.add(e);
        }
        return children;
    }

    public static Element getElementAncestor(Node currentNode) {
        Node parent = currentNode.getParentNode();
        if (parent != null) {
            short type = parent.getNodeType();
            if (type == 1) {
                return (Element)parent;
            }
            return XMLHelper.getElementAncestor(parent);
        }
        return null;
    }

    public static String nodeToString(Node node) {
        StringWriter writer = new StringWriter();
        XMLHelper.writeNode(node, writer);
        return writer.toString();
    }

    public static String prettyPrintXML(Node node) {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        try {
            Transformer serializer = tfactory.newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
            StringWriter output = new StringWriter();
            serializer.transform(new DOMSource(node.getOwnerDocument()), new StreamResult(output));
            return output.toString();
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void writeNode(Node node, Writer output) {
        DOMImplementation domImpl = node.getOwnerDocument().getImplementation();
        DOMImplementationLS domImplLS = (DOMImplementationLS)domImpl.getFeature("LS", "3.0");
        LSSerializer serializer = domImplLS.createLSSerializer();
        LSOutput serializerOut = domImplLS.createLSOutput();
        serializerOut.setCharacterStream(output);
        serializer.write(node, serializerOut);
    }

    public static String qnameToContentString(QName qname) {
        StringBuffer buf = new StringBuffer();
        if (qname.getPrefix() != null) {
            buf.append(qname.getPrefix());
            buf.append(":");
        }
        buf.append(qname.getLocalPart());
        return buf.toString();
    }

    public static void rootNamespaces(Element domElement) throws XMLParserException {
        XMLHelper.rootNamespaces(domElement, domElement);
    }

    private static void rootNamespaces(Element domElement, Element upperNamespaceSearchBound) throws XMLParserException {
        String namespaceURI = null;
        String namespacePrefix = null;
        namespacePrefix = domElement.getPrefix();
        namespaceURI = DatatypeHelper.isEmpty(namespacePrefix) ? XMLHelper.lookupNamespaceURI(upperNamespaceSearchBound, "") : XMLHelper.lookupNamespaceURI(domElement, upperNamespaceSearchBound, namespacePrefix);
        if (namespaceURI == null) {
            namespaceURI = XMLHelper.lookupNamespaceURI(upperNamespaceSearchBound, null, namespacePrefix);
            if (namespaceURI == null) {
                throw new XMLParserException("Unable to resolve namespace prefix " + namespacePrefix + " found on element " + XMLHelper.getNodeQName(domElement));
            }
            XMLHelper.appendNamespaceDecleration(domElement, namespaceURI, namespacePrefix);
        }
        NamedNodeMap attributes = domElement.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            namespacePrefix = null;
            namespaceURI = null;
            Node attributeNode = attributes.item(i);
            if (attributeNode.getNodeType() != 2 || DatatypeHelper.isEmpty(namespacePrefix = attributeNode.getPrefix()) || namespacePrefix.equals("xmlns") || namespacePrefix.equals("xml") || (namespaceURI = XMLHelper.lookupNamespaceURI(domElement, upperNamespaceSearchBound, namespacePrefix)) != null) continue;
            namespaceURI = XMLHelper.lookupNamespaceURI(upperNamespaceSearchBound, null, namespacePrefix);
            if (namespaceURI == null) {
                throw new XMLParserException("Unable to resolve namespace prefix " + namespacePrefix + " found on attribute " + XMLHelper.getNodeQName(attributeNode) + " found on element " + XMLHelper.getNodeQName(domElement));
            }
            XMLHelper.appendNamespaceDecleration(domElement, namespaceURI, namespacePrefix);
        }
        NodeList childNodes = domElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1) continue;
            XMLHelper.rootNamespaces((Element)childNode, upperNamespaceSearchBound);
        }
    }

    public static boolean isElementNamed(Element e, String ns, String localName) {
        return e != null && DatatypeHelper.safeEquals(ns, e.getNamespaceURI()) && DatatypeHelper.safeEquals(localName, e.getLocalName());
    }

    public static Element getFirstChildElement(Node n) {
        Node child;
        for (child = n.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
        }
        if (child != null) {
            return (Element)child;
        }
        return null;
    }

    public static Element getNextSiblingElement(Node n) {
        Node sib;
        for (sib = n.getNextSibling(); sib != null && sib.getNodeType() != 1; sib = sib.getNextSibling()) {
        }
        if (sib != null) {
            return (Element)sib;
        }
        return null;
    }

    public static long durationToLong(String duration) {
        Duration xmlDuration = DatatypeHelper.getDataTypeFactory().newDuration(duration);
        return xmlDuration.getTimeInMillis(new GregorianCalendar());
    }

    public static String longToDuration(long duration) {
        Duration xmlDuration = DatatypeHelper.getDataTypeFactory().newDuration(duration);
        return xmlDuration.toString();
    }
}

