/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorSuite {
    private static Logger log = Logger.getLogger(ValidatorSuite.class);
    private String id;
    private Map<QName, List<Validator>> validators = new ConcurrentHashMap<QName, List<Validator>>();

    public ValidatorSuite(String suiteId) {
        this.id = suiteId;
    }

    public String getId() {
        return this.id;
    }

    public void validate(XMLObject xmlObject) throws ValidationException {
        if (xmlObject == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Beginning to verify XMLObject " + xmlObject.getElementQName() + " and its children"));
        }
        this.performValidation(xmlObject);
        List<XMLObject> children = xmlObject.getOrderedChildren();
        if (children != null) {
            for (XMLObject child : children) {
                this.validate(child);
            }
        }
    }

    public List<Validator> getValidators(QName xmlObjectTarget) {
        return Collections.unmodifiableList(this.validators.get(xmlObjectTarget));
    }

    public void registerValidator(QName xmlObjectTarget, Validator validator) {
        List<Validator> targetValidators = this.validators.get(xmlObjectTarget);
        if (targetValidators == null) {
            targetValidators = new ArrayList<Validator>();
            this.validators.put(xmlObjectTarget, targetValidators);
        }
        targetValidators.add(validator);
    }

    public void deregisterValidator(QName xmlObjectTarget, Validator validator) {
        List<Validator> targetValidators = this.validators.get(xmlObjectTarget);
        if (targetValidators != null) {
            targetValidators.remove(validator);
        }
    }

    private void performValidation(XMLObject xmlObject) throws ValidationException {
        QName schemaType = xmlObject.getSchemaType();
        if (schemaType != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Validating XMLObject " + xmlObject.getElementQName() + " against validators registered under its schema type, " + schemaType));
            }
            this.performValidation(schemaType, xmlObject);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Validating XMLObject " + xmlObject.getElementQName() + " against validators registered under its element QName"));
        }
        this.performValidation(xmlObject.getElementQName(), xmlObject);
    }

    private void performValidation(QName validatorSetKey, XMLObject xmlObject) throws ValidationException {
        List<Validator> elementQNameValidators = this.validators.get(validatorSetKey);
        if (elementQNameValidators != null) {
            for (Validator validator : elementQNameValidators) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Validating XMLObject " + xmlObject.getElementQName() + " against Validator " + validator.getClass().getName()));
                }
                validator.validate(xmlObject);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No validators registered for XMLObject " + xmlObject.getElementQName() + " under QName " + validatorSetKey));
        }
    }
}

