/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.clickstream;

import com.opensymphony.clickstream.config.ConfigLoader;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class BotChecker {
    public static boolean isBot(HttpServletRequest request) {
        String remoteHost;
        List agents = ConfigLoader.getInstance().getConfig().getBotAgents();
        List hosts = ConfigLoader.getInstance().getConfig().getBotHosts();
        if (request.getRequestURI().indexOf("robots.txt") != -1) {
            return true;
        }
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null) {
            Iterator iterator = agents.iterator();
            while (iterator.hasNext()) {
                String agent = (String)iterator.next();
                if (userAgent.indexOf(agent) == -1) continue;
                return true;
            }
        }
        if ((remoteHost = request.getRemoteHost()) != null && remoteHost.length() > 0 && remoteHost.charAt(remoteHost.length() - 1) > '@') {
            Iterator iterator = hosts.iterator();
            while (iterator.hasNext()) {
                String host = (String)iterator.next();
                if (remoteHost.indexOf(host) == -1) continue;
                return true;
            }
        }
        return false;
    }
}

