/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.clickstream;

import com.opensymphony.clickstream.Clickstream;
import com.opensymphony.clickstream.logger.ClickstreamLoggerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClickstreamListener
implements ServletContextListener,
HttpSessionListener {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$clickstream$ClickstreamListener == null ? (class$com$opensymphony$clickstream$ClickstreamListener = ClickstreamListener.class$("com.opensymphony.clickstream.ClickstreamListener")) : class$com$opensymphony$clickstream$ClickstreamListener));
    public static final String CLICKSTREAMS_ATTRIBUTE_KEY = "clickstreams";
    private Map clickstreams = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$com$opensymphony$clickstream$ClickstreamListener;

    public ClickstreamListener() {
        log.debug((Object)"ClickstreamLogger constructed");
    }

    public void contextInitialized(ServletContextEvent sce) {
        log.debug((Object)"ServletContext Initialised");
        sce.getServletContext().setAttribute(CLICKSTREAMS_ATTRIBUTE_KEY, (Object)this.clickstreams);
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    public void sessionCreated(HttpSessionEvent hse) {
        HttpSession session = hse.getSession();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Session " + session.getId() + " was created, adding a new clickstream."));
        }
        Clickstream clickstream = new Clickstream();
        session.setAttribute("clickstream", (Object)clickstream);
        this.clickstreams.put(session.getId(), clickstream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent hse) {
        HttpSession session = hse.getSession();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Session " + session.getId() + " was destroyed, logging the clickstream and removing it."));
        }
        Clickstream stream = (Clickstream)this.clickstreams.get(session.getId());
        try {
            if (stream.getSession() != null) {
                ClickstreamLoggerFactory.getLogger().log(stream);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.clickstreams.remove(session.getId());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

