/*
 * Decompiled with CFR 0.152.
 */
package http.utils.multipartrequest;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MultipartRequest {
    private static String charEncoding = "ISO-8859-1";
    private PrintWriter debug;
    private Hashtable htParameters;
    private Hashtable htFiles;
    private String strBoundary;
    private File fileOutPutDirectory;
    private boolean loadIntoMemory = false;
    private long intContentLength = -1L;
    private long intTotalRead = -1L;
    public static final int MAX_READ_BYTES = 0x200000;
    public static final int READ_LINE_BLOCK = 131072;
    private byte[] blockOfBytes;
    public static final int FILENAME = 0;
    public static final int CONTENT_TYPE = 1;
    public static final int SIZE = 2;
    public static final int CONTENTS = 3;

    public static synchronized void setEncoding(String string) throws UnsupportedEncodingException {
        if (string == null || string.trim() == "") {
            charEncoding = System.getProperty("file.encoding");
            return;
        }
        new String(new byte[]{10}, string);
        charEncoding = string;
    }

    public static String getEncoding() {
        return charEncoding;
    }

    public MultipartRequest(String string, int n, InputStream inputStream, String string2) throws IllegalArgumentException, IOException {
        this(null, string, n, inputStream, string2, 0x200000);
    }

    public MultipartRequest(String string, int n, InputStream inputStream, String string2, int n2) throws IllegalArgumentException, IOException {
        this(null, string, n, inputStream, string2, n2);
    }

    public MultipartRequest(PrintWriter printWriter, String string, int n, InputStream inputStream, String string2) throws IllegalArgumentException, IOException {
        this(printWriter, string, n, inputStream, string2, 0x200000);
    }

    public MultipartRequest(PrintWriter printWriter, String string, int n, InputStream inputStream, int n2) throws IllegalArgumentException, IOException {
        this.loadIntoMemory = true;
        this.init(printWriter, string, n, inputStream, n2);
    }

    public MultipartRequest(PrintWriter printWriter, String string, int n, InputStream inputStream, String string2, int n2) throws IllegalArgumentException, IOException {
        if (string2 != null) {
            this.fileOutPutDirectory = new File(string2);
            if (!this.fileOutPutDirectory.exists()) {
                throw new IOException("Directory [" + string2 + "] is invalid.");
            }
            if (!this.fileOutPutDirectory.canWrite()) {
                throw new IOException("Directory [" + string2 + "] is readonly.");
            }
        }
        this.init(printWriter, string, n, inputStream, n2);
    }

    private void init(PrintWriter printWriter, String string, int n, InputStream inputStream, int n2) throws IllegalArgumentException, IOException {
        this.debug = printWriter;
        if (string == null || !string.startsWith("multipart/form-data") || string.indexOf("boundary=") == -1) {
            this.debug("ContentType = " + string);
            throw new IllegalArgumentException("Invalid Content Type.");
        }
        this.strBoundary = string.substring(string.indexOf("boundary=") + "boundary=".length()).trim();
        this.intContentLength = n;
        if (n > n2) {
            throw new IOException("Content Length Error (" + n + " > " + n2 + ")");
        }
        this.htParameters = new Hashtable();
        this.htFiles = new Hashtable();
        this.blockOfBytes = new byte[131072];
        this.parse(new BufferedInputStream(inputStream));
        this.blockOfBytes = null;
        this.debug = null;
        this.strBoundary = null;
    }

    public String getURLParameter(String string) {
        Object v = this.htParameters.get(string);
        if (v instanceof Vector) {
            return (String)((Vector)v).firstElement();
        }
        return (String)this.htParameters.get(string);
    }

    public Enumeration getURLParameters(String string) {
        Object v = this.htParameters.get(string);
        if (v instanceof Vector) {
            return ((Vector)v).elements();
        }
        Vector vector = new Vector();
        if (v != null) {
            vector.addElement(v);
        }
        return vector.elements();
    }

    public Enumeration getParameterNames() {
        return this.htParameters.keys();
    }

    public Enumeration getFileParameterNames() {
        return this.htFiles.keys();
    }

    public String getContentType(String string) {
        return (String)this.getFileParameter(string, 1);
    }

    public InputStream getFileContents(String string) {
        Object object = this.getFileParameter(string, 3);
        if (object != null) {
            return new ByteArrayInputStream((byte[])object);
        }
        return null;
    }

    public File getFile(String string) {
        String string2 = this.getFileSystemName(string);
        if (string2 != null && this.getFileSize(string) > 0L && this.fileOutPutDirectory != null) {
            return new File(this.fileOutPutDirectory, string2);
        }
        return null;
    }

    public String getFileSystemName(String string) {
        return (String)this.getFileParameter(string, 0);
    }

    public long getFileSize(String string) {
        Object object = this.getFileParameter(string, 2);
        if (object != null) {
            return (Long)object;
        }
        return -1L;
    }

    public Object getFileParameter(String string, int n) {
        Object[] objectArray = null;
        Object v = this.htFiles.get(string);
        objectArray = v instanceof Vector ? (Object[])((Vector)v).firstElement() : (Object[])this.htFiles.get(string);
        if (objectArray != null && n >= 0 && n <= 3) {
            return objectArray[n];
        }
        return null;
    }

    private void parse(InputStream inputStream) throws IOException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = -1;
        n = this.readLine(inputStream, this.blockOfBytes);
        String string5 = string4 = n > 0 ? new String(this.blockOfBytes, 0, n, charEncoding) : null;
        if (string4 == null || string4.indexOf(this.strBoundary) == -1) {
            throw new IOException("Invalid Form Data, no boundary encountered.");
        }
        while ((n = this.readLine(inputStream, this.blockOfBytes)) > 0) {
            string4 = new String(this.blockOfBytes, 0, n, charEncoding);
            string2 = MultipartRequest.trimQuotes(MultipartRequest.getValue("name", string4));
            string3 = MultipartRequest.trimQuotes(MultipartRequest.getValue("filename", string4));
            if (string3 == null) {
                this.readLine(inputStream, this.blockOfBytes);
                String string6 = this.readParameter(inputStream);
                this.addParameter(string2, string6);
                continue;
            }
            if (string3.length() == 0) {
                n = this.readLine(inputStream, this.blockOfBytes);
                String string7 = string4 = n > 0 ? new String(this.blockOfBytes, 0, n, charEncoding) : null;
                if (string4 != null && string4.startsWith("Content-Type:")) {
                    this.readLine(inputStream, this.blockOfBytes);
                }
                this.readLine(inputStream, this.blockOfBytes);
                this.addFileParameter(string2, new Object[]{null, null, null, null});
                this.readLine(inputStream, this.blockOfBytes);
                continue;
            }
            n = this.readLine(inputStream, this.blockOfBytes);
            string4 = n > 0 ? new String(this.blockOfBytes, 0, n, charEncoding) : null;
            string = "application/octet-stream";
            if (string4 != null && string4.startsWith("Content-Type:")) {
                string = string4.substring("Content-Type:".length()).trim();
                this.readLine(inputStream, this.blockOfBytes);
            }
            long l = -1L;
            byte[] byArray = null;
            string3 = MultipartRequest.getBasename(string3);
            if (this.loadIntoMemory) {
                byArray = this.readFile(inputStream);
                if (byArray != null) {
                    l = byArray.length;
                }
            } else {
                l = this.readAndWriteFile(inputStream, string3);
            }
            if (l > 0L) {
                this.addFileParameter(string2, new Object[]{string3, string, new Long(l), byArray});
                continue;
            }
            this.addFileParameter(string2, new Object[]{string3, null, new Long(0L), null});
        }
        return;
    }

    private void addParameter(String string, String string2) {
        Object v = this.htParameters.get(string);
        if (v instanceof Vector) {
            ((Vector)v).addElement(string2);
            return;
        }
        if (v instanceof String) {
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(v);
            vector.addElement(string2);
            this.htParameters.put(string, vector);
            return;
        }
        this.htParameters.put(string, string2);
    }

    private void addFileParameter(String string, Object[] objectArray) {
        Object v = this.htFiles.get(string);
        if (v instanceof Vector) {
            ((Vector)v).addElement(objectArray);
            return;
        }
        if (v instanceof Object[]) {
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(v);
            vector.addElement(objectArray);
            this.htFiles.put(string, vector);
            return;
        }
        this.htFiles.put(string, objectArray);
    }

    private String readParameter(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        String string = null;
        while (true) {
            if ((n = this.readLine(inputStream, this.blockOfBytes)) < 0) {
                throw new IOException("Stream ended prematurely.");
            }
            string = new String(this.blockOfBytes, 0, n, charEncoding);
            if (n < this.blockOfBytes.length && string.indexOf(this.strBoundary) != -1) break;
            stringBuffer.append(string);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(MultipartRequest.getLengthMinusEnding(stringBuffer));
        }
        return stringBuffer.toString();
    }

    private long readAndWrite(InputStream inputStream, OutputStream outputStream) throws IOException {
        long l = 0L;
        int n = -1;
        byte[] byArray = new byte[this.blockOfBytes.length];
        int n2 = 0;
        while (true) {
            if ((n = this.readLine(inputStream, this.blockOfBytes)) < 0) {
                throw new IOException("Stream ended prematurely.");
            }
            if (n < this.blockOfBytes.length && new String(this.blockOfBytes, 0, n, charEncoding).indexOf(this.strBoundary) != -1) {
                int n3;
                if (n2 == 0 || (n3 = MultipartRequest.getLengthMinusEnding(byArray, n2)) <= 0 || outputStream == null) break;
                outputStream.write(byArray, 0, n3);
                l += (long)n3;
                break;
            }
            if (n2 != 0) {
                outputStream.write(byArray, 0, n2);
                l += (long)n2;
            }
            if (outputStream == null) continue;
            System.arraycopy(this.blockOfBytes, 0, byArray, 0, n);
            n2 = n;
        }
        return l;
    }

    private long readAndWriteFile(InputStream inputStream, String string) throws IOException {
        long l;
        File file = new File(this.fileOutPutDirectory, string);
        BufferedOutputStream bufferedOutputStream = null;
        if (this.fileOutPutDirectory != null) {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        }
        if ((l = this.readAndWrite(inputStream, bufferedOutputStream)) > 0L) {
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        } else {
            bufferedOutputStream.close();
            file.delete();
        }
        return l;
    }

    private byte[] readFile(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        long l = this.readAndWrite(inputStream, byteArrayOutputStream);
        if (l > 0L) {
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    private static final int getLengthMinusEnding(byte[] byArray, int n) {
        if (byArray == null) {
            return 0;
        }
        if (n >= 2 && byArray[n - 2] == 13 && byArray[n - 1] == 10) {
            return n - 2;
        }
        if (n >= 1 && byArray[n - 1] == 10 || byArray[n - 1] == 13) {
            return n - 1;
        }
        return n;
    }

    private static final int getLengthMinusEnding(StringBuffer stringBuffer) {
        if (stringBuffer.length() >= 2 && stringBuffer.charAt(stringBuffer.length() - 2) == '\r' && stringBuffer.charAt(stringBuffer.length() - 1) == '\n') {
            return stringBuffer.length() - 2;
        }
        if (stringBuffer.length() >= 1 && stringBuffer.charAt(stringBuffer.length() - 1) == '\n' || stringBuffer.charAt(stringBuffer.length() - 1) == '\r') {
            return stringBuffer.length() - 1;
        }
        return stringBuffer.length();
    }

    private int readLine(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        if (this.intTotalRead >= this.intContentLength) {
            return -1;
        }
        int n2 = byArray.length;
        if ((long)n2 > this.intContentLength - this.intTotalRead) {
            n2 = (int)(this.intContentLength - this.intTotalRead);
        }
        if ((n = this.readLine(inputStream, byArray, 0, n2)) > 0) {
            this.intTotalRead += (long)n;
        }
        return n;
    }

    private static final String getBasename(String string) {
        if (string == null) {
            return string;
        }
        int n = string.lastIndexOf("/");
        if (n == -1 || string.lastIndexOf("\\") > n) {
            n = string.lastIndexOf("\\");
        }
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    private static final String trimQuotes(String string) {
        if (string == null || string.indexOf("\"") == -1) {
            return string;
        }
        if ((string = string.trim()).charAt(0) == '\"') {
            string = string.substring(1);
        }
        if (string.charAt(string.length() - 1) == '\"') {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static final String getValue(String string, String string2) {
        string = String.valueOf(string) + "=";
        int n = 0;
        while (n < string2.length()) {
            int n2 = string2.indexOf(string, n);
            if (n2 != -1) {
                if (n2 == 0 || Character.isWhitespace(string2.charAt(n2 - 1)) || string2.charAt(n2 - 1) == ';') {
                    int n3 = string2.indexOf(";", n2 + string.length());
                    if (n3 == -1) {
                        return string2.substring(n2 + string.length());
                    }
                    return string2.substring(n2 + string.length(), n3);
                }
                n = n2 + string.length();
                continue;
            }
            return null;
        }
        return null;
    }

    private int readLine(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 <= 0) {
            return 0;
        }
        int n4 = 0;
        while ((n3 = inputStream.read()) != -1) {
            byArray[n++] = (byte)n3;
            if (n3 == 10 || ++n4 == n2) break;
        }
        if (n4 > 0) {
            return n4;
        }
        return -1;
    }

    protected void debug(String string) {
        if (this.debug != null) {
            this.debug.println(string);
            this.debug.flush();
        }
    }

    public String getHtmlTable() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<h2>Parameters</h2>");
        stringBuffer.append("\n<table border=3><tr><td><b>Name</b></td><td><b>Value</b></td></tr>");
        Enumeration enumeration = this.getParameterNames();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            stringBuffer.append("\n<tr><td>" + (String)object2 + "</td>");
            stringBuffer.append("<td><table border=1><tr>");
            object = this.getURLParameters((String)object2);
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                stringBuffer.append("<td>" + string + "</td>");
            }
            stringBuffer.append("</tr></table></td></tr>");
        }
        stringBuffer.append("</table>");
        stringBuffer.append("<h2>File Parameters</h2>");
        stringBuffer.append("\n<table border=2><tr><td><b>Name</b></td><td><b>Filename</b></td><td><b>Path</b></td><td><b>Content Type</b></td><td><b>Size</b></td></tr>");
        object2 = this.getFileParameterNames();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            stringBuffer.append("\n<tr><td>" + (String)object + "</td>" + "<td>" + (this.getFileSystemName((String)object) != null ? this.getFileSystemName((String)object) : "") + "</td>");
            if (this.loadIntoMemory) {
                stringBuffer.append("<td>" + (this.getFileSize((String)object) > 0L ? "<i>in memory</i>" : "") + "</td>");
            } else {
                stringBuffer.append("<td>" + (this.getFile((String)object) != null ? this.getFile((String)object).getAbsolutePath() : "") + "</td>");
            }
            stringBuffer.append("<td>" + (this.getContentType((String)object) != null ? this.getContentType((String)object) : "") + "</td>" + "<td>" + (this.getFileSize((String)object) != -1L ? String.valueOf(this.getFileSize((String)object)) : "") + "</td>" + "</tr>");
        }
        stringBuffer.append("</table>");
        return stringBuffer.toString();
    }
}

