/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobPersistenceException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.core.SchedulingContext;

public class QuartzSchedulerThread
extends Thread {
    private QuartzScheduler qs;
    private QuartzSchedulerResources qsRsrcs;
    private Object pauseLock = new Object();
    private Object idleLock = new Object();
    private boolean signaled;
    private boolean paused;
    private boolean halted;
    private SchedulingContext ctxt = null;
    private Random random = new Random(System.currentTimeMillis());
    private static long DEFAULT_IDLE_WAIT_TIME = 30000L;
    private long idleWaitTime = DEFAULT_IDLE_WAIT_TIME;
    private int idleWaitVariablness = 7000;
    private long dbFailureRetryInterval = 15000L;
    static /* synthetic */ Class class$org$quartz$core$QuartzSchedulerThread;

    QuartzSchedulerThread(QuartzScheduler qs, QuartzSchedulerResources qsRsrcs, SchedulingContext ctxt) {
        this(qs, qsRsrcs, ctxt, false, 5);
    }

    QuartzSchedulerThread(QuartzScheduler qs, QuartzSchedulerResources qsRsrcs, SchedulingContext ctxt, boolean setDaemon, int threadPrio) {
        super(qs.getSchedulerThreadGroup(), qsRsrcs.getName() + "_QuartzSchedulerThread");
        this.qs = qs;
        this.qsRsrcs = qsRsrcs;
        this.ctxt = ctxt;
        this.setDaemon(setDaemon);
        this.setPriority(threadPrio);
        this.paused = true;
        this.halted = false;
        this.start();
    }

    void setIdleWaitTime(long waitTime) {
        this.idleWaitTime = waitTime;
        this.idleWaitVariablness = (int)((double)waitTime * 0.2);
    }

    private long getDbFailureRetryInterval() {
        return this.dbFailureRetryInterval;
    }

    public void setDbFailureRetryInterval(long dbFailureRetryInterval) {
        this.dbFailureRetryInterval = dbFailureRetryInterval;
    }

    private long getRandomizedIdleWaitTime() {
        return this.idleWaitTime - (long)this.random.nextInt(this.idleWaitVariablness);
    }

    void togglePause(boolean pause) {
        Object object = this.pauseLock;
        synchronized (object) {
            this.paused = pause;
            if (this.paused) {
                this.signalSchedulingChange();
            } else {
                this.pauseLock.notify();
            }
        }
    }

    void halt() {
        Object object = this.pauseLock;
        synchronized (object) {
            this.halted = true;
            if (this.paused) {
                this.pauseLock.notify();
            } else {
                this.signalSchedulingChange();
            }
        }
    }

    boolean isPaused() {
        return this.paused;
    }

    void signalSchedulingChange() {
        this.signaled = true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (!this.halted) {
            block32: {
                block33: {
                    var1_1 = this.pauseLock;
                    synchronized (var1_1) {
                        while (this.paused && !this.halted) {
                            try {
                                this.pauseLock.wait(100L);
                            }
                            catch (InterruptedException ignore) {
                                // empty catch block
                            }
                        }
                        if (this.halted) {
                            break;
                        }
                    }
                    trigger = null;
                    idleWait = true;
                    try {
                        trigger = this.qsRsrcs.getJobStore().acquireNextTrigger(this.ctxt);
                    }
                    catch (JobPersistenceException jpe) {
                        this.qs.notifySchedulerListenersError("An error occured while scanning for the next trigger to fire.", jpe);
                    }
                    catch (RuntimeException e) {
                        QuartzSchedulerThread.getLog().error((Object)("releaseTriggerRetryLoop: RuntimeException " + e.getMessage()), (Throwable)e);
                    }
                    if (trigger == null) break block32;
                    now = System.currentTimeMillis();
                    triggerTime = trigger.getNextFireTime().getTime();
                    timeUntilTrigger = triggerTime - now;
                    spinInterval = 10L;
                    if (timeUntilTrigger > this.idleWaitTime) break block33;
                    numPauses = (int)(timeUntilTrigger / spinInterval);
                    if (true) ** GOTO lbl53
                }
                try {
                    this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
                }
                catch (JobPersistenceException jpe) {
                    this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", jpe);
                    this.releaseTriggerRetryLoop(trigger);
                }
                catch (RuntimeException e) {
                    QuartzSchedulerThread.getLog().error((Object)("releaseTriggerRetryLoop: RuntimeException " + e.getMessage()), (Throwable)e);
                    this.releaseTriggerRetryLoop(trigger);
                }
                idleWait = true;
                break block32;
                do {
                    try {
                        Thread.sleep(spinInterval);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    now = System.currentTimeMillis();
                    timeUntilTrigger = triggerTime - now;
                    numPauses = (int)(timeUntilTrigger / spinInterval);
lbl53:
                    // 2 sources

                } while (numPauses >= 0 && !this.signaled);
                if (this.signaled) {
                    try {
                        this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
                    }
                    catch (JobPersistenceException jpe) {
                        this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", jpe);
                        this.releaseTriggerRetryLoop(trigger);
                    }
                    catch (RuntimeException e) {
                        QuartzSchedulerThread.getLog().error((Object)("releaseTriggerRetryLoop: RuntimeException " + e.getMessage()), (Throwable)e);
                        this.releaseTriggerRetryLoop(trigger);
                    }
                    this.signaled = false;
                    continue;
                }
                bndle = null;
                try {
                    bndle = this.qsRsrcs.getJobStore().triggerFired(this.ctxt, trigger);
                }
                catch (SchedulerException se) {
                    this.qs.notifySchedulerListenersError("An error occured while firing trigger '" + trigger.getFullName() + "'", se);
                }
                if (bndle == null) {
                    try {
                        this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
                    }
                    catch (SchedulerException se) {
                        this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", se);
                        this.releaseTriggerRetryLoop(trigger);
                    }
                    continue;
                }
                shell = null;
                try {
                    shell = this.qsRsrcs.getJobRunShellFactory().borrowJobRunShell();
                    shell.initialize(this.qs, bndle);
                }
                catch (SchedulerException se) {
                    try {
                        this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
                    }
                    catch (SchedulerException se2) {
                        this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", se2);
                        this.releaseTriggerRetryLoop(trigger);
                    }
                    continue;
                }
                this.qsRsrcs.getThreadPool().runInThread(shell);
                idleWait = false;
            }
            now = System.currentTimeMillis();
            waitTime = now + this.getRandomizedIdleWaitTime();
            timeUntilContinue = waitTime - now;
            spinInterval = 10L;
            numPauses = (int)(timeUntilContinue / spinInterval);
            while (idleWait && numPauses > 0 && !this.signaled) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                now = System.currentTimeMillis();
                timeUntilContinue = waitTime - now;
                numPauses = (int)(timeUntilContinue / spinInterval);
            }
            this.signaled = false;
        }
        this.qs = null;
        this.qsRsrcs = null;
    }

    public void releaseTriggerRetryLoop(Trigger trigger) {
        while (!this.halted) {
            try {
                Thread.sleep(this.getDbFailureRetryInterval());
                this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
                break;
            }
            catch (JobPersistenceException jpe) {
                this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", jpe);
            }
            catch (RuntimeException e) {
                QuartzSchedulerThread.getLog().error((Object)("releaseTriggerRetryLoop: RuntimeException " + e.getMessage()), (Throwable)e);
            }
            catch (InterruptedException e) {
                QuartzSchedulerThread.getLog().error((Object)("releaseTriggerRetryLoop: InterruptedException " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static Log getLog() {
        return LogFactory.getLog((Class)(class$org$quartz$core$QuartzSchedulerThread == null ? (class$org$quartz$core$QuartzSchedulerThread = QuartzSchedulerThread.class$("org.quartz.core.QuartzSchedulerThread")) : class$org$quartz$core$QuartzSchedulerThread));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

