/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.sql.Connection;
import java.util.List;
import java.util.Set;
import org.quartz.Calendar;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerConfigException;
import org.quartz.Trigger;
import org.quartz.core.SchedulingContext;
import org.quartz.impl.jdbcjobstore.JobStoreSupport;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredBundle;

public class JobStoreTX
extends JobStoreSupport {
    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) throws SchedulerConfigException {
        super.initialize(loadHelper, signaler);
        this.getLog().info((Object)"JobStoreTX initialized.");
    }

    protected void recoverJobs() throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.recoverJobs(conn);
                this.commitConnection(conn);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            Object var5_3 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
    }

    protected void cleanVolatileTriggerAndJobs() throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.cleanVolatileTriggerAndJobs(conn);
                this.commitConnection(conn);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            Object var5_3 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
    }

    public void storeJobAndTrigger(SchedulingContext ctxt, JobDetail newJob, Trigger newTrigger) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        try {
            try {
                if (newJob.isVolatile() && !newTrigger.isVolatile()) {
                    JobPersistenceException jpe = new JobPersistenceException("Cannot associate non-volatile trigger with a volatile job!");
                    jpe.setErrorCode(100);
                    throw jpe;
                }
                this.storeJob(conn, ctxt, newJob, false);
                this.storeTrigger(conn, ctxt, newTrigger, newJob, false, "WAITING", false, false);
                this.commitConnection(conn);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
    }

    public void storeJob(SchedulingContext ctxt, JobDetail newJob, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            try {
                if (replaceExisting) {
                    this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    transOwner = true;
                }
                this.storeJob(conn, ctxt, newJob, replaceExisting);
                this.commitConnection(conn);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            Object var8_6 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        boolean bl;
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                boolean removed = this.removeJob(conn, ctxt, jobName, groupName, true);
                this.commitConnection(conn);
                bl = removed;
                Object var9_9 = null;
                this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JobDetail retrieveJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        JobDetail jobDetail;
        Connection conn = this.getConnection();
        try {
            try {
                JobDetail job = this.retrieveJob(conn, ctxt, jobName, groupName);
                this.commitConnection(conn);
                jobDetail = job;
                Object var8_8 = null;
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
        return jobDetail;
    }

    public void storeTrigger(SchedulingContext ctxt, Trigger newTrigger, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            try {
                if (replaceExisting) {
                    this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    transOwner = true;
                }
                this.storeTrigger(conn, ctxt, newTrigger, null, replaceExisting, "WAITING", false, false);
                this.commitConnection(conn);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            Object var8_6 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        boolean bl;
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                boolean removed = this.removeTrigger(conn, ctxt, triggerName, groupName);
                this.commitConnection(conn);
                bl = removed;
                Object var9_9 = null;
                this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean replaceTrigger(SchedulingContext ctxt, String triggerName, String groupName, Trigger newTrigger) throws JobPersistenceException {
        boolean bl;
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                boolean removed = this.replaceTrigger(conn, ctxt, triggerName, groupName, newTrigger);
                this.commitConnection(conn);
                bl = removed;
                Object var10_10 = null;
                this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Trigger retrieveTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        Trigger trigger;
        Connection conn = this.getConnection();
        try {
            try {
                Trigger trigger2 = this.retrieveTrigger(conn, ctxt, triggerName, groupName);
                this.commitConnection(conn);
                trigger = trigger2;
                Object var8_8 = null;
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
        return trigger;
    }

    public void storeCalendar(SchedulingContext ctxt, String calName, Calendar calendar, boolean replaceExisting, boolean updateTriggers) throws ObjectAlreadyExistsException, JobPersistenceException {
        Connection conn = this.getConnection();
        boolean lockOwner = false;
        try {
            try {
                if (updateTriggers) {
                    this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    lockOwner = true;
                }
                this.storeCalendar(conn, ctxt, calName, calendar, replaceExisting, updateTriggers);
                this.commitConnection(conn);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            Object var10_8 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, lockOwner);
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, lockOwner);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeCalendar(SchedulingContext ctxt, String calName) throws JobPersistenceException {
        boolean bl;
        Connection conn = this.getConnection();
        try {
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_CALENDAR_ACCESS);
                boolean removed = this.removeCalendar(conn, ctxt, calName);
                this.commitConnection(conn);
                bl = removed;
                Object var7_7 = null;
                this.releaseLock(conn, JobStoreSupport.LOCK_CALENDAR_ACCESS, true);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_CALENDAR_ACCESS, true);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Calendar retrieveCalendar(SchedulingContext ctxt, String calName) throws JobPersistenceException {
        Calendar calendar;
        Connection conn = this.getConnection();
        try {
            try {
                Calendar cal = this.retrieveCalendar(conn, ctxt, calName);
                this.commitConnection(conn);
                calendar = cal;
                Object var7_7 = null;
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
        return calendar;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getNumberOfJobs(SchedulingContext ctxt) throws JobPersistenceException {
        int n;
        Connection conn = this.getConnection();
        try {
            try {
                int numJobs = this.getNumberOfJobs(conn, ctxt);
                this.commitConnection(conn);
                n = numJobs;
                Object var6_6 = null;
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getNumberOfTriggers(SchedulingContext ctxt) throws JobPersistenceException {
        int n;
        Connection conn = this.getConnection();
        try {
            try {
                int numTriggers = this.getNumberOfTriggers(conn, ctxt);
                this.commitConnection(conn);
                n = numTriggers;
                Object var6_6 = null;
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getNumberOfCalendars(SchedulingContext ctxt) throws JobPersistenceException {
        int n;
        Connection conn = this.getConnection();
        try {
            try {
                int numCals = this.getNumberOfCalendars(conn, ctxt);
                this.commitConnection(conn);
                n = numCals;
                Object var6_6 = null;
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set getPausedTriggerGroups(SchedulingContext ctxt) throws JobPersistenceException {
        Set set;
        Connection conn = this.getConnection();
        try {
            try {
                Set groups = this.getPausedTriggerGroups(conn, ctxt);
                this.commitConnection(conn);
                set = groups;
                Object var6_6 = null;
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
        return set;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getJobNames(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        String[] stringArray;
        Connection conn = this.getConnection();
        try {
            try {
                String[] jobNames = this.getJobNames(conn, ctxt, groupName);
                this.commitConnection(conn);
                stringArray = jobNames;
                Object var7_7 = null;
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getTriggerNames(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        String[] stringArray;
        Connection conn = this.getConnection();
        try {
            try {
                String[] triggerNames = this.getTriggerNames(conn, ctxt, groupName);
                this.commitConnection(conn);
                stringArray = triggerNames;
                Object var7_7 = null;
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getJobGroupNames(SchedulingContext ctxt) throws JobPersistenceException {
        String[] stringArray;
        Connection conn = this.getConnection();
        try {
            try {
                String[] groupNames = this.getJobGroupNames(conn, ctxt);
                this.commitConnection(conn);
                stringArray = groupNames;
                Object var6_6 = null;
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getTriggerGroupNames(SchedulingContext ctxt) throws JobPersistenceException {
        String[] stringArray;
        Connection conn = this.getConnection();
        try {
            try {
                String[] triggerGroups = this.getTriggerGroupNames(conn, ctxt);
                this.commitConnection(conn);
                stringArray = triggerGroups;
                Object var6_6 = null;
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getCalendarNames(SchedulingContext ctxt) throws JobPersistenceException {
        String[] stringArray;
        Connection conn = this.getConnection();
        try {
            try {
                String[] calNames = this.getCalendarNames(conn, ctxt);
                this.commitConnection(conn);
                stringArray = calNames;
                Object var6_6 = null;
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Trigger[] getTriggersForJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        Trigger[] triggerArray;
        Connection conn = this.getConnection();
        try {
            try {
                triggerArray = this.getTriggersForJob(conn, ctxt, jobName, groupName);
                Object var7_7 = null;
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
        return triggerArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getTriggerState(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        int n;
        Connection conn = this.getConnection();
        try {
            try {
                n = this.getTriggerState(conn, ctxt, triggerName, groupName);
                Object var7_7 = null;
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
        return n;
    }

    public void pauseTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.pauseTrigger(conn, ctxt, triggerName, groupName);
                this.commitConnection(conn);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            Object var8_6 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
    }

    public void pauseTriggerGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.pauseTriggerGroup(conn, ctxt, groupName);
                this.commitConnection(conn);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            Object var7_5 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
    }

    public void pauseJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                Trigger[] triggers = this.getTriggersForJob(conn, ctxt, jobName, groupName);
                int j = 0;
                while (j < triggers.length) {
                    this.pauseTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
                    ++j;
                }
                this.commitConnection(conn);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            Object var9_9 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
    }

    public void pauseJobGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                String[] jobNames = this.getJobNames(conn, ctxt, groupName);
                int i = 0;
                while (i < jobNames.length) {
                    Trigger[] triggers = this.getTriggersForJob(conn, ctxt, jobNames[i], groupName);
                    int j = 0;
                    while (j < triggers.length) {
                        this.pauseTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
                        ++j;
                    }
                    ++i;
                }
                this.commitConnection(conn);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            Object var10_10 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
    }

    public void resumeTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.resumeTrigger(conn, ctxt, triggerName, groupName);
                this.commitConnection(conn);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            Object var8_6 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
    }

    public void resumeTriggerGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.resumeTriggerGroup(conn, ctxt, groupName);
                this.commitConnection(conn);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            Object var7_5 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
    }

    public void resumeJob(SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                Trigger[] triggers = this.getTriggersForJob(conn, ctxt, jobName, groupName);
                int j = 0;
                while (j < triggers.length) {
                    this.resumeTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
                    ++j;
                }
                this.commitConnection(conn);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            Object var9_9 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
    }

    public void resumeJobGroup(SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                String[] jobNames = this.getJobNames(conn, ctxt, groupName);
                int i = 0;
                while (i < jobNames.length) {
                    Trigger[] triggers = this.getTriggersForJob(conn, ctxt, jobNames[i], groupName);
                    int j = 0;
                    while (j < triggers.length) {
                        this.resumeTrigger(conn, ctxt, triggers[j].getName(), triggers[j].getGroup());
                        ++j;
                    }
                    ++i;
                }
                this.commitConnection(conn);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            Object var10_10 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
    }

    public void pauseAll(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.pauseAll(conn, ctxt);
                this.commitConnection(conn);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            Object var6_4 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
    }

    public void resumeAll(SchedulingContext ctxt) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.resumeAll(conn, ctxt);
                this.commitConnection(conn);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            Object var6_4 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Trigger acquireNextTrigger(SchedulingContext ctxt) throws JobPersistenceException {
        Trigger trigger;
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                Trigger trigger2 = this.acquireNextTrigger(conn, ctxt);
                this.commitConnection(conn);
                trigger = trigger2;
                Object var7_7 = null;
                this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
        return trigger;
    }

    public void releaseAcquiredTrigger(SchedulingContext ctxt, Trigger trigger) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.releaseAcquiredTrigger(conn, ctxt, trigger);
                this.commitConnection(conn);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            Object var7_5 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TriggerFiredBundle triggerFired(SchedulingContext ctxt, Trigger trigger) throws JobPersistenceException {
        TriggerFiredBundle triggerFiredBundle;
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                TriggerFiredBundle tfb = null;
                JobPersistenceException err = null;
                try {
                    tfb = this.triggerFired(conn, ctxt, trigger);
                }
                catch (JobPersistenceException jpe) {
                    if (jpe.getErrorCode() != 410) {
                        throw jpe;
                    }
                    err = jpe;
                }
                this.commitConnection(conn);
                if (err != null) {
                    throw err;
                }
                triggerFiredBundle = tfb;
                Object var9_10 = null;
                this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
        return triggerFiredBundle;
    }

    public void triggeredJobComplete(SchedulingContext ctxt, Trigger trigger, JobDetail jobDetail, int triggerInstCode) throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        try {
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                this.triggeredJobComplete(conn, ctxt, trigger, jobDetail, triggerInstCode);
                this.commitConnection(conn);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            Object var9_7 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean doRecoverMisfires() throws JobPersistenceException {
        boolean e2;
        Connection conn = this.getConnection();
        boolean transOwner = false;
        boolean moreToDo = false;
        try {
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                transOwner = true;
                try {
                    moreToDo = this.recoverMisfiredJobs(conn, false);
                }
                catch (Exception e2) {
                    throw new JobPersistenceException(e2.getMessage(), e2);
                }
                this.commitConnection(conn);
                e2 = moreToDo;
                Object var6_7 = null;
                this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            }
            catch (JobPersistenceException e3) {
                this.rollbackConnection(conn);
                throw e3;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
        return e2;
    }

    protected boolean doCheckin() throws JobPersistenceException {
        Connection conn = this.getConnection();
        boolean transOwner = false;
        boolean transStateOwner = false;
        boolean recovered = false;
        try {
            try {
                this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_STATE_ACCESS);
                transStateOwner = true;
                List failedRecords = this.clusterCheckIn(conn);
                if (failedRecords.size() > 0) {
                    this.getLockHandler().obtainLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS);
                    transOwner = true;
                    this.clusterRecover(conn, failedRecords);
                    recovered = true;
                }
                this.commitConnection(conn);
            }
            catch (JobPersistenceException e) {
                this.rollbackConnection(conn);
                throw e;
            }
            Object var7_7 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            this.releaseLock(conn, JobStoreSupport.LOCK_STATE_ACCESS, transStateOwner);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.releaseLock(conn, JobStoreSupport.LOCK_TRIGGER_ACCESS, transOwner);
            this.releaseLock(conn, JobStoreSupport.LOCK_STATE_ACCESS, transStateOwner);
            this.closeConnection(conn);
            throw throwable;
        }
        this.closeConnection(conn);
        this.firstCheckIn = false;
        return recovered;
    }
}

