/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.sql.Connection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.impl.jdbcjobstore.Semaphore;

public class SimpleSemaphore
implements Semaphore {
    ThreadLocal lockOwners = new ThreadLocal();
    HashSet locks = new HashSet();

    Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    private HashSet getThreadLocks() {
        HashSet threadLocks = (HashSet)this.lockOwners.get();
        if (threadLocks == null) {
            threadLocks = new HashSet();
            this.lockOwners.set(threadLocks);
        }
        return threadLocks;
    }

    public synchronized boolean obtainLock(Connection conn, String lockName) {
        lockName = lockName.intern();
        this.getLog().debug((Object)("Lock '" + lockName + "' is desired by: " + Thread.currentThread().getName()));
        if (!this.isLockOwner(conn, lockName)) {
            this.getLog().debug((Object)("Lock '" + lockName + "' is being obtained: " + Thread.currentThread().getName()));
            while (this.locks.contains(lockName)) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    this.getLog().debug((Object)("Lock '" + lockName + "' was not obtained by: " + Thread.currentThread().getName()));
                }
            }
            this.getLog().debug((Object)("Lock '" + lockName + "' given to: " + Thread.currentThread().getName()));
            this.getThreadLocks().add(lockName);
            this.locks.add(lockName);
        } else {
            this.getLog().debug((Object)("Lock '" + lockName + "' already owned by: " + Thread.currentThread().getName() + " -- but not owner!"), (Throwable)new Exception("stack-trace of wrongful returner"));
        }
        return true;
    }

    public synchronized void releaseLock(Connection conn, String lockName) {
        if (this.isLockOwner(conn, lockName = lockName.intern())) {
            this.getLog().debug((Object)("Lock '" + lockName + "' retuned by: " + Thread.currentThread().getName()));
            this.getThreadLocks().remove(lockName);
            this.locks.remove(lockName);
            this.notify();
        } else {
            this.getLog().debug((Object)("Lock '" + lockName + "' attempt to retun by: " + Thread.currentThread().getName() + " -- but not owner!"), (Throwable)new Exception("stack-trace of wrongful returner"));
        }
    }

    public synchronized boolean isLockOwner(Connection conn, String lockName) {
        lockName = lockName.intern();
        return this.getThreadLocks().contains(lockName);
    }

    public void init(Connection conn, List listOfLocks) {
    }
}

