/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.plugins.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.jobs.FileScanJob;
import org.quartz.jobs.FileScanListener;
import org.quartz.spi.SchedulerPlugin;
import org.quartz.xml.JobSchedulingDataProcessor;

public class JobInitializationPlugin
implements SchedulerPlugin,
FileScanListener {
    private String name;
    private Scheduler scheduler;
    private boolean overWriteExistingJobs = false;
    private boolean failOnFileNotFound = true;
    private boolean fileFound = false;
    private String fileName = "quartz_jobs.xml";
    private boolean validating = true;
    private boolean validatingSchema = true;
    private long scanInterval = 0L;
    boolean initializing = true;
    boolean started = false;
    static /* synthetic */ Class class$org$quartz$plugins$xml$JobInitializationPlugin;
    static /* synthetic */ Class class$org$quartz$jobs$FileScanJob;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isOverWriteExistingJobs() {
        return this.overWriteExistingJobs;
    }

    public void setOverWriteExistingJobs(boolean overWriteExistingJobs) {
        this.overWriteExistingJobs = overWriteExistingJobs;
    }

    public long getScanInterval() {
        return this.scanInterval / 1000L;
    }

    public void setScanInterval(long scanInterval) {
        this.scanInterval = scanInterval * 1000L;
    }

    public boolean isFailOnFileNotFound() {
        return this.failOnFileNotFound;
    }

    public void setFailOnFileNotFound(boolean failOnFileNotFound) {
        this.failOnFileNotFound = failOnFileNotFound;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public boolean isValidatingSchema() {
        return this.validatingSchema;
    }

    public void setValidatingSchema(boolean validatingSchema) {
        this.validatingSchema = validatingSchema;
    }

    protected static Log getLog() {
        return LogFactory.getLog((Class)(class$org$quartz$plugins$xml$JobInitializationPlugin == null ? (class$org$quartz$plugins$xml$JobInitializationPlugin = JobInitializationPlugin.class$("org.quartz.plugins.xml.JobInitializationPlugin")) : class$org$quartz$plugins$xml$JobInitializationPlugin));
    }

    public void initialize(String name, Scheduler scheduler) throws SchedulerException {
        this.initializing = true;
        try {
            this.name = name;
            this.scheduler = scheduler;
            JobInitializationPlugin.getLog().info((Object)"Registering Quartz Job Initiazation Plug-in.");
            this.findFile();
            if (this.scanInterval > 0L) {
                SimpleTrigger trig = new SimpleTrigger("JobInitializationPlugin_" + name, "JobInitializationPlugin", new Date(), null, SimpleTrigger.REPEAT_INDEFINITELY, this.scanInterval);
                trig.setVolatility(true);
                JobDetail job = new JobDetail("JobInitializationPlugin_" + name, "JobInitializationPlugin", class$org$quartz$jobs$FileScanJob == null ? (class$org$quartz$jobs$FileScanJob = JobInitializationPlugin.class$("org.quartz.jobs.FileScanJob")) : class$org$quartz$jobs$FileScanJob);
                job.setVolatility(true);
                job.getJobDataMap().put(FileScanJob.FILE_NAME, this.getFileName());
                job.getJobDataMap().put(FileScanJob.FILE_SCAN_LISTENER_NAME, "JobInitializationPlugin_" + name);
                scheduler.getContext().put((Object)("JobInitializationPlugin_" + name), this);
                scheduler.scheduleJob(job, trig);
            }
            Object var6_5 = null;
            this.initializing = false;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.initializing = false;
            throw throwable;
        }
    }

    private void findFile() throws SchedulerException {
        InputStream f = null;
        File file = new File(this.getFileName());
        if (file != null && file.exists()) {
            try {
                f = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {}
        } else {
            f = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getFileName());
        }
        if (f == null && this.isFailOnFileNotFound()) {
            throw new SchedulerException("File named '" + this.getFileName() + "' does not exist.");
        }
        if (f == null) {
            JobInitializationPlugin.getLog().warn((Object)("File named '" + this.getFileName() + "' does not exist."));
        } else {
            this.fileFound = true;
            try {
                f.close();
            }
            catch (IOException ioe) {
                JobInitializationPlugin.getLog().warn((Object)("Error closing file named '" + this.getFileName()), (Throwable)ioe);
            }
        }
    }

    public void start() {
        try {
            this.processFile();
            Object var2_1 = null;
            this.started = true;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.started = true;
            throw throwable;
        }
    }

    public void shutdown() {
    }

    public void processFile() {
        if (!this.fileFound) {
            return;
        }
        JobSchedulingDataProcessor processor = new JobSchedulingDataProcessor(this.isValidating(), this.isValidatingSchema());
        try {
            processor.processFileAndScheduleJobs(this.getFileName(), this.scheduler, this.isOverWriteExistingJobs());
        }
        catch (Exception e) {
            JobInitializationPlugin.getLog().error((Object)("Error scheduling jobs: " + e.getMessage()), (Throwable)e);
        }
    }

    public void fileUpdated(String fileName) {
        if (this.started) {
            this.processFile();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

