/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.factory;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.DecoratorMapper;
import com.opensymphony.module.sitemesh.PageParser;
import com.opensymphony.module.sitemesh.factory.BaseFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DefaultFactory
extends BaseFactory {
    String configFileName = "/WEB-INF/sitemesh.xml";
    File configFile;
    long configLastModified;

    public DefaultFactory(Config config) {
        super(config);
        String configFilePath = config.getServletContext().getRealPath(this.configFileName);
        if (configFilePath != null) {
            this.configFile = new File(configFilePath);
        }
        this.loadConfig();
    }

    public DecoratorMapper getDecoratorMapper() {
        this.refresh();
        return super.getDecoratorMapper();
    }

    public PageParser getPageParser(String contentType) {
        this.refresh();
        return super.getPageParser(contentType);
    }

    public boolean shouldParsePage(String contentType) {
        this.refresh();
        return super.shouldParsePage(contentType);
    }

    private synchronized void loadConfig() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputStream is = null;
            if (this.configFile == null) {
                is = this.config.getServletContext().getResourceAsStream(this.configFileName);
            } else if (this.configFile.exists() && this.configFile.canRead()) {
                is = this.configFile.toURL().openStream();
            }
            if (is == null) {
                is = this.getClass().getClassLoader().getResourceAsStream("com/opensymphony/module/sitemesh/factory/sitemesh-default.xml");
            }
            if (is == null) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream("com/opensymphony/module/sitemesh/factory/sitemesh-default.xml");
            }
            if (is == null) {
                throw new IllegalStateException("Cannot load default configuration from jar");
            }
            Document document = builder.parse(is);
            Element root = document.getDocumentElement();
            if (this.configFile != null) {
                this.configLastModified = this.configFile.lastModified();
            }
            if (!"sitemesh".equalsIgnoreCase(root.getTagName())) {
                DefaultFactory.report("Root element of sitemesh configuration file not <sitemesh>", null);
            }
            NodeList sections = root.getChildNodes();
            for (int i = 0; i < sections.getLength(); ++i) {
                if (!(sections.item(i) instanceof Element)) continue;
                Element curr = (Element)sections.item(i);
                NodeList children = curr.getChildNodes();
                if ("page-parsers".equalsIgnoreCase(curr.getTagName())) {
                    this.loadPageParsers(children);
                    continue;
                }
                if (!"decorator-mappers".equalsIgnoreCase(curr.getTagName())) continue;
                this.loadDecoratorMappers(children);
            }
        }
        catch (ParserConfigurationException e) {
            DefaultFactory.report("Could not get XML parser", e);
        }
        catch (IOException e) {
            DefaultFactory.report("Could not read config file : " + this.configFileName, e);
        }
        catch (SAXException e) {
            DefaultFactory.report("Could not parse config file : " + this.configFileName, e);
        }
    }

    private void loadPageParsers(NodeList nodes) {
        this.clearParserMappings();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element curr;
            if (!(nodes.item(i) instanceof Element) || !"parser".equalsIgnoreCase((curr = (Element)nodes.item(i)).getTagName())) continue;
            String className = curr.getAttribute("class");
            String contentType = curr.getAttribute("content-type");
            this.mapParser(contentType, className);
        }
    }

    private void loadDecoratorMappers(NodeList nodes) {
        this.clearDecoratorMappers();
        Properties emptyProps = new Properties();
        this.pushDecoratorMapper("com.opensymphony.module.sitemesh.mapper.NullDecoratorMapper", emptyProps);
        for (int i = nodes.getLength() - 1; i > 0; --i) {
            Element curr;
            if (!(nodes.item(i) instanceof Element) || !"mapper".equalsIgnoreCase((curr = (Element)nodes.item(i)).getTagName())) continue;
            String className = curr.getAttribute("class");
            Properties props = new Properties();
            NodeList children = curr.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Element currC;
                if (!(children.item(j) instanceof Element) || !"param".equalsIgnoreCase((currC = (Element)children.item(j)).getTagName())) continue;
                props.put(currC.getAttribute("name"), currC.getAttribute("value"));
            }
            this.pushDecoratorMapper(className, props);
        }
        this.pushDecoratorMapper("com.opensymphony.module.sitemesh.mapper.InlineDecoratorMapper", emptyProps);
    }

    private void refresh() {
        if (this.configFile != null && this.configLastModified != this.configFile.lastModified()) {
            this.loadConfig();
        }
    }
}

