/*
 * Copyright (c) 2002-2003 by OpenSymphony
 * All rights reserved.
 */
package com.opensymphony.webwork.views.jsp;

import com.opensymphony.xwork.util.OgnlValueStack;

import javax.servlet.jsp.JspException;


/**
 * @author $Author: plightbo $
 * @version $Revision: 1.8 $
 */
public class SetTag extends WebWorkTagSupport {
    //~ Instance fields ////////////////////////////////////////////////////////

    String name;
    String scope;
    String value;

    //~ Methods ////////////////////////////////////////////////////////////////

    public void setName(String name) {
        this.name = name;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int doStartTag() throws JspException {
        OgnlValueStack stack = getStack();

        if (value == null) {
            value = "top";
        }

        Object o = findValue(value);

        if ("application".equals(scope)) {
            super.pageContext.getServletContext().setAttribute(name, o);
        } else if ("session".equals(scope)) {
            pageContext.getSession().setAttribute(name, o);
        } else if ("request".equals(scope)) {
            pageContext.getRequest().setAttribute(name, o);
        } else if ("page".equals(scope)) {
            pageContext.setAttribute(name, o);
        } else {
            stack.getContext().put(name, o);
        }

        return SKIP_BODY;
    }
}
