/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.velocity;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.views.velocity.VelocityManager;
import com.opensymphony.xwork.ActionContext;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.servlet.VelocityServlet;

public class WebWorkVelocityServlet
extends VelocityServlet {
    private VelocityManager velocityManager = VelocityManager.getInstance();

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.velocityManager.init(servletConfig.getServletContext());
        servletConfig.getServletContext().setAttribute("webwork.servlet", (Object)this);
    }

    protected Context createContext(HttpServletRequest request, HttpServletResponse response) {
        return this.velocityManager.createContext(ActionContext.getContext().getValueStack(), request, response);
    }

    protected Template handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Context context) throws Exception {
        String servletPath = (String)httpServletRequest.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = httpServletRequest.getServletPath();
        }
        return this.getTemplate(servletPath, this.getEncoding());
    }

    protected Properties loadConfiguration(ServletConfig servletConfig) throws IOException, FileNotFoundException {
        return this.velocityManager.loadConfiguration(servletConfig.getServletContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeTemplate(Template template, Context context, HttpServletResponse response) throws ResourceNotFoundException, ParseErrorException, MethodInvocationException, IOException, UnsupportedEncodingException, Exception {
        PageContext oldPageContext = ServletActionContext.getPageContext();
        JspFactory jspFactory = JspFactory.getDefaultFactory();
        HttpServletRequest request = (HttpServletRequest)context.get("req");
        PageContext pageContext = jspFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
        ActionContext actionContext = ActionContext.getContext();
        actionContext.put((Object)"com.opensymphony.xwork.dispatcher.PageContext", (Object)pageContext);
        try {
            JspWriter writer = pageContext.getOut();
            template.merge(context, (Writer)writer);
            writer.flush();
        }
        finally {
            jspFactory.releasePageContext(pageContext);
            actionContext.put((Object)"com.opensymphony.xwork.dispatcher.PageContext", (Object)oldPageContext);
        }
    }

    private String getEncoding() {
        try {
            return Configuration.getString("webwork.i18n.encoding");
        }
        catch (IllegalArgumentException e) {
            return RuntimeSingleton.getString((String)"output.encoding", (String)"ISO-8859-1");
        }
    }
}

