/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components;

import com.opensymphony.webwork.components.Component;
import com.opensymphony.webwork.dispatcher.DispatcherUtils;
import com.opensymphony.webwork.dispatcher.RequestMap;
import com.opensymphony.webwork.views.jsp.TagUtils;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.ActionProxyFactory;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionComponent
extends Component {
    private static final Log LOG = LogFactory.getLog((Class)ActionComponent.class);
    protected HttpServletResponse res;
    protected HttpServletRequest req;
    protected ActionProxy proxy;
    protected String name;
    protected String namespace;
    protected boolean executeResult;
    protected boolean ignoreContextParams;

    public ActionComponent(OgnlValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        super(stack);
        this.req = req;
        this.res = res;
    }

    public boolean end(Writer writer, String body) {
        this.executeAction();
        if (this.getId() != null && this.proxy != null) {
            this.getStack().setValue("#attr['" + this.getId() + "']", this.proxy.getAction());
        }
        return super.end(writer, "");
    }

    private Map createExtraContext() {
        HashMap newParams;
        Map parentParams = null;
        if (!this.ignoreContextParams) {
            parentParams = new ActionContext(this.getStack().getContext()).getParameters();
        }
        HashMap hashMap = newParams = parentParams != null ? new HashMap(parentParams) : new HashMap();
        if (this.parameters != null) {
            newParams.putAll(this.parameters);
        }
        ActionContext ctx = new ActionContext(this.stack.getContext());
        ServletContext servletContext = (ServletContext)ctx.get((Object)"com.opensymphony.xwork.dispatcher.ServletContext");
        PageContext pageContext = (PageContext)ctx.get((Object)"com.opensymphony.xwork.dispatcher.PageContext");
        Map session = ctx.getSession();
        Map application = ctx.getApplication();
        DispatcherUtils.initialize(servletContext);
        DispatcherUtils du = DispatcherUtils.getInstance();
        HashMap extraContext = du.createContextMap(new RequestMap(this.req), newParams, session, application, this.req, this.res, servletContext);
        OgnlValueStack newStack = new OgnlValueStack(this.stack);
        extraContext.put("com.opensymphony.xwork.util.OgnlValueStack.ValueStack", newStack);
        extraContext.put("com.opensymphony.xwork.dispatcher.PageContext", pageContext);
        return extraContext;
    }

    public ActionProxy getProxy() {
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAction() {
        String methodName;
        String actionName;
        String actualName = this.findString(this.name, "name", "Action name is required. Example: updatePerson");
        if (actualName == null) {
            String message = "Unable to find value for name " + this.name;
            LOG.error((Object)message);
            throw new RuntimeException(message);
        }
        int exclamation = actualName.lastIndexOf("!");
        if (exclamation != -1) {
            actionName = actualName.substring(0, exclamation);
            methodName = actualName.substring(exclamation + 1);
        } else {
            actionName = actualName;
            methodName = null;
        }
        String namespace = this.namespace == null ? TagUtils.buildNamespace(this.getStack(), this.req) : this.findString(this.namespace);
        OgnlValueStack stack = this.getStack();
        try {
            this.proxy = ActionProxyFactory.getFactory().createActionProxy(namespace, actionName, this.createExtraContext(), this.executeResult, true);
            if (null != methodName) {
                this.proxy.setMethod(methodName);
            }
            this.req.setAttribute("webwork.valueStack", (Object)this.proxy.getInvocation().getStack());
            this.proxy.execute();
        }
        catch (Exception e) {
            String message = "Could not execute action: " + namespace + "/" + actualName;
            LOG.error((Object)message, (Throwable)e);
        }
        finally {
            this.req.setAttribute("webwork.valueStack", (Object)stack);
        }
        if (this.getId() != null && this.proxy != null) {
            Map context = stack.getContext();
            context.put(this.getId(), this.proxy.getAction());
        }
    }

    public void setId(String id) {
        super.setId(id);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setExecuteResult(boolean executeResult) {
        this.executeResult = executeResult;
    }

    public void setIgnoreContextParams(boolean ignoreContextParams) {
        this.ignoreContextParams = ignoreContextParams;
    }
}

