/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components;

import com.opensymphony.webwork.components.ClosingUIBean;
import com.opensymphony.webwork.dispatcher.DispatcherUtils;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapperFactory;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapping;
import com.opensymphony.webwork.portlet.context.PortletActionContext;
import com.opensymphony.webwork.portlet.util.PortletUrlHelper;
import com.opensymphony.webwork.views.util.UrlHelper;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.config.ConfigurationManager;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.validator.ActionValidatorManagerFactory;
import com.opensymphony.xwork.validator.FieldValidator;
import com.opensymphony.xwork.validator.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class Form
extends ClosingUIBean {
    public static final String OPEN_TEMPLATE = "form";
    public static final String TEMPLATE = "form-close";
    protected String onsubmit;
    protected String action;
    protected String target;
    protected String enctype;
    protected String method;
    protected String namespace;
    protected String validate;
    protected String portletMode;
    protected String windowState;

    public Form(OgnlValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    protected boolean evaluateNameValue() {
        return false;
    }

    public String getDefaultOpenTemplate() {
        return OPEN_TEMPLATE;
    }

    protected String getDefaultTemplate() {
        return TEMPLATE;
    }

    protected void evaluateExtraParams() {
        super.evaluateExtraParams();
        boolean isAjax = "ajax".equalsIgnoreCase(this.theme);
        String action = null;
        if (this.action != null) {
            action = this.findString(this.action);
        }
        if (DispatcherUtils.isPortletSupportActive() && PortletActionContext.isPortletRequest()) {
            this.evaluateExtraParamsPortletRequest(this.namespace, action);
        } else {
            String namespace = this.determineNamespace(this.namespace, this.getStack(), this.request);
            this.evaluateExtraParamsServletRequest(action, namespace, isAjax);
        }
        if (this.onsubmit != null) {
            this.addParameter("onsubmit", this.findString(this.onsubmit));
        }
        if (this.target != null) {
            this.addParameter("target", this.findString(this.target));
        }
        if (this.enctype != null) {
            this.addParameter("enctype", this.findString(this.enctype));
        }
        if (this.method != null) {
            this.addParameter("method", this.findString(this.method));
        }
        if (this.validate != null) {
            this.addParameter("validate", this.findValue(this.validate, Boolean.class));
        }
        if (!this.parameters.containsKey("tagNames")) {
            this.addParameter("tagNames", new ArrayList());
        }
    }

    private void evaluateExtraParamsServletRequest(String action, String namespace, boolean isAjax) {
        if (action == null) {
            ActionInvocation ai = (ActionInvocation)this.getStack().getContext().get("com.opensymphony.xwork.ActionContext.actionInvocation");
            if (ai != null) {
                action = ai.getProxy().getActionName();
                namespace = ai.getProxy().getNamespace();
            } else {
                String uri = this.request.getRequestURI();
                action = uri.substring(uri.lastIndexOf(47));
            }
        }
        ActionConfig actionConfig = ConfigurationManager.getConfiguration().getRuntimeConfiguration().getActionConfig(namespace, action);
        String actionName = action;
        if (actionConfig != null) {
            String actionMethod = "";
            if (action.indexOf("!") != -1) {
                int endIdx = action.lastIndexOf("!");
                actionMethod = action.substring(endIdx + 1, action.length());
                action = action.substring(0, endIdx);
            }
            ActionMapping mapping = new ActionMapping(action, namespace, actionMethod, this.parameters);
            String result = UrlHelper.buildUrl(ActionMapperFactory.getMapper().getUriFromActionMapping(mapping), this.request, this.response, null);
            this.addParameter("action", result);
            this.addParameter("actionName", actionName);
            try {
                Class clazz = ObjectFactory.getObjectFactory().getClassInstance(actionConfig.getClassName());
                this.addParameter("actionClass", clazz);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            this.addParameter("namespace", namespace);
            if (this.name == null) {
                this.addParameter("name", action);
            }
            if (this.id == null) {
                this.addParameter("id", action);
            }
        } else if (action != null) {
            String result = UrlHelper.buildUrl(action, this.request, this.response, null);
            this.addParameter("action", result);
            int slash = result.lastIndexOf(47);
            if (slash != -1) {
                this.addParameter("namespace", result.substring(0, slash));
            } else {
                this.addParameter("namespace", "");
            }
            if (this.id == null) {
                slash = result.lastIndexOf(47);
                int dot = result.indexOf(46, slash);
                this.id = dot != -1 ? result.substring(slash + 1, dot) : result.substring(slash + 1);
                this.addParameter("id", this.escape(this.id));
            }
        }
    }

    private void evaluateExtraParamsPortletRequest(String namespace, String action) {
        if (this.action != null) {
            action = this.findString(this.action);
        }
        String type = "action";
        if (StringUtils.isNotEmpty((String)this.method) && "GET".equalsIgnoreCase(this.method.trim())) {
            type = "render";
        }
        if (action != null) {
            String result = PortletUrlHelper.buildUrl(action, namespace, this.getParameters(), type, this.portletMode, this.windowState);
            this.addParameter("action", result);
            int slash = result.lastIndexOf(47);
            if (slash != -1) {
                this.addParameter("namespace", result.substring(0, slash));
            } else {
                this.addParameter("namespace", "");
            }
            if (this.id == null) {
                slash = action.lastIndexOf(47);
                int dot = action.indexOf(46, slash);
                this.id = dot != -1 ? action.substring(slash + 1, dot) : action.substring(slash + 1);
                this.addParameter("id", this.escape(this.id));
            }
        }
    }

    public List getValidators(String name) {
        Class actionClass = (Class)this.getParameters().get("actionClass");
        if (actionClass == null) {
            return Collections.EMPTY_LIST;
        }
        List all = ActionValidatorManagerFactory.getInstance().getValidators(actionClass, (String)this.getParameters().get("actionName"));
        ArrayList<FieldValidator> validators = new ArrayList<FieldValidator>();
        Iterator iterator = all.iterator();
        while (iterator.hasNext()) {
            FieldValidator fieldValidator;
            Validator validator = (Validator)iterator.next();
            if (!(validator instanceof FieldValidator) || !(fieldValidator = (FieldValidator)validator).getFieldName().equals(name)) continue;
            validators.add(fieldValidator);
        }
        return validators;
    }

    public void setOnsubmit(String onsubmit) {
        this.onsubmit = onsubmit;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setEnctype(String enctype) {
        this.enctype = enctype;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setValidate(String validate) {
        this.validate = validate;
    }

    public void setPortletMode(String portletMode) {
        this.portletMode = portletMode;
    }

    public void setWindowState(String windowState) {
        this.windowState = windowState;
    }
}

