/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components;

import com.opensymphony.webwork.RequestUtils;
import com.opensymphony.webwork.components.Component;
import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.util.FastByteArrayOutputStream;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Include
extends Component {
    private static final Log _log = LogFactory.getLog((Class)Include.class);
    private static String encoding;
    private static boolean encodingDefined;
    protected String value;
    private HttpServletRequest req;
    private HttpServletResponse res;

    public Include(OgnlValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        super(stack);
        this.req = req;
        this.res = res;
    }

    public boolean end(Writer writer, String body) {
        String page = this.findString(this.value, "value", "You must specify the URL to include. Example: /foo.jsp");
        StringBuffer urlBuf = new StringBuffer();
        urlBuf.append(page);
        if (this.parameters.size() > 0) {
            urlBuf.append('?');
            String concat = "";
            Iterator iter = this.parameters.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object name = entry.getKey();
                List values = (List)entry.getValue();
                for (int i = 0; i < values.size(); ++i) {
                    urlBuf.append(concat);
                    urlBuf.append(name);
                    urlBuf.append('=');
                    try {
                        urlBuf.append(URLEncoder.encode(values.get(i).toString(), "UTF-8"));
                    }
                    catch (Exception e) {
                        _log.warn((Object)("unable to url-encode " + values.get(i).toString() + ", it will be ignored"));
                    }
                    concat = "&";
                }
            }
        }
        String result = urlBuf.toString();
        try {
            Include.include(result, writer, (ServletRequest)this.req, this.res);
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).warn((Object)("Exception thrown during include of " + result), (Throwable)e);
        }
        return super.end(writer, body);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static String getContextRelativePath(ServletRequest request, String relativePath) {
        String returnValue;
        if (relativePath.startsWith("/")) {
            returnValue = relativePath;
        } else if (!(request instanceof HttpServletRequest)) {
            returnValue = relativePath;
        } else {
            HttpServletRequest hrequest = (HttpServletRequest)request;
            String uri = (String)request.getAttribute("javax.servlet.include.servlet_path");
            if (uri == null) {
                uri = RequestUtils.getServletPath(hrequest);
            }
            returnValue = uri.substring(0, uri.lastIndexOf(47)) + '/' + relativePath;
        }
        if (returnValue.indexOf("..") != -1) {
            Stack<String> stack = new Stack<String>();
            StringTokenizer pathParts = new StringTokenizer(returnValue.replace('\\', '/'), "/");
            while (pathParts.hasMoreTokens()) {
                String part = pathParts.nextToken();
                if (part.equals(".")) continue;
                if (part.equals("..")) {
                    stack.pop();
                    continue;
                }
                stack.push(part);
            }
            StringBuffer flatPathBuffer = new StringBuffer();
            for (int i = 0; i < stack.size(); ++i) {
                flatPathBuffer.append("/").append(stack.elementAt(i));
            }
            returnValue = flatPathBuffer.toString();
        }
        return returnValue;
    }

    public void addParameter(String key, Object value) {
        if (value != null) {
            ArrayList<Object> currentValues = (ArrayList<Object>)this.parameters.get(key);
            if (currentValues == null) {
                currentValues = new ArrayList<Object>();
                this.parameters.put(key, currentValues);
            }
            currentValues.add(value);
        }
    }

    public static void include(String aResult, Writer writer, ServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String resourcePath = Include.getContextRelativePath(request, aResult);
        RequestDispatcher rd = request.getRequestDispatcher(resourcePath);
        if (rd == null) {
            throw new ServletException("Not a valid resource path:" + resourcePath);
        }
        PageResponse pageResponse = new PageResponse(response);
        rd.include((ServletRequest)((HttpServletRequest)request), (ServletResponse)pageResponse);
        String encoding = Include.getEncoding();
        if (encoding != null) {
            pageResponse.getContent().writeTo(writer, encoding);
        } else {
            pageResponse.getContent().writeTo(writer, null);
        }
    }

    private static String getEncoding() {
        if (encodingDefined) {
            try {
                encoding = Configuration.getString("webwork.i18n.encoding");
            }
            catch (IllegalArgumentException e) {
                encoding = System.getProperty("file.encoding");
                encodingDefined = false;
            }
        }
        return encoding;
    }

    static {
        encodingDefined = true;
    }

    static final class PageResponse
    extends HttpServletResponseWrapper {
        protected PrintWriter pagePrintWriter;
        protected ServletOutputStream outputStream;
        private PageOutputStream pageOutputStream = null;

        public PageResponse(HttpServletResponse response) {
            super(response);
        }

        public FastByteArrayOutputStream getContent() throws IOException {
            if (this.pagePrintWriter != null) {
                this.pagePrintWriter.flush();
            }
            return ((PageOutputStream)this.getOutputStream()).getBuffer();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.pageOutputStream == null) {
                this.pageOutputStream = new PageOutputStream();
            }
            return this.pageOutputStream;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.pagePrintWriter == null) {
                this.pagePrintWriter = new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), this.getCharacterEncoding()));
            }
            return this.pagePrintWriter;
        }
    }

    static final class PageOutputStream
    extends ServletOutputStream {
        private FastByteArrayOutputStream buffer = new FastByteArrayOutputStream();

        public FastByteArrayOutputStream getBuffer() throws IOException {
            this.flush();
            return this.buffer;
        }

        public void close() throws IOException {
            this.buffer.close();
        }

        public void flush() throws IOException {
            this.buffer.flush();
        }

        public void write(byte[] b, int o, int l) throws IOException {
            this.buffer.write(b, o, l);
        }

        public void write(int i) throws IOException {
            this.buffer.write(i);
        }

        public void write(byte[] b) throws IOException {
            this.buffer.write(b);
        }
    }
}

