/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components.template;

import com.opensymphony.webwork.components.template.FreemarkerTemplateEngine;
import com.opensymphony.webwork.components.template.JspTemplateEngine;
import com.opensymphony.webwork.components.template.Template;
import com.opensymphony.webwork.components.template.TemplateEngine;
import com.opensymphony.webwork.components.template.VelocityTemplateEngine;
import com.opensymphony.webwork.config.Configuration;
import java.util.HashMap;
import java.util.Map;

public class TemplateEngineManager {
    public static final String DEFAULT_TEMPLATE_TYPE_CONFIG_KEY = "webwork.ui.templateSuffix";
    private static final TemplateEngineManager MANAGER = new TemplateEngineManager();
    public static final String DEFAULT_TEMPLATE_TYPE = "ftl";
    Map templateEngines = new HashMap();

    private TemplateEngineManager() {
        this.templateEngines.put(DEFAULT_TEMPLATE_TYPE, new FreemarkerTemplateEngine());
        this.templateEngines.put("vm", new VelocityTemplateEngine());
        this.templateEngines.put("jsp", new JspTemplateEngine());
    }

    public static void registerTemplateEngine(String templateExtension, TemplateEngine templateEngine) {
        TemplateEngineManager.MANAGER.templateEngines.put(templateExtension, templateEngine);
    }

    public static TemplateEngine getTemplateEngine(Template template, String templateTypeOverride) {
        String templateType = DEFAULT_TEMPLATE_TYPE;
        String templateName = template.toString();
        if (templateName.indexOf(".") > 0) {
            templateType = templateName.substring(templateName.indexOf(".") + 1);
        } else if (templateTypeOverride != null && templateTypeOverride.length() > 0) {
            templateType = templateTypeOverride;
        } else if (Configuration.isSet(DEFAULT_TEMPLATE_TYPE_CONFIG_KEY)) {
            templateType = (String)Configuration.get(DEFAULT_TEMPLATE_TYPE_CONFIG_KEY);
        }
        return (TemplateEngine)TemplateEngineManager.MANAGER.templateEngines.get(templateType);
    }
}

