/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.portlet.dispatcher;

import com.opensymphony.util.ClassLoaderUtil;
import com.opensymphony.util.FileManager;
import com.opensymphony.webwork.WebWorkStatics;
import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.dispatcher.DispatcherUtils;
import com.opensymphony.webwork.dispatcher.mapper.ActionMapping;
import com.opensymphony.webwork.portlet.PortletActionConstants;
import com.opensymphony.webwork.portlet.PortletApplicationMap;
import com.opensymphony.webwork.portlet.PortletRequestMap;
import com.opensymphony.webwork.portlet.PortletSessionMap;
import com.opensymphony.webwork.portlet.context.ServletContextHolderListener;
import com.opensymphony.webwork.util.AttributeMap;
import com.opensymphony.webwork.util.ObjectFactoryInitializable;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.ActionProxyFactory;
import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.config.ConfigurationException;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Jsr168Dispatcher
extends GenericPortlet
implements WebWorkStatics,
PortletActionConstants {
    private static final Log LOG = LogFactory.getLog((Class)Jsr168Dispatcher.class);
    private ActionProxyFactory factory = null;
    private Map modeMap = new HashMap(3);
    private Map actionMap = new HashMap(3);
    private String portletNamespace = null;
    private boolean devMode = false;

    public void init(PortletConfig cfg) throws PortletException {
        super.init(cfg);
        LOG.debug((Object)("Initializing portlet " + this.getPortletName()));
        if (this.factory == null) {
            this.factory = ActionProxyFactory.getFactory();
        }
        this.portletNamespace = cfg.getInitParameter("portletNamespace");
        LOG.debug((Object)("PortletNamespace: " + this.portletNamespace));
        this.parseModeConfig(cfg, PortletMode.VIEW, "viewNamespace", "defaultViewAction");
        this.parseModeConfig(cfg, PortletMode.EDIT, "editNamespace", "defaultEditAction");
        this.parseModeConfig(cfg, PortletMode.HELP, "helpNamespace", "defaultHelpAction");
        this.parseModeConfig(cfg, new PortletMode("config"), "configNamespace", "defaultConfigAction");
        this.parseModeConfig(cfg, new PortletMode("about"), "aboutNamespace", "defaultAboutAction");
        this.parseModeConfig(cfg, new PortletMode("print"), "printNamespace", "defaultPrintAction");
        this.parseModeConfig(cfg, new PortletMode("preview"), "previewNamespace", "defaultPreviewAction");
        this.parseModeConfig(cfg, new PortletMode("edit_defaults"), "editDefaultsNamespace", "defaultEditDefaultsAction");
        if (StringUtils.isEmpty((String)this.portletNamespace)) {
            this.portletNamespace = "";
        }
        LocalizedTextUtil.addDefaultResourceBundle((String)"com/opensymphony/webwork/webwork-messages");
        if ("true".equalsIgnoreCase(Configuration.getString("webwork.configuration.xml.reload"))) {
            FileManager.setReloadingConfigs((boolean)true);
        }
        if ("true".equals(Configuration.get("webwork.devMode"))) {
            this.devMode = true;
            Configuration.set("webwork.i18n.reload", "true");
            Configuration.set("webwork.configuration.xml.reload", "true");
        }
        if (Configuration.isSet("webwork.objectFactory")) {
            String className = (String)Configuration.get("webwork.objectFactory");
            if (className.equals("spring")) {
                className = "com.opensymphony.webwork.spring.WebWorkSpringObjectFactory";
            } else if (className.equals("plexus")) {
                className = "com.opensymphony.webwork.plexus.PlexusObjectFactory";
            }
            try {
                Class clazz = ClassLoaderUtil.loadClass((String)className, (Class)Jsr168Dispatcher.class);
                ObjectFactory objectFactory = (ObjectFactory)clazz.newInstance();
                if (objectFactory instanceof ObjectFactoryInitializable) {
                    ((ObjectFactoryInitializable)objectFactory).init(ServletContextHolderListener.getServletContext());
                }
                ObjectFactory.setObjectFactory((ObjectFactory)objectFactory);
            }
            catch (Exception e) {
                LOG.error((Object)("Could not load ObjectFactory named " + className + ". Using default ObjectFactory."), (Throwable)e);
            }
        }
        DispatcherUtils.setPortletSupportActive(true);
    }

    public void destroy() {
        super.destroy();
        DispatcherUtils dispatcherUtils = DispatcherUtils.getInstance();
        if (dispatcherUtils == null) {
            LOG.warn((Object)"something is seriously wrong, DispatcherUtil is not initialized (null) ");
        } else {
            dispatcherUtils.cleanup();
        }
    }

    private void parseModeConfig(PortletConfig portletConfig, PortletMode portletMode, String nameSpaceParam, String defaultActionParam) {
        String namespace = portletConfig.getInitParameter(nameSpaceParam);
        if (StringUtils.isEmpty((String)namespace)) {
            namespace = "";
        }
        this.modeMap.put(portletMode, namespace);
        String defaultAction = portletConfig.getInitParameter(defaultActionParam);
        if (StringUtils.isEmpty((String)defaultAction)) {
            defaultAction = "default";
        }
        StringBuffer fullPath = new StringBuffer();
        if (StringUtils.isNotEmpty((String)this.portletNamespace)) {
            fullPath.append(this.portletNamespace + "/");
        }
        if (StringUtils.isNotEmpty((String)namespace)) {
            fullPath.append(namespace + "/");
        }
        fullPath.append(defaultAction);
        ActionMapping mapping = new ActionMapping();
        mapping.setName(this.getActionName(fullPath.toString()));
        mapping.setNamespace(this.getNamespace(fullPath.toString()));
        this.actionMap.put(portletMode, mapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        LOG.debug((Object)"Entering processAction");
        this.resetActionContext();
        try {
            this.serviceAction((PortletRequest)request, (PortletResponse)response, this.getActionMapping((PortletRequest)request), this.getRequestMap((PortletRequest)request), this.getParameterMap((PortletRequest)request), this.getSessionMap((PortletRequest)request), this.getApplicationMap(), this.portletNamespace, EVENT_PHASE);
            LOG.debug((Object)"Leaving processAction");
        }
        finally {
            ActionContext.setContext(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        LOG.debug((Object)"Entering render");
        this.resetActionContext();
        response.setTitle(this.getTitle(request));
        try {
            this.serviceAction((PortletRequest)request, (PortletResponse)response, this.getActionMapping((PortletRequest)request), this.getRequestMap((PortletRequest)request), this.getParameterMap((PortletRequest)request), this.getSessionMap((PortletRequest)request), this.getApplicationMap(), this.portletNamespace, RENDER_PHASE);
            LOG.debug((Object)"Leaving render");
        }
        finally {
            this.resetActionContext();
        }
    }

    private void resetActionContext() {
        ActionContext.setContext(null);
    }

    public HashMap createContextMap(Map requestMap, Map parameterMap, Map sessionMap, Map applicationMap, PortletRequest request, PortletResponse response, PortletConfig portletConfig, Integer phase) {
        HashMap<String, Object> extraContext = new HashMap<String, Object>();
        extraContext.put("com.opensymphony.xwork.ActionContext.parameters", parameterMap);
        extraContext.put("com.opensymphony.xwork.ActionContext.session", sessionMap);
        extraContext.put("com.opensymphony.xwork.ActionContext.application", applicationMap);
        Locale locale = null;
        locale = Configuration.isSet("webwork.locale") ? LocalizedTextUtil.localeFromString((String)Configuration.getString("webwork.locale"), (Locale)request.getLocale()) : request.getLocale();
        extraContext.put("com.opensymphony.xwork.ActionContext.locale", locale);
        extraContext.put("__devMode", this.devMode);
        extraContext.put("webwork.portlet.context", this.getPortletContext());
        extraContext.put("webwork.portlet.request", request);
        extraContext.put("webwork.portlet.response", response);
        extraContext.put("webwork.portlet.config", portletConfig);
        extraContext.put("webwork.portlet.portletNamespace", this.portletNamespace);
        extraContext.put("webwork.portlet.defaultActionForMode", this.actionMap.get(request.getPortletMode()));
        extraContext.put("request", requestMap);
        extraContext.put("session", sessionMap);
        extraContext.put("application", applicationMap);
        extraContext.put("parameters", parameterMap);
        extraContext.put("webwork.portlet.modeNamespaceMap", this.modeMap);
        extraContext.put("webwork.portlet.phase", phase);
        AttributeMap attrMap = new AttributeMap(extraContext);
        extraContext.put("attr", attrMap);
        return extraContext;
    }

    public void serviceAction(PortletRequest request, PortletResponse response, ActionMapping mapping, Map requestMap, Map parameterMap, Map sessionMap, Map applicationMap, String portletNamespace, Integer phase) throws PortletException {
        LOG.debug((Object)"serviceAction");
        HashMap extraContext = this.createContextMap(requestMap, parameterMap, sessionMap, applicationMap, request, response, this.getPortletConfig(), phase);
        PortletMode mode = request.getPortletMode();
        String actionName = mapping.getName();
        String namespace = mapping.getNamespace();
        try {
            ActionProxy action;
            LOG.debug((Object)("Creating action proxy for name = " + actionName + ", namespace = " + namespace));
            ActionProxy proxy = this.factory.createActionProxy(namespace, actionName, (Map)extraContext);
            request.setAttribute("webwork.valueStack", (Object)proxy.getInvocation().getStack());
            if (PortletActionConstants.RENDER_PHASE.equals(phase) && StringUtils.isNotEmpty((String)request.getParameter("webwork.portlet.eventAction")) && (action = (ActionProxy)request.getPortletSession().getAttribute("webwork.portlet.eventAction")) != null) {
                OgnlValueStack stack = proxy.getInvocation().getStack();
                Object top = stack.pop();
                stack.push(action.getInvocation().getAction());
                stack.push(top);
            }
            proxy.execute();
            if (PortletActionConstants.EVENT_PHASE.equals(phase)) {
                ActionResponse actionResp = (ActionResponse)response;
                request.getPortletSession().setAttribute("webwork.portlet.eventAction", (Object)proxy);
                actionResp.setRenderParameter("webwork.portlet.eventAction", "true");
            }
        }
        catch (ConfigurationException e) {
            LOG.error((Object)"Could not find action", (Throwable)e);
            throw new PortletException("Could not find action " + actionName, (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Could not execute action", (Throwable)e);
            throw new PortletException("Error executing action " + actionName, (Throwable)e);
        }
    }

    protected Map getApplicationMap() {
        return new PortletApplicationMap(this.getPortletContext());
    }

    protected ActionMapping getActionMapping(PortletRequest request) {
        ActionMapping mapping = new ActionMapping();
        if (this.resetAction(request)) {
            mapping = (ActionMapping)this.actionMap.get(request.getPortletMode());
        } else {
            String actionPath = request.getParameter("webwork.portlet.action");
            if (StringUtils.isEmpty((String)actionPath)) {
                mapping = (ActionMapping)this.actionMap.get(request.getPortletMode());
            } else {
                String namespace = "";
                String action = actionPath;
                int idx = actionPath.lastIndexOf(47);
                if (idx >= 0) {
                    namespace = actionPath.substring(0, idx);
                    action = actionPath.substring(idx + 1);
                }
                mapping.setName(action);
                mapping.setNamespace(namespace);
            }
        }
        return mapping;
    }

    String getNamespace(String actionPath) {
        int idx = actionPath.lastIndexOf(47);
        String namespace = "";
        if (idx >= 0) {
            namespace = actionPath.substring(0, idx);
        }
        return namespace;
    }

    String getActionName(String actionPath) {
        int idx = actionPath.lastIndexOf(47);
        String action = actionPath;
        if (idx >= 0) {
            action = actionPath.substring(idx + 1);
        }
        return action;
    }

    protected Map getParameterMap(PortletRequest request) throws IOException {
        return new HashMap(request.getParameterMap());
    }

    protected Map getRequestMap(PortletRequest request) {
        return new PortletRequestMap(request);
    }

    protected Map getSessionMap(PortletRequest request) {
        return new PortletSessionMap(request);
    }

    protected void setActionProxyFactory(ActionProxyFactory factory) {
        this.factory = factory;
    }

    private boolean resetAction(PortletRequest request) {
        boolean reset = false;
        Map paramMap = request.getParameterMap();
        String[] modeParam = (String[])paramMap.get("webwork.portlet.mode");
        if (modeParam != null && modeParam.length == 1) {
            String originatingMode = modeParam[0];
            String currentMode = request.getPortletMode().toString();
            if (!currentMode.equals(originatingMode)) {
                reset = true;
            }
        }
        return reset;
    }
}

