/*
 * Copyright (c) 2002-2005 by OpenSymphony
 * All rights reserved.
 */
package com.opensymphony.xwork.validator.metadata;

/**
 * <code>ValidatorDescription</code>
 *
 * @author Rainer Hermanns
 * @version $Id: ValidatorDescription.java,v 1.2 2005/12/20 14:27:02 rainerh Exp $
 */
public interface ValidatorDescription {


    /**
     * Returns the validator XML definition.
     *
     * @return the validator XML definition.
     */
    String asXml();

    /**
     * Returns the field name to create the validation rule for.
     *
     * @return The field name to create the validation rule for
     */
    String getFieldName();

    /**
     * Sets the I18N message key.
     * @param key the I18N message key
     */
    void setKey(String key);

    /**
     * Sets the default validator failure message.
     *
     * @param message the default validator failure message
     */
    void setMessage(String message);

    /**
     * Set the shortCircuit flag.
     *
     * @param shortCircuit the shortCircuit flag.
     */
    void setShortCircuit(boolean shortCircuit);

    boolean isSimpleValidator();
}
