/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.apt;

import com.opensymphony.xwork.apt.Generator;
import com.opensymphony.xwork.conversion.metadata.ConversionDescription;
import com.sun.mirror.apt.Filer;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversionGenerator
extends Generator {
    Map<String, List<ConversionDescription>> conversionsByType = null;

    public ConversionGenerator(Map<String, List<ConversionDescription>> conversionsByType) {
        this.conversionsByType = conversionsByType;
    }

    @Override
    public void generate(Filer filer) {
        if (this.conversionsByType == null) {
            return;
        }
        for (Map.Entry<String, List<ConversionDescription>> descriptionMapping : this.conversionsByType.entrySet()) {
            String key = descriptionMapping.getKey();
            String fileName = key.equals("") ? "xwork-conversion.properties" : key.replace('.', File.separatorChar) + "-conversion.properties";
            try {
                PrintWriter writer = filer.createTextFile(Filer.Location.SOURCE_TREE, "", new File(fileName), null);
                writer.println("# Generated automatically. Do not edit!");
                for (ConversionDescription component : descriptionMapping.getValue()) {
                    writer.println(component.asProperty());
                }
                writer.flush();
                writer.close();
            }
            catch (IOException ioe) {
                throw new RuntimeException("could not generate conversion.properties: " + ioe, ioe);
            }
        }
    }
}

