/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.apt;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.declaration.MethodDeclaration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Generator {
    private static final Pattern SETTER_PATTERN = Pattern.compile("set([A-Z][A-Za-z0-9]*)$");
    private static final Pattern GETTER_PATTERN = Pattern.compile("(get|is|has)([A-Z][A-Za-z0-9]*)$");
    protected AnnotationProcessorEnvironment env;

    public void setEnv(AnnotationProcessorEnvironment env) {
        this.env = env;
    }

    public abstract void generate(Filer var1);

    public static String resolvePropertyName(MethodDeclaration method) {
        Matcher matcher = SETTER_PATTERN.matcher(method.getSimpleName());
        if (matcher.matches() && method.getParameters().size() == 1) {
            String raw = matcher.group(1);
            return raw.substring(0, 1).toLowerCase() + raw.substring(1);
        }
        matcher = GETTER_PATTERN.matcher(method.getSimpleName());
        if (matcher.matches() && method.getParameters().size() == 0) {
            String raw = matcher.group(2);
            return raw.substring(0, 1).toLowerCase() + raw.substring(1);
        }
        return null;
    }
}

