/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.interceptor.annotations;

import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.Interceptor;
import com.opensymphony.xwork.interceptor.PreResultListener;
import com.opensymphony.xwork.interceptor.annotations.After;
import com.opensymphony.xwork.interceptor.annotations.Before;
import com.opensymphony.xwork.interceptor.annotations.BeforeResult;
import com.opensymphony.xwork.util.AnnotationUtils;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

public class AnnotationWorkflowInterceptor
implements Interceptor,
PreResultListener {
    public String intercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        invocation.addPreResultListener((PreResultListener)this);
        for (Method m : AnnotationUtils.findAnnotatedMethods(action.getClass(), Before.class)) {
            String resultCode = (String)m.invoke(action, (Object[])null);
            if (resultCode == null) continue;
            return resultCode;
        }
        String invocationResult = invocation.invoke();
        List<Method> list = AnnotationUtils.findAnnotatedMethods(action.getClass(), After.class);
        Collections.reverse(list);
        for (Method m : list) {
            m.invoke(action, (Object[])null);
        }
        return invocationResult;
    }

    public void destroy() {
    }

    public void init() {
    }

    public void beforeResult(ActionInvocation invocation, String resultCode) {
        Object action = invocation.getAction();
        List<Method> methods = AnnotationUtils.findAnnotatedMethods(action.getClass(), BeforeResult.class);
        for (Method m : methods) {
            try {
                m.invoke(action, (Object[])null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

