/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.validator;

import com.opensymphony.util.FileManager;
import com.opensymphony.xwork.validator.ActionValidatorManager;
import com.opensymphony.xwork.validator.AnnotationValidationConfigurationBuilder;
import com.opensymphony.xwork.validator.DelegatingValidatorContext;
import com.opensymphony.xwork.validator.FieldValidator;
import com.opensymphony.xwork.validator.ShortCircuitableValidator;
import com.opensymphony.xwork.validator.ValidationException;
import com.opensymphony.xwork.validator.Validator;
import com.opensymphony.xwork.validator.ValidatorConfig;
import com.opensymphony.xwork.validator.ValidatorContext;
import com.opensymphony.xwork.validator.ValidatorFactory;
import com.opensymphony.xwork.validator.ValidatorFileParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationActionValidatorManager
extends ActionValidatorManager {
    protected static final String VALIDATION_CONFIG_SUFFIX = "-validation.xml";
    private static final Map<String, List<ValidatorConfig>> validatorCache = Collections.synchronizedMap(new HashMap());
    private static final Map<String, List<ValidatorConfig>> validatorFileCache = Collections.synchronizedMap(new HashMap());
    private static final Log LOG = LogFactory.getLog(AnnotationActionValidatorManager.class);

    public static synchronized List<Validator> getValidators(Class clazz, String context) {
        String validatorKey = AnnotationActionValidatorManager.buildValidatorKey(clazz, context);
        if (validatorCache.containsKey(validatorKey)) {
            if (FileManager.isReloadingConfigs()) {
                validatorCache.put(validatorKey, AnnotationActionValidatorManager.buildValidatorConfigs(clazz, context, true, null));
            }
        } else {
            validatorCache.put(validatorKey, AnnotationActionValidatorManager.buildValidatorConfigs(clazz, context, false, null));
        }
        List<ValidatorConfig> cfgs = validatorCache.get(validatorKey);
        ArrayList<Validator> validators = new ArrayList<Validator>(cfgs.size());
        for (ValidatorConfig cfg : cfgs) {
            Validator validator = ValidatorFactory.getValidator((ValidatorConfig)cfg);
            validators.add(validator);
        }
        return validators;
    }

    public static void validate(Object object, String context) throws ValidationException {
        DelegatingValidatorContext validatorContext = new DelegatingValidatorContext(object);
        AnnotationActionValidatorManager.validate(object, context, (ValidatorContext)validatorContext);
    }

    public static void validate(Object object, String context, ValidatorContext validatorContext) throws ValidationException {
        List<Validator> validators = AnnotationActionValidatorManager.getValidators(object.getClass(), context);
        TreeSet<String> shortcircuitedFields = null;
        for (Validator validator : validators) {
            validator.setValidatorContext(validatorContext);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Running validator: " + validator + " for object " + object));
            }
            FieldValidator fValidator = null;
            String fullFieldName = null;
            if (validator instanceof FieldValidator) {
                fValidator = (FieldValidator)validator;
                fullFieldName = fValidator.getValidatorContext().getFullFieldName(fValidator.getFieldName());
                if (shortcircuitedFields != null && shortcircuitedFields.contains(fullFieldName)) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)"Short-circuited, skipping");
                    continue;
                }
            }
            if (validator instanceof ShortCircuitableValidator && ((ShortCircuitableValidator)validator).isShortCircuit()) {
                Collection errCol;
                Collection actionErrors;
                ArrayList errs = null;
                if (fValidator != null) {
                    Collection fieldErrors;
                    if (validatorContext.hasFieldErrors() && (fieldErrors = (Collection)validatorContext.getFieldErrors().get(fullFieldName)) != null) {
                        errs = new ArrayList(fieldErrors);
                    }
                } else if (validatorContext.hasActionErrors() && (actionErrors = validatorContext.getActionErrors()) != null) {
                    errs = new ArrayList(actionErrors);
                }
                validator.validate(object);
                if (fValidator != null) {
                    if (!validatorContext.hasFieldErrors() || (errCol = (Collection)validatorContext.getFieldErrors().get(fullFieldName)) == null || ((Object)errCol).equals(errs)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Short-circuiting on field validation");
                    }
                    if (shortcircuitedFields == null) {
                        shortcircuitedFields = new TreeSet<String>();
                    }
                    shortcircuitedFields.add(fullFieldName);
                    continue;
                }
                if (!validatorContext.hasActionErrors() || (errCol = validatorContext.getActionErrors()) == null || ((Object)errCol).equals(errs)) continue;
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)"Short-circuiting");
                break;
            }
            validator.validate(object);
        }
    }

    protected static String buildValidatorKey(Class clazz, String context) {
        StringBuffer sb = new StringBuffer(clazz.getName());
        sb.append("/");
        sb.append(context);
        return sb.toString();
    }

    private static List<ValidatorConfig> buildAliasValidatorConfigs(Class aClass, String context, boolean checkFile) {
        String fileName = aClass.getName().replace('.', '/') + "-" + context + VALIDATION_CONFIG_SUFFIX;
        return AnnotationActionValidatorManager.loadFile(fileName, aClass, checkFile);
    }

    protected static List<ValidatorConfig> buildClassValidatorConfigs(Class aClass, boolean checkFile) {
        String fileName = aClass.getName().replace('.', '/') + VALIDATION_CONFIG_SUFFIX;
        ArrayList<ValidatorConfig> result = new ArrayList<ValidatorConfig>(AnnotationActionValidatorManager.loadFile(fileName, aClass, checkFile));
        ArrayList<ValidatorConfig> annotationResult = new ArrayList<ValidatorConfig>(AnnotationValidationConfigurationBuilder.buildAnnotationClassValidatorConfigs(aClass));
        result.addAll(annotationResult);
        return result;
    }

    private static List<ValidatorConfig> buildValidatorConfigs(Class clazz, String context, boolean checkFile, Set checked) {
        Class<?>[] interfaces;
        ArrayList<ValidatorConfig> validatorConfigs = new ArrayList<ValidatorConfig>();
        if (checked == null) {
            checked = new TreeSet<String>();
        } else if (checked.contains(clazz.getName())) {
            return validatorConfigs;
        }
        if (clazz.isInterface()) {
            for (Class<?> anInterface : interfaces = clazz.getInterfaces()) {
                validatorConfigs.addAll(AnnotationActionValidatorManager.buildValidatorConfigs(anInterface, context, checkFile, checked));
            }
        } else if (!clazz.equals(Object.class)) {
            validatorConfigs.addAll(AnnotationActionValidatorManager.buildValidatorConfigs(clazz.getSuperclass(), context, checkFile, checked));
        }
        for (Class<?> anInterface1 : interfaces = clazz.getInterfaces()) {
            if (checked.contains(anInterface1.getName())) continue;
            validatorConfigs.addAll(AnnotationActionValidatorManager.buildClassValidatorConfigs(anInterface1, checkFile));
            if (context != null) {
                validatorConfigs.addAll(AnnotationActionValidatorManager.buildAliasValidatorConfigs(anInterface1, context, checkFile));
            }
            checked.add(anInterface1.getName());
        }
        validatorConfigs.addAll(AnnotationActionValidatorManager.buildClassValidatorConfigs(clazz, checkFile));
        if (context != null) {
            validatorConfigs.addAll(AnnotationActionValidatorManager.buildAliasValidatorConfigs(clazz, context, checkFile));
        }
        checked.add(clazz.getName());
        return validatorConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ValidatorConfig> loadFile(String fileName, Class clazz, boolean checkFile) {
        List<ValidatorConfig> retList = Collections.emptyList();
        if (checkFile && FileManager.fileNeedsReloading((String)fileName) || !validatorFileCache.containsKey(fileName)) {
            InputStream is = null;
            try {
                is = FileManager.loadFile((String)fileName, (Class)clazz);
                if (is != null) {
                    retList = new ArrayList(ValidatorFileParser.parseActionValidatorConfigs((InputStream)is, (String)fileName));
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Caught exception while loading file " + fileName), (Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Unable to close input stream for " + fileName), (Throwable)e);
                    }
                }
            }
            validatorFileCache.put(fileName, retList);
        } else {
            retList = validatorFileCache.get(fileName);
        }
        return retList;
    }
}

