/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.ActionProxyFactory;
import com.opensymphony.xwork.Result;
import com.opensymphony.xwork.XworkException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionChainResult
implements Result {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$xwork$ActionChainResult == null ? (class$com$opensymphony$xwork$ActionChainResult = ActionChainResult.class$("com.opensymphony.xwork.ActionChainResult")) : class$com$opensymphony$xwork$ActionChainResult));
    public static final String DEFAULT_PARAM = "actionName";
    private static final String CHAIN_HISTORY = "CHAIN_HISTORY";
    private ActionProxy proxy;
    private String actionName;
    private String namespace;
    static /* synthetic */ Class class$com$opensymphony$xwork$ActionChainResult;

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public ActionProxy getProxy() {
        return this.proxy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActionChainResult)) {
            return false;
        }
        ActionChainResult actionChainResult = (ActionChainResult)o;
        return !(this.actionName != null ? !this.actionName.equals(actionChainResult.actionName) : actionChainResult.actionName != null);
    }

    public void execute(ActionInvocation invocation) throws Exception {
        if (this.isInChainHistory(this.namespace, this.actionName)) {
            throw new XworkException("infinite recursion detected");
        }
        this.addToHistory(this.namespace, this.actionName);
        HashMap<String, Object> extraContext = new HashMap<String, Object>();
        extraContext.put("com.opensymphony.xwork.util.OgnlValueStack.ValueStack", ActionContext.getContext().getValueStack());
        extraContext.put("com.opensymphony.xwork.ActionContext.parameters", ActionContext.getContext().getParameters());
        extraContext.put("com.opensymphony.xwork.interceptor.component.ComponentManager", ActionContext.getContext().get("com.opensymphony.xwork.interceptor.component.ComponentManager"));
        extraContext.put(CHAIN_HISTORY, ActionContext.getContext().get(CHAIN_HISTORY));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Chaining to action " + this.actionName));
        }
        if (this.namespace == null) {
            this.namespace = invocation.getProxy().getNamespace();
        }
        this.proxy = ActionProxyFactory.getFactory().createActionProxy(this.namespace, this.actionName, extraContext);
        this.proxy.execute();
    }

    public int hashCode() {
        return this.actionName != null ? this.actionName.hashCode() : 0;
    }

    private boolean isInChainHistory(String namespace, String actionName) {
        Set chainHistory = (Set)ActionContext.getContext().get(CHAIN_HISTORY);
        if (chainHistory == null) {
            return false;
        }
        return chainHistory.contains(this.makeKey(namespace, actionName));
    }

    private void addToHistory(String namespace, String actionName) {
        HashSet<String> chainHistory = (HashSet<String>)ActionContext.getContext().get(CHAIN_HISTORY);
        if (chainHistory == null) {
            chainHistory = new HashSet<String>();
        }
        ActionContext.getContext().put(CHAIN_HISTORY, chainHistory);
        chainHistory.add(this.makeKey(namespace, actionName));
    }

    private String makeKey(String namespace, String actionName) {
        return namespace + "/" + actionName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

