/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork;

import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ActionContext {
    static ThreadLocal actionContext = new ActionContextThreadLocal();
    public static final String ACTION_NAME = "com.opensymphony.xwork.ActionContext.name";
    public static final String VALUE_STACK = "com.opensymphony.xwork.util.OgnlValueStack.ValueStack";
    public static final String SESSION = "com.opensymphony.xwork.ActionContext.session";
    public static final String APPLICATION = "com.opensymphony.xwork.ActionContext.application";
    public static final String PARAMETERS = "com.opensymphony.xwork.ActionContext.parameters";
    public static final String LOCALE = "com.opensymphony.xwork.ActionContext.locale";
    public static final String TYPE_CONVERTER = "com.opensymphony.xwork.ActionContext.typeConverter";
    public static final String ACTION_INVOCATION = "com.opensymphony.xwork.ActionContext.actionInvocation";
    public static final String CONVERSION_ERRORS = "com.opensymphony.xwork.ActionContext.conversionErrors";
    Map context;

    public ActionContext(Map context) {
        this.context = context;
    }

    public void setActionInvocation(ActionInvocation actionInvocation) {
        this.put(ACTION_INVOCATION, actionInvocation);
    }

    public ActionInvocation getActionInvocation() {
        return (ActionInvocation)this.get(ACTION_INVOCATION);
    }

    public void setApplication(Map application) {
        this.put(APPLICATION, application);
    }

    public Map getApplication() {
        return (Map)this.get(APPLICATION);
    }

    public static void setContext(ActionContext context) {
        actionContext.set(context);
    }

    public static ActionContext getContext() {
        ActionContext context = (ActionContext)actionContext.get();
        if (context == null) {
            OgnlValueStack vs = new OgnlValueStack();
            context = new ActionContext(vs.getContext());
            ActionContext.setContext(context);
        }
        return context;
    }

    public void setContextMap(Map contextMap) {
        ActionContext.getContext().context = contextMap;
    }

    public Map getContextMap() {
        return this.context;
    }

    public void setConversionErrors(Map conversionErrors) {
        this.put(CONVERSION_ERRORS, conversionErrors);
    }

    public Map getConversionErrors() {
        HashMap errors = (HashMap)this.get(CONVERSION_ERRORS);
        if (errors == null) {
            errors = new HashMap();
            this.setConversionErrors(errors);
        }
        return errors;
    }

    public void setLocale(Locale locale) {
        this.put(LOCALE, locale);
    }

    public Locale getLocale() {
        Locale locale = (Locale)this.get(LOCALE);
        if (locale == null) {
            locale = Locale.getDefault();
            this.setLocale(locale);
        }
        return locale;
    }

    public void setName(String name) {
        this.put(ACTION_NAME, name);
    }

    public String getName() {
        return (String)this.get(ACTION_NAME);
    }

    public void setParameters(Map parameters) {
        this.put(PARAMETERS, parameters);
    }

    public Map getParameters() {
        return (Map)this.get(PARAMETERS);
    }

    public void setSession(Map session) {
        this.put(SESSION, session);
    }

    public Map getSession() {
        return (Map)this.get(SESSION);
    }

    public void setValueStack(OgnlValueStack stack) {
        this.put(VALUE_STACK, stack);
    }

    public OgnlValueStack getValueStack() {
        return (OgnlValueStack)this.get(VALUE_STACK);
    }

    public Object get(Object key) {
        return this.context.get(key);
    }

    public void put(Object key, Object value) {
        this.context.put(key, value);
    }

    private static class ActionContextThreadLocal
    extends ThreadLocal {
        private ActionContextThreadLocal() {
        }

        protected Object initialValue() {
            OgnlValueStack vs = new OgnlValueStack();
            return new ActionContext(vs.getContext());
        }
    }
}

