/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork;

import com.opensymphony.util.ClassLoaderUtil;
import com.opensymphony.xwork.Action;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.Result;
import com.opensymphony.xwork.config.ConfigurationException;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.config.entities.InterceptorConfig;
import com.opensymphony.xwork.config.entities.ResultConfig;
import com.opensymphony.xwork.interceptor.Interceptor;
import com.opensymphony.xwork.util.OgnlUtil;
import com.opensymphony.xwork.validator.Validator;
import java.util.HashMap;
import java.util.Map;

public class ObjectFactory {
    private static ObjectFactory FACTORY = new ObjectFactory();
    private Map classes = new HashMap();

    protected ObjectFactory() {
    }

    public static void setObjectFactory(ObjectFactory factory) {
        FACTORY = factory;
    }

    public static ObjectFactory getObjectFactory() {
        return FACTORY;
    }

    public Class getClassInstance(String className) throws ClassNotFoundException {
        Class clazz = (Class)this.classes.get(className);
        if (clazz == null) {
            clazz = ClassLoaderUtil.loadClass((String)className, this.getClass());
            this.classes.put(className, clazz);
        }
        return clazz;
    }

    public Action buildAction(ActionConfig config) throws Exception {
        return (Action)this.buildBean(config.getClassName());
    }

    public Object buildBean(Class clazz) throws Exception {
        return clazz.newInstance();
    }

    public Object buildBean(String className) throws Exception {
        Class clazz = this.getClassInstance(className);
        return clazz.newInstance();
    }

    /*
     * WARNING - void declaration
     */
    public Interceptor buildInterceptor(InterceptorConfig interceptorConfig, Map interceptorRefParams) throws ConfigurationException {
        void var5_11;
        String message;
        Interceptor interceptor = null;
        String interceptorClassName = interceptorConfig.getClassName();
        Map thisInterceptorClassParams = interceptorConfig.getParams();
        HashMap params = thisInterceptorClassParams == null ? new HashMap() : new HashMap(thisInterceptorClassParams);
        params.putAll(interceptorRefParams);
        try {
            interceptor = (Interceptor)this.buildBean(interceptorClassName);
            OgnlUtil.setProperties(params, interceptor);
            interceptor.init();
            return interceptor;
        }
        catch (InstantiationException e) {
            message = "Unable to instantiate an instance of Interceptor class [" + interceptorClassName + "].";
        }
        catch (IllegalAccessException e) {
            message = "IllegalAccessException while attempting to instantiate an instance of Interceptor class [" + interceptorClassName + "].";
        }
        catch (ClassCastException e) {
            message = "Class [" + interceptorClassName + "] does not implement com.opensymphony.xwork.interceptor.Interceptor";
        }
        catch (Exception e) {
            throw new ConfigurationException("Caught Exception while registering Interceptor class " + interceptorClassName, e);
        }
        throw new ConfigurationException((String)var5_11);
    }

    public Result buildResult(ResultConfig resultConfig) throws Exception {
        String resultClassName = resultConfig.getClassName();
        Result result = null;
        if (resultClassName != null) {
            result = (Result)this.buildBean(resultClassName);
            OgnlUtil.setProperties(resultConfig.getParams(), (Object)result, ActionContext.getContext().getContextMap());
        }
        return result;
    }

    public Validator buildValidator(String className, Map params) throws Exception {
        Validator validator = (Validator)this.buildBean(className);
        OgnlUtil.setProperties(params, validator);
        return validator;
    }
}

