/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.util;

import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.XworkException;
import java.lang.reflect.Array;
import java.lang.reflect.Member;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import ognl.DefaultTypeConverter;
import ognl.Ognl;
import ognl.TypeConverter;

public class XWorkBasicConverter
extends DefaultTypeConverter {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$Class;

    public Object convertValue(Map context, Object o, Member member, String s, Object value, Class toType) {
        Object result = null;
        if (toType == (class$java$lang$String == null ? (class$java$lang$String = XWorkBasicConverter.class$("java.lang.String")) : class$java$lang$String)) {
            result = this.doConvertToString(context, value);
        } else if (toType == Boolean.TYPE) {
            result = this.doConvertToBoolean(context, value);
        } else if (toType == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = XWorkBasicConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            result = this.doConvertToBoolean(context, value);
        } else if (toType.isArray()) {
            result = this.doConvertToArray(context, o, member, s, value, toType);
        } else if (toType == (class$java$util$Date == null ? (class$java$util$Date = XWorkBasicConverter.class$("java.util.Date")) : class$java$util$Date)) {
            result = this.doConvertToDate(context, value);
        } else if (toType == (class$java$util$List == null ? (class$java$util$List = XWorkBasicConverter.class$("java.util.List")) : class$java$util$List)) {
            result = this.doConvertToList(context, value);
        } else if (toType == (class$java$util$Set == null ? (class$java$util$Set = XWorkBasicConverter.class$("java.util.Set")) : class$java$util$Set)) {
            result = this.doConvertToSet(context, value);
        } else if (toType == (class$java$util$Collection == null ? (class$java$util$Collection = XWorkBasicConverter.class$("java.util.Collection")) : class$java$util$Collection)) {
            result = this.doConvertToList(context, value);
        } else if (toType == (class$java$lang$Class == null ? (class$java$lang$Class = XWorkBasicConverter.class$("java.lang.Class")) : class$java$lang$Class)) {
            result = this.doConvertToClass(context, value);
        }
        if (result == null) {
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                if (array != null && array.length >= 1) {
                    value = array[0];
                }
                result = this.convertValue(context, o, member, s, value, toType);
            } else {
                result = super.convertValue(context, value, toType);
            }
        }
        return result;
    }

    private Locale getLocale(Map context) {
        Locale locale = (Locale)context.get("com.opensymphony.xwork.ActionContext.locale");
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    private Object doConvertToArray(Map context, Object o, Member member, String s, Object value, Class toType) {
        Object result = null;
        Class<?> componentType = toType.getComponentType();
        if (componentType != null) {
            TypeConverter converter = Ognl.getTypeConverter((Map)context);
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                result = Array.newInstance(componentType, length);
                for (int i = 0; i < length; ++i) {
                    Object valueItem = Array.get(value, i);
                    Array.set(result, i, converter.convertValue(context, o, member, s, valueItem, componentType));
                }
            } else {
                result = Array.newInstance(componentType, 1);
                Array.set(result, 0, converter.convertValue(context, o, member, s, value, componentType));
            }
        }
        return result;
    }

    private Object doConvertToBoolean(Map context, Object value) {
        if (value instanceof String) {
            String bStr = (String)value;
            return Boolean.valueOf(bStr);
        }
        return null;
    }

    private Class doConvertToClass(Map context, Object value) {
        Class<?> clazz = null;
        if (value instanceof String) {
            try {
                clazz = Class.forName((String)value);
            }
            catch (ClassNotFoundException e) {
                throw new XworkException(e.getLocalizedMessage(), e);
            }
        }
        return clazz;
    }

    private Object doConvertToDate(Map context, Object value) {
        Date result = null;
        if (value instanceof String) {
            String sa = (String)value;
            Locale locale = this.getLocale(context);
            DateFormat df = DateFormat.getDateInstance(3, locale);
            try {
                result = df.parse(sa);
            }
            catch (ParseException e) {
                throw new XworkException("Could not parse date", e);
            }
        } else if ((class$java$util$Date == null ? (class$java$util$Date = XWorkBasicConverter.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(value.getClass())) {
            result = (Date)value;
        }
        return result;
    }

    private List doConvertToList(Map context, Object value) {
        List<String> result = null;
        if (value instanceof String[]) {
            String[] sa = (String[])value;
            result = new ArrayList(sa.length);
            for (int i = 0; i < sa.length; ++i) {
                String s = sa[i];
                result.add(s);
            }
        } else if ((class$java$util$List == null ? (class$java$util$List = XWorkBasicConverter.class$("java.util.List")) : class$java$util$List).isAssignableFrom(value.getClass())) {
            result = (List)value;
        }
        return result;
    }

    private Object doConvertToSet(Map context, Object value) {
        Set<String> result = null;
        if (value instanceof String[]) {
            String[] sa = (String[])value;
            result = new HashSet(sa.length);
            for (int i = 0; i < sa.length; ++i) {
                String s = sa[i];
                result.add(s);
            }
        } else if ((class$java$util$Set == null ? (class$java$util$Set = XWorkBasicConverter.class$("java.util.Set")) : class$java$util$Set).isAssignableFrom(value.getClass())) {
            result = (Set)value;
        }
        return result;
    }

    private String doConvertToString(Map context, Object value) {
        String result = null;
        if (value instanceof int[]) {
            int[] x = (int[])value;
            ArrayList<Integer> intArray = new ArrayList<Integer>(x.length);
            for (int i = 0; i < x.length; ++i) {
                intArray.add(new Integer(x[i]));
            }
            result = TextUtils.join((String)", ", intArray);
        } else if (value instanceof long[]) {
            long[] x = (long[])value;
            ArrayList<Long> intArray = new ArrayList<Long>(x.length);
            for (int i = 0; i < x.length; ++i) {
                intArray.add(new Long(x[i]));
            }
            result = TextUtils.join((String)", ", intArray);
        } else if (value instanceof double[]) {
            double[] x = (double[])value;
            ArrayList<Double> intArray = new ArrayList<Double>(x.length);
            for (int i = 0; i < x.length; ++i) {
                intArray.add(new Double(x[i]));
            }
            result = TextUtils.join((String)", ", intArray);
        } else if (value instanceof boolean[]) {
            boolean[] x = (boolean[])value;
            ArrayList<Boolean> intArray = new ArrayList<Boolean>(x.length);
            for (int i = 0; i < x.length; ++i) {
                intArray.add(new Boolean(x[i]));
            }
            result = TextUtils.join((String)", ", intArray);
        } else if (value instanceof Date) {
            DateFormat df = DateFormat.getDateInstance(3, this.getLocale(context));
            result = df.format(value);
        } else if (value instanceof String[]) {
            result = TextUtils.join((String)", ", (String[])((String[])value));
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

