/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.validator;

import com.opensymphony.util.FileManager;
import com.opensymphony.xwork.validator.DelegatingValidatorContext;
import com.opensymphony.xwork.validator.FieldValidator;
import com.opensymphony.xwork.validator.ShortCircuitableValidator;
import com.opensymphony.xwork.validator.ValidationException;
import com.opensymphony.xwork.validator.Validator;
import com.opensymphony.xwork.validator.ValidatorContext;
import com.opensymphony.xwork.validator.ValidatorFileParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionValidatorManager {
    protected static final String VALIDATION_CONFIG_SUFFIX = "-validation.xml";
    private static final Map validatorCache = Collections.synchronizedMap(new HashMap());
    private static final Map validatorFileCache = Collections.synchronizedMap(new HashMap());
    private static final Log LOG = LogFactory.getLog((Class)(class$com$opensymphony$xwork$validator$ActionValidatorManager == null ? (class$com$opensymphony$xwork$validator$ActionValidatorManager = ActionValidatorManager.class$("com.opensymphony.xwork.validator.ActionValidatorManager")) : class$com$opensymphony$xwork$validator$ActionValidatorManager));
    static /* synthetic */ Class class$com$opensymphony$xwork$validator$ActionValidatorManager;
    static /* synthetic */ Class class$java$lang$Object;

    public static synchronized List getValidators(Class clazz, String context) {
        String validatorKey = ActionValidatorManager.buildValidatorKey(clazz, context);
        if (validatorCache.containsKey(validatorKey)) {
            ActionValidatorManager.conditionalReload(clazz, context);
        } else {
            List validators = ActionValidatorManager.buildValidators(clazz, context, false);
            validatorCache.put(validatorKey, validators);
        }
        return (List)validatorCache.get(validatorKey);
    }

    public static void validate(Object object, String context) throws ValidationException {
        DelegatingValidatorContext validatorContext = new DelegatingValidatorContext(object);
        ActionValidatorManager.validate(object, context, validatorContext);
    }

    public static void validate(Object object, String context, ValidatorContext validatorContext) throws ValidationException {
        List validators = ActionValidatorManager.getValidators(object.getClass(), context);
        TreeSet<String> shortcircuitedFields = null;
        Iterator iterator = validators.iterator();
        while (iterator.hasNext()) {
            Validator validator = (Validator)iterator.next();
            validator.setValidatorContext(validatorContext);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Running validator: " + validator + " for object " + object));
            }
            FieldValidator fValidator = null;
            if (validator instanceof FieldValidator) {
                fValidator = (FieldValidator)validator;
                if (shortcircuitedFields != null && shortcircuitedFields.contains(fValidator.getFieldName())) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)"Short-circuited, skipping");
                    continue;
                }
            }
            if (validator instanceof ShortCircuitableValidator && ((ShortCircuitableValidator)((Object)validator)).isShortCircuit()) {
                Collection errCol;
                Collection actionErrors;
                int errs = 0;
                if (fValidator != null) {
                    Collection fieldErrors;
                    if (validatorContext.hasFieldErrors() && (fieldErrors = (Collection)validatorContext.getFieldErrors().get(fValidator.getFieldName())) != null) {
                        errs = fieldErrors.size();
                    }
                } else if (validatorContext.hasActionErrors() && (actionErrors = validatorContext.getActionErrors()) != null) {
                    errs = actionErrors.size();
                }
                validator.validate(object);
                if (fValidator != null) {
                    if (!validatorContext.hasFieldErrors() || (errCol = (Collection)validatorContext.getFieldErrors().get(fValidator.getFieldName())) == null || errCol.size() <= errs) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Short-circuiting on field validation");
                    }
                    if (shortcircuitedFields == null) {
                        shortcircuitedFields = new TreeSet<String>();
                    }
                    shortcircuitedFields.add(fValidator.getFieldName());
                    continue;
                }
                if (!validatorContext.hasActionErrors() || (errCol = validatorContext.getActionErrors()) == null || errCol.size() <= errs) continue;
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)"Short-circuiting");
                break;
            }
            validator.validate(object);
        }
    }

    protected static String buildValidatorKey(Class clazz, String context) {
        StringBuffer sb = new StringBuffer(clazz.getName());
        sb.append("/");
        sb.append(context);
        return sb.toString();
    }

    private static List buildAliasValidators(Class aClass, String context, boolean checkFile) {
        String fileName = aClass.getName().replace('.', '/') + "-" + context + VALIDATION_CONFIG_SUFFIX;
        return ActionValidatorManager.loadFile(fileName, aClass, checkFile);
    }

    private static List buildClassValidators(Class aClass, boolean checkFile) {
        String fileName = aClass.getName().replace('.', '/') + VALIDATION_CONFIG_SUFFIX;
        return ActionValidatorManager.loadFile(fileName, aClass, checkFile);
    }

    private static List buildValidators(Class clazz, String context, boolean checkFile) {
        ArrayList validators = new ArrayList();
        if (!clazz.equals(class$java$lang$Object == null ? (class$java$lang$Object = ActionValidatorManager.class$("java.lang.Object")) : class$java$lang$Object)) {
            validators.addAll(ActionValidatorManager.buildValidators(clazz.getSuperclass(), context, checkFile));
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int x = 0; x < interfaces.length; ++x) {
            validators.addAll(ActionValidatorManager.buildClassValidators(interfaces[x], checkFile));
            if (context == null) continue;
            validators.addAll(ActionValidatorManager.buildAliasValidators(interfaces[x], context, checkFile));
        }
        validators.addAll(ActionValidatorManager.buildClassValidators(clazz, checkFile));
        if (context != null) {
            validators.addAll(ActionValidatorManager.buildAliasValidators(clazz, context, checkFile));
        }
        return validators;
    }

    private static void conditionalReload(Class clazz, String context) {
        if (FileManager.isReloadingConfigs()) {
            String actionName = ActionValidatorManager.buildValidatorKey(clazz, context);
            validatorCache.put(actionName, ActionValidatorManager.buildValidators(clazz, context, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static List loadFile(String fileName, Class clazz, boolean checkFile) {
        retList = Collections.EMPTY_LIST;
        if (checkFile && FileManager.fileNeedsReloading((String)fileName) || !ActionValidatorManager.validatorFileCache.containsKey(fileName)) {
            block14: {
                is = null;
                try {
                    block13: {
                        is = FileManager.loadFile((String)fileName, (Class)clazz);
                        if (is == null) break block13;
                        retList = new ArrayList<E>(ValidatorFileParser.parseActionValidators(is));
                    }
                    var7_5 = null;
                    ** if (is == null) goto lbl-1000
                }
                catch (Throwable var6_12) {
                    var7_7 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            ActionValidatorManager.LOG.error((Object)"Unable to close input stream", (Throwable)e);
                        }
                    }
                    throw var6_12;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        ActionValidatorManager.LOG.error((Object)"Unable to close input stream", (Throwable)e);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block14;
                    catch (Exception e) {
                        ActionValidatorManager.LOG.error((Object)("Caught exception while loading file " + fileName), (Throwable)e);
                        var7_6 = null;
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e) {
                                ActionValidatorManager.LOG.error((Object)"Unable to close input stream", (Throwable)e);
                            }
                        }
                    }
                }
            }
            ActionValidatorManager.validatorFileCache.put(fileName, retList);
        } else {
            retList = (List)ActionValidatorManager.validatorFileCache.get(fileName);
        }
        return retList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

