/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.validator;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.LocaleProvider;
import com.opensymphony.xwork.TextProvider;
import com.opensymphony.xwork.TextProviderSupport;
import com.opensymphony.xwork.ValidationAware;
import com.opensymphony.xwork.validator.ValidatorContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DelegatingValidatorContext
implements ValidatorContext {
    private LocaleProvider localeProvider;
    private TextProvider textProvider;
    private ValidationAware validationAware;

    public DelegatingValidatorContext(ValidationAware validationAware, TextProvider textProvider, LocaleProvider localeProvider) {
        this.textProvider = textProvider;
        this.validationAware = validationAware;
        this.localeProvider = localeProvider;
    }

    public DelegatingValidatorContext(Object object) {
        this.localeProvider = DelegatingValidatorContext.makeLocaleProvider(object);
        this.validationAware = DelegatingValidatorContext.makeValidationAware(object);
        this.textProvider = DelegatingValidatorContext.makeTextProvider(object, this.localeProvider);
    }

    public void setActionErrors(Collection errorMessages) {
        this.validationAware.setActionErrors(errorMessages);
    }

    public Collection getActionErrors() {
        return this.validationAware.getActionErrors();
    }

    public void setActionMessages(Collection messages) {
        this.validationAware.setActionMessages(messages);
    }

    public Collection getActionMessages() {
        return this.validationAware.getActionMessages();
    }

    public void setFieldErrors(Map errorMap) {
        this.validationAware.setFieldErrors(errorMap);
    }

    public Map getFieldErrors() {
        return this.validationAware.getFieldErrors();
    }

    public String getFullFieldName(String fieldName) {
        return fieldName;
    }

    public Locale getLocale() {
        return this.localeProvider.getLocale();
    }

    public String getText(String aTextName) {
        return this.textProvider.getText(aTextName);
    }

    public String getText(String aTextName, String defaultValue) {
        return this.textProvider.getText(aTextName, defaultValue);
    }

    public String getText(String aTextName, List args) {
        return this.textProvider.getText(aTextName, args);
    }

    public String getText(String aTextName, String defaultValue, List args) {
        return this.textProvider.getText(aTextName, defaultValue, args);
    }

    public ResourceBundle getTexts(String aBundleName) {
        return this.textProvider.getTexts(aBundleName);
    }

    public ResourceBundle getTexts() {
        return this.textProvider.getTexts();
    }

    public void addActionError(String anErrorMessage) {
        this.validationAware.addActionError(anErrorMessage);
    }

    public void addActionMessage(String aMessage) {
        this.validationAware.addActionMessage(aMessage);
    }

    public void addFieldError(String fieldName, String errorMessage) {
        this.validationAware.addFieldError(fieldName, errorMessage);
    }

    public boolean hasActionErrors() {
        return this.validationAware.hasActionErrors();
    }

    public boolean hasActionMessages() {
        return this.validationAware.hasActionMessages();
    }

    public boolean hasErrors() {
        return this.validationAware.hasErrors();
    }

    public boolean hasFieldErrors() {
        return this.validationAware.hasFieldErrors();
    }

    public static TextProvider makeTextProvider(Object object, LocaleProvider localeProvider) {
        if (object instanceof TextProvider) {
            return (TextProvider)object;
        }
        return new TextProviderSupport(object.getClass(), localeProvider);
    }

    protected static LocaleProvider makeLocaleProvider(Object object) {
        if (object instanceof LocaleProvider) {
            return (LocaleProvider)object;
        }
        return new ActionContextLocaleProvider();
    }

    protected static ValidationAware makeValidationAware(Object object) {
        if (object instanceof ValidationAware) {
            return (ValidationAware)object;
        }
        return new LoggingValidationAware(object);
    }

    protected void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    protected TextProvider getTextProvider() {
        return this.textProvider;
    }

    protected void setValidationAware(ValidationAware validationAware) {
        this.validationAware = validationAware;
    }

    protected ValidationAware getValidationAware() {
        return this.validationAware;
    }

    private static class LoggingValidationAware
    implements ValidationAware {
        private Log log;

        public LoggingValidationAware(Object obj) {
            this.log = LogFactory.getLog(obj.getClass());
        }

        public void setActionErrors(Collection errorMessages) {
            Iterator iterator = errorMessages.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                this.addActionError(s);
            }
        }

        public Collection getActionErrors() {
            return null;
        }

        public void setActionMessages(Collection messages) {
            Iterator iterator = messages.iterator();
            while (iterator.hasNext()) {
                String s = (String)iterator.next();
                this.addActionMessage(s);
            }
        }

        public Collection getActionMessages() {
            return null;
        }

        public void setFieldErrors(Map errorMap) {
            Iterator iterator = errorMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.addFieldError((String)entry.getKey(), (String)entry.getValue());
            }
        }

        public Map getFieldErrors() {
            return null;
        }

        public void addActionError(String anErrorMessage) {
            this.log.error((Object)("Validation error: " + anErrorMessage));
        }

        public void addActionMessage(String aMessage) {
            this.log.info((Object)("Validation Message: " + aMessage));
        }

        public void addFieldError(String fieldName, String errorMessage) {
            this.log.error((Object)("Validation error for " + fieldName + ":" + errorMessage));
        }

        public boolean hasActionErrors() {
            return false;
        }

        public boolean hasActionMessages() {
            return false;
        }

        public boolean hasErrors() {
            return false;
        }

        public boolean hasFieldErrors() {
            return false;
        }
    }

    private static class ActionContextLocaleProvider
    implements LocaleProvider {
        private ActionContextLocaleProvider() {
        }

        public Locale getLocale() {
            return ActionContext.getContext().getLocale();
        }
    }
}

