/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork;

import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ActionProxy;
import com.opensymphony.xwork.ActionProxyFactory;
import com.opensymphony.xwork.config.ConfigurationException;
import com.opensymphony.xwork.config.ConfigurationManager;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.util.LocalizedTextUtil;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultActionProxy
implements ActionProxy,
Serializable {
    private static final long serialVersionUID = -7325819968808474533L;
    private static final Log LOG = LogFactory.getLog((Class)DefaultActionProxy.class);
    protected ActionConfig config;
    protected ActionInvocation invocation;
    protected Map extraContext;
    protected String actionName;
    protected String namespace;
    protected String method;
    protected boolean executeResult;
    protected boolean cleanupContext;

    protected DefaultActionProxy(String namespace, String actionName, Map extraContext, boolean executeResult, boolean cleanupContext) throws Exception {
        this.cleanupContext = cleanupContext;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating an DefaultActionProxy for namespace " + namespace + " and action name " + actionName));
        }
        this.actionName = actionName;
        this.namespace = namespace;
        this.executeResult = executeResult;
        this.extraContext = extraContext;
        this.config = ConfigurationManager.getConfiguration().getRuntimeConfiguration().getActionConfig(namespace, actionName);
        if (this.config == null) {
            String message = namespace != null && namespace.trim().length() > 0 ? LocalizedTextUtil.findDefaultText("xwork.exception.missing-package-action", Locale.getDefault(), new String[]{namespace, actionName}) : LocalizedTextUtil.findDefaultText("xwork.exception.missing-action", Locale.getDefault(), new String[]{actionName});
            throw new ConfigurationException(message);
        }
        this.prepare();
    }

    public Object getAction() {
        return this.invocation.getAction();
    }

    public String getActionName() {
        return this.actionName;
    }

    public ActionConfig getConfig() {
        return this.config;
    }

    public void setExecuteResult(boolean executeResult) {
        this.executeResult = executeResult;
    }

    public boolean getExecuteResult() {
        return this.executeResult;
    }

    public ActionInvocation getInvocation() {
        return this.invocation;
    }

    public String getNamespace() {
        return this.namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        ActionContext nestedContext = ActionContext.getContext();
        ActionContext.setContext(this.invocation.getInvocationContext());
        String retCode = null;
        try {
            retCode = this.invocation.invoke();
        }
        finally {
            if (this.cleanupContext) {
                ActionContext.setContext(nestedContext);
            }
        }
        return retCode;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
        this.resolveMethod();
    }

    private void resolveMethod() {
        if (!TextUtils.stringSet((String)this.method)) {
            this.method = this.config.getMethodName();
            if (!TextUtils.stringSet((String)this.method)) {
                this.method = "execute";
            }
        }
    }

    protected void prepare() throws Exception {
        this.invocation = ActionProxyFactory.getFactory().createActionInvocation(this, this.extraContext);
        this.resolveMethod();
    }
}

