/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.interceptor;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ValidationAware;
import com.opensymphony.xwork.interceptor.AroundInterceptor;
import com.opensymphony.xwork.interceptor.PreResultListener;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.util.XWorkConverter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ConversionErrorInterceptor
extends AroundInterceptor {
    public static final String ORIGINAL_PROPERTY_OVERRIDE = "original.property.override";

    protected Object getOverrideExpr(ActionInvocation invocation, Object value) {
        return "'" + value + "'";
    }

    protected void after(ActionInvocation dispatcher, String result) throws Exception {
    }

    protected void before(ActionInvocation invocation) throws Exception {
        ActionContext invocationContext = invocation.getInvocationContext();
        Map conversionErrors = invocationContext.getConversionErrors();
        OgnlValueStack stack = invocationContext.getValueStack();
        HashMap<String, Object> fakie = null;
        Iterator iterator = conversionErrors.entrySet().iterator();
        while (iterator.hasNext()) {
            Object value;
            Map.Entry entry = iterator.next();
            String propertyName = (String)entry.getKey();
            if (!this.shouldAddError(propertyName, value = entry.getValue())) continue;
            String message = XWorkConverter.getConversionErrorMessage(propertyName, stack);
            Object action = invocation.getAction();
            if (action instanceof ValidationAware) {
                ValidationAware va = (ValidationAware)action;
                va.addFieldError(propertyName, message);
            }
            if (fakie == null) {
                fakie = new HashMap<String, Object>();
            }
            fakie.put(propertyName, this.getOverrideExpr(invocation, value));
        }
        if (fakie != null) {
            stack.getContext().put(ORIGINAL_PROPERTY_OVERRIDE, fakie);
            invocation.addPreResultListener(new PreResultListener(){

                public void beforeResult(ActionInvocation invocation, String resultCode) {
                    Map fakie = (Map)invocation.getInvocationContext().get(ConversionErrorInterceptor.ORIGINAL_PROPERTY_OVERRIDE);
                    if (fakie != null) {
                        invocation.getStack().setExprOverrides(fakie);
                    }
                }
            });
        }
    }

    protected boolean shouldAddError(String propertyName, Object value) {
        return true;
    }
}

