/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.validator.validators;

import com.opensymphony.xwork.XworkException;
import com.opensymphony.xwork.util.OgnlUtil;
import com.opensymphony.xwork.validator.ActionValidatorManagerFactory;
import com.opensymphony.xwork.validator.FieldValidator;
import com.opensymphony.xwork.validator.ShortCircuitableValidator;
import com.opensymphony.xwork.validator.ValidationException;
import com.opensymphony.xwork.validator.Validator;
import com.opensymphony.xwork.validator.ValidatorConfig;
import com.opensymphony.xwork.validator.ValidatorFactory;
import com.opensymphony.xwork.validator.validators.FieldValidatorSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import ognl.OgnlException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CollectionFieldValidator
extends FieldValidatorSupport {
    private static final Log LOG = LogFactory.getLog((Class)CollectionFieldValidator.class);
    private String property;
    private String validatorRef;
    private Map validatorParams = new LinkedHashMap();

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String collection) {
        this.property = collection;
    }

    public String getValidatorRef() {
        return this.validatorRef;
    }

    public void setValidatorRef(String validatorRef) {
        this.validatorRef = validatorRef;
    }

    public void setValidatorParams(Map validatorParams) {
        this.validatorParams = validatorParams;
    }

    public Map getValidatorParams() {
        return this.validatorParams;
    }

    public void validate(Object object) throws ValidationException {
        if (this.property == null || this.property.trim().length() <= 0) {
            throw new XworkException("collection property cannot be null or empty, it is needed to specify a property that doesn't return back a Collection");
        }
        ValidatorFactory.lookupRegisteredValidatorType(this.validatorRef);
        Object obj = this.getFieldValue(this.getFieldName(), object);
        if (obj != null) {
            ArrayList result = new ArrayList();
            PropertySpliter spliter = new PropertySpliter(this.property);
            try {
                String overallProperty = "";
                this.populateValue(object, spliter.iterator(), result, overallProperty);
            }
            catch (Exception e) {
                throw new XworkException(e.toString(), e);
            }
            Validator validator = ValidatorFactory.getValidator(new ValidatorConfig(this.validatorRef, this.validatorParams));
            validator.setValidatorContext(this.getValidatorContext());
            if (this.validatorParams.containsKey("defaultMessage")) {
                validator.setDefaultMessage((String)this.validatorParams.get("defaultMessage"));
            }
            if (this.validatorParams.containsKey("messageKey")) {
                validator.setDefaultMessage((String)this.validatorParams.get("messageKey"));
            }
            if (this.validatorParams.containsKey("shortCircuit") && validator instanceof ShortCircuitableValidator) {
                ((ShortCircuitableValidator)((Object)validator)).setShortCircuit(this.validatorParams.get("shortCircuit").equals("true"));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("validatorRef [" + this.validatorRef + "] found to be referencing to validator [" + validator + "]"));
                LOG.debug((Object)("injecting parameters [" + this.validatorParams + "] into validator [" + validator + "]"));
            }
            Iterator i = result.iterator();
            while (i.hasNext()) {
                ArrayList<Validator> validators = new ArrayList<Validator>();
                String overallPropertyName = (String)i.next();
                if (validator instanceof FieldValidator) {
                    ((FieldValidator)validator).setFieldName(overallPropertyName);
                }
                validators.add(validator);
                ActionValidatorManagerFactory.getInstance().validate(object, validators, this.getValidatorContext());
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("valued obtained from field name [" + this.getFieldName() + "] is null, skiping this validator"));
        }
    }

    protected void populateValue(Object obj, CloneableIterator iterator, List result, String overallPropertyName) throws OgnlException, CloneNotSupportedException {
        if (iterator.hasNext()) {
            String expression = (String)iterator.next();
            overallPropertyName = overallPropertyName.trim().length() <= 0 ? overallPropertyName + expression : overallPropertyName + "." + expression;
            Object val = OgnlUtil.getValue(expression, Collections.EMPTY_MAP, obj);
            if (val instanceof Collection) {
                if (!iterator.hasNext()) {
                    throw new XworkException("collection property [" + this.property + "] ends with a collection, it should end with an object not collection");
                }
                int a = 0;
                Iterator i = ((Collection)val).iterator();
                while (i.hasNext()) {
                    CloneableIterator ii = (CloneableIterator)iterator.clone();
                    if (overallPropertyName.endsWith("]")) {
                        int index = overallPropertyName.lastIndexOf("[");
                        overallPropertyName = overallPropertyName.substring(0, index);
                    }
                    overallPropertyName = overallPropertyName + "[" + a + "]";
                    this.populateValue(i.next(), ii, result, overallPropertyName);
                    ++a;
                }
            } else if (!iterator.hasNext()) {
                result.add(overallPropertyName);
            } else {
                this.populateValue(val, iterator, result, overallPropertyName);
            }
        }
    }

    protected class CloneableIterator
    implements Iterator,
    Cloneable {
        private List delegate;
        private ListIterator delegateIterator;
        public int index = -1;

        public CloneableIterator(List list) {
            this.delegate = list;
            this.delegateIterator = list.listIterator();
        }

        private CloneableIterator(List list, int index) {
            this.delegate = list;
            this.index = index;
            this.delegateIterator = list.listIterator(index + 1);
        }

        public boolean hasNext() {
            return this.delegateIterator.hasNext();
        }

        public Object next() {
            ++this.index;
            return this.delegateIterator.next();
        }

        public void remove() {
            throw new UnsupportedOperationException("remove() is not supported");
        }

        protected Object clone() throws CloneNotSupportedException {
            return new CloneableIterator(this.delegate, this.index);
        }
    }

    protected class PropertySpliter {
        private String properties;

        public PropertySpliter(String properties) {
            this.properties = properties;
        }

        CloneableIterator iterator() {
            ArrayList<String> propertyList = new ArrayList<String>();
            int tmpPrevIndex = 0;
            int tmpIndex = this.properties.indexOf(".", 0);
            while (tmpIndex > 0) {
                String property = this.properties.substring(tmpPrevIndex, tmpIndex);
                propertyList.add(property);
                tmpPrevIndex = tmpIndex + 1;
                tmpIndex = this.properties.indexOf(".", tmpIndex + 1);
            }
            propertyList.add(this.properties.substring(tmpPrevIndex));
            return new CloneableIterator(propertyList);
        }
    }
}

