/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2;

import com.opensymphony.xwork2.ActionChainResult;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.NonCloningContinuableObject;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.UnknownHandler;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.InterceptorMapping;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.interceptor.PreResultListener;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.ValueStackFactory;
import com.opensymphony.xwork2.util.profiling.UtilTimerStack;
import com.uwyn.rife.continuations.ContinuableObject;
import com.uwyn.rife.continuations.ContinuationConfig;
import com.uwyn.rife.continuations.ContinuationContext;
import com.uwyn.rife.continuations.ContinuationManager;
import com.uwyn.rife.continuations.exceptions.PauseException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultActionInvocation
implements ActionInvocation {
    private static final long serialVersionUID = -585293628862447329L;
    public static ContinuationHandler continuationHandler;
    private static final Log LOG;
    protected Object action;
    protected ActionProxy proxy;
    protected List preResultListeners;
    protected Map extraContext;
    protected ActionContext invocationContext;
    protected Iterator interceptors;
    protected ValueStack stack;
    protected Result result;
    protected String resultCode;
    protected boolean executed = false;
    protected boolean pushAction = true;
    protected ObjectFactory objectFactory;
    protected UnknownHandler unknownHandler;
    static /* synthetic */ Class class$com$opensymphony$xwork2$DefaultActionInvocation;

    protected DefaultActionInvocation(ObjectFactory objectFactory, UnknownHandler handler, ActionProxy proxy, Map extraContext) throws Exception {
        this(objectFactory, handler, proxy, extraContext, true);
    }

    protected DefaultActionInvocation(final ObjectFactory objectFactory, final UnknownHandler handler, final ActionProxy proxy, final Map extraContext, final boolean pushAction) throws Exception {
        UtilTimerStack.profile("create DefaultActionInvocation: ", new UtilTimerStack.ProfilingBlock<Object>(){

            @Override
            public Object doProfiling() throws Exception {
                DefaultActionInvocation.this.proxy = proxy;
                DefaultActionInvocation.this.objectFactory = objectFactory;
                DefaultActionInvocation.this.extraContext = extraContext;
                DefaultActionInvocation.this.pushAction = pushAction;
                DefaultActionInvocation.this.unknownHandler = handler;
                DefaultActionInvocation.this.init();
                return null;
            }
        });
    }

    public Object getAction() {
        return this.action;
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public ActionContext getInvocationContext() {
        return this.invocationContext;
    }

    public ActionProxy getProxy() {
        return this.proxy;
    }

    public Result getResult() throws Exception {
        Result proxyResult;
        ActionProxy aProxy;
        Result returnResult = this.result;
        while (returnResult instanceof ActionChainResult && (aProxy = ((ActionChainResult)returnResult).getProxy()) != null && (proxyResult = aProxy.getInvocation().getResult()) != null && aProxy.getExecuteResult()) {
            returnResult = proxyResult;
        }
        return returnResult;
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(String resultCode) {
        if (this.isExecuted()) {
            throw new IllegalStateException("Result has already been executed.");
        }
        this.resultCode = resultCode;
    }

    public ValueStack getStack() {
        return this.stack;
    }

    public void addPreResultListener(PreResultListener listener) {
        if (this.preResultListeners == null) {
            this.preResultListeners = new ArrayList(1);
        }
        this.preResultListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result createResult() throws Exception {
        if (this.result != null) {
            return this.result;
        }
        ActionConfig config = this.proxy.getConfig();
        Map<String, ResultConfig> results = config.getResults();
        ResultConfig resultConfig = null;
        ActionConfig actionConfig = config;
        synchronized (actionConfig) {
            try {
                resultConfig = results.get(this.resultCode);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            if (resultConfig == null) {
                resultConfig = results.get("*");
            }
        }
        if (resultConfig != null) {
            try {
                Result result = this.objectFactory.buildResult(resultConfig, this.invocationContext.getContextMap());
                return result;
            }
            catch (Exception e) {
                LOG.error((Object)("There was an exception while instantiating the result of type " + resultConfig.getClassName()), (Throwable)e);
                throw new XWorkException(e, (Object)resultConfig);
            }
        }
        if (this.resultCode != null && !"none".equals(this.resultCode)) {
            return this.unknownHandler.handleUnknownResult(this.invocationContext, this.proxy.getActionName(), this.proxy.getConfig(), this.resultCode);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String invoke() throws Exception {
        String profileKey = "invoke: ";
        try {
            UtilTimerStack.push(profileKey);
            if (this.executed) {
                throw new IllegalStateException("Action has already executed");
            }
            if (this.interceptors.hasNext()) {
                final InterceptorMapping interceptor = (InterceptorMapping)this.interceptors.next();
                UtilTimerStack.profile("interceptor: " + interceptor.getName(), new UtilTimerStack.ProfilingBlock<String>(){

                    @Override
                    public String doProfiling() throws Exception {
                        DefaultActionInvocation.this.resultCode = interceptor.getInterceptor().intercept(DefaultActionInvocation.this);
                        return null;
                    }
                });
            } else {
                this.resultCode = this.invokeActionOnly();
            }
            if (!this.executed) {
                if (this.preResultListeners != null) {
                    Iterator iterator = this.preResultListeners.iterator();
                    while (iterator.hasNext()) {
                        PreResultListener listener = (PreResultListener)iterator.next();
                        String _profileKey = "preResultListener: ";
                        try {
                            UtilTimerStack.push(_profileKey);
                            listener.beforeResult(this, this.resultCode);
                        }
                        finally {
                            UtilTimerStack.pop(_profileKey);
                        }
                    }
                }
                if (this.proxy.getExecuteResult()) {
                    this.executeResult();
                }
                this.executed = true;
            }
            String string = this.resultCode;
            return string;
        }
        finally {
            UtilTimerStack.pop(profileKey);
        }
    }

    public String invokeActionOnly() throws Exception {
        return this.invokeAction(this.getAction(), this.proxy.getConfig());
    }

    protected void createAction(Map contextMap) {
        String timerKey = "actionCreate: " + this.proxy.getActionName();
        try {
            UtilTimerStack.push(timerKey);
            this.action = this.objectFactory.buildAction(this.proxy.getActionName(), this.proxy.getNamespace(), this.proxy.getConfig(), contextMap);
        }
        catch (InstantiationException e) {
            throw new XWorkException("Unable to intantiate Action!", e, this.proxy.getConfig());
        }
        catch (IllegalAccessException e) {
            throw new XWorkException("Illegal access to constructor, is it public?", e, this.proxy.getConfig());
        }
        catch (Exception e) {
            String gripe = "";
            gripe = this.proxy == null ? "Whoa!  No ActionProxy instance found in current ActionInvocation.  This is bad ... very bad" : (this.proxy.getConfig() == null ? "Sheesh.  Where'd that ActionProxy get to?  I can't find it in the current ActionInvocation!?" : (this.proxy.getConfig().getClassName() == null ? "No Action defined for '" + this.proxy.getActionName() + "' in namespace '" + this.proxy.getNamespace() + "'" : "Unable to instantiate Action, " + this.proxy.getConfig().getClassName() + ",  defined for '" + this.proxy.getActionName() + "' in namespace '" + this.proxy.getNamespace() + "'"));
            gripe = gripe + (" -- " + e.getMessage() != null ? e.getMessage() : " [no message in exception]");
            throw new XWorkException(gripe, e, this.proxy.getConfig());
        }
        finally {
            UtilTimerStack.pop(timerKey);
        }
        if (continuationHandler != null) {
            continuationHandler.prepareContinuation(this.action, this.stack);
        }
    }

    protected Map createContextMap() {
        Map contextMap;
        if (this.extraContext != null && this.extraContext.containsKey("com.opensymphony.xwork2.util.ValueStack.ValueStack")) {
            this.stack = (ValueStack)this.extraContext.get("com.opensymphony.xwork2.util.ValueStack.ValueStack");
            if (this.stack == null) {
                throw new IllegalStateException("There was a null Stack set into the extra params.");
            }
            contextMap = this.stack.getContext();
        } else {
            this.stack = ValueStackFactory.getFactory().createValueStack();
            contextMap = this.stack.getContext();
        }
        if (this.extraContext != null) {
            contextMap.putAll(this.extraContext);
        }
        contextMap.put("com.opensymphony.xwork2.ActionContext.actionInvocation", this);
        return contextMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeResult() throws Exception {
        this.result = this.createResult();
        String timerKey = "executeResult: " + this.getResultCode();
        try {
            UtilTimerStack.push(timerKey);
            if (this.result != null) {
                this.result.execute(this);
            } else {
                if (this.resultCode != null && !"none".equals(this.resultCode)) {
                    throw new ConfigurationException("No result defined for action " + this.getAction().getClass().getName() + " and result " + this.getResultCode(), (Object)this.proxy.getConfig());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("No result returned for action " + this.getAction().getClass().getName() + " at " + this.proxy.getConfig().getLocation()));
                }
            }
        }
        finally {
            UtilTimerStack.pop(timerKey);
        }
    }

    private void init() throws Exception {
        Map contextMap = this.createContextMap();
        this.createAction(contextMap);
        if (this.pushAction) {
            this.stack.push(this.action);
        }
        this.invocationContext = new ActionContext(contextMap);
        this.invocationContext.setName(this.proxy.getActionName());
        ArrayList<InterceptorMapping> interceptorList = new ArrayList<InterceptorMapping>(this.proxy.getConfig().getInterceptors());
        this.interceptors = interceptorList.iterator();
    }

    protected String invokeAction(Object action, ActionConfig actionConfig) throws Exception {
        String methodName = this.proxy.getMethod();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Executing action method = " + actionConfig.getMethodName()));
        }
        String timerKey = "invokeAction: " + this.proxy.getActionName();
        try {
            UtilTimerStack.push(timerKey);
            Method method = this.getAction().getClass().getMethod(methodName, new Class[0]);
            Object methodResult = null;
            if (action instanceof Proxy) {
                try {
                    methodResult = Proxy.getInvocationHandler(action).invoke(action, method, new Object[0]);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    throw new Exception("Error invoking on proxy: " + throwable.getMessage());
                }
            } else {
                methodResult = method.invoke(action, new Object[0]);
            }
            if (methodResult instanceof Result) {
                this.result = (Result)methodResult;
                String throwable = null;
                return throwable;
            }
            String throwable = (String)methodResult;
            return throwable;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The " + methodName + "() is not defined in action " + this.getAction().getClass() + "");
        }
        catch (InvocationTargetException e) {
            String result;
            Throwable t = e.getTargetException();
            if (continuationHandler != null && (result = continuationHandler.handleException(t, this.getStack())) != null) {
                String string = result;
                return string;
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw e;
        }
        finally {
            UtilTimerStack.pop(timerKey);
        }
    }

    static {
        Class<?> clazz = class$com$opensymphony$xwork2$DefaultActionInvocation;
        if (clazz == null) {
            clazz = class$com$opensymphony$xwork2$DefaultActionInvocation = new DefaultActionInvocation[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    static class ContinuationHandler {
        ContinuationManager cm;

        public ContinuationHandler() {
            if (ContinuationConfig.getInstance() != null) {
                this.cm = new ContinuationManager();
            }
        }

        public void prepareContinuation(Object action, ValueStack stack) {
            if (action instanceof ContinuableObject) {
                ContinuationContext ctx = ContinuationContext.createInstance((ContinuableObject)((ContinuableObject)action));
                if (action instanceof NonCloningContinuableObject) {
                    ctx.setShouldClone(false);
                }
            }
            try {
                ContinuationContext context;
                String id = (String)stack.getContext().get("__continue");
                stack.getContext().remove("__continue");
                if (id != null && (context = this.cm.getContext(id)) != null) {
                    ContinuationContext.setContext((ContinuationContext)context);
                    ContinuableObject original = context.getContinuable();
                    action = original;
                }
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }

        public String handleException(Throwable t, ValueStack stack) {
            if (t instanceof PauseException) {
                PauseException pe = (PauseException)t;
                ContinuationContext context = pe.getContext();
                String result = (String)pe.getParameters();
                stack.getContext().put("__continue", context.getId());
                this.cm.addContext(context);
                return result;
            }
            return null;
        }
    }
}

