/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.config.entities;

import com.opensymphony.xwork2.config.entities.ExceptionMappingConfig;
import com.opensymphony.xwork2.config.entities.InterceptorListHolder;
import com.opensymphony.xwork2.config.entities.InterceptorMapping;
import com.opensymphony.xwork2.config.entities.Parameterizable;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.util.location.Located;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionConfig
extends Located
implements InterceptorListHolder,
Parameterizable,
Serializable {
    protected List<InterceptorMapping> interceptors;
    protected Map<String, Object> params;
    protected Map<String, ResultConfig> results;
    protected List<ExceptionMappingConfig> exceptionMappings;
    protected String className;
    protected String methodName;
    protected String packageName;

    public ActionConfig() {
        this.params = new LinkedHashMap<String, Object>();
        this.results = new LinkedHashMap<String, ResultConfig>();
        this.interceptors = new ArrayList<InterceptorMapping>();
        this.exceptionMappings = new ArrayList<ExceptionMappingConfig>();
    }

    public ActionConfig(String methodName, Class clazz, Map<String, Object> parameters, Map<String, ResultConfig> results, List<InterceptorMapping> interceptors) {
        this(methodName, clazz.getName(), parameters, results, interceptors);
    }

    public ActionConfig(String methodName, Class clazz, Map<String, Object> parameters, Map<String, ResultConfig> results, List<InterceptorMapping> interceptors, List<ExceptionMappingConfig> exceptionMappings) {
        this(methodName, clazz.getName(), parameters, results, interceptors, exceptionMappings);
    }

    public ActionConfig(String methodName, String className, Map<String, Object> parameters, Map<String, ResultConfig> results, List<InterceptorMapping> interceptors) {
        this(methodName, className, "", parameters, results, interceptors, Collections.EMPTY_LIST);
    }

    public ActionConfig(String methodName, String className, Map<String, Object> parameters, Map<String, ResultConfig> results, List<InterceptorMapping> interceptors, List<ExceptionMappingConfig> exceptionMappings) {
        this(methodName, className, "", parameters, results, interceptors, exceptionMappings);
    }

    public ActionConfig(String methodName, String className, String packageName, Map<String, Object> parameters, Map<String, ResultConfig> results, List<InterceptorMapping> interceptors) {
        this(methodName, className, packageName, parameters, results, interceptors, Collections.EMPTY_LIST);
    }

    public ActionConfig(String methodName, String className, String packageName, Map<String, Object> parameters, Map<String, ResultConfig> results, List<InterceptorMapping> interceptors, List<ExceptionMappingConfig> exceptionMappings) {
        this.methodName = methodName;
        this.interceptors = interceptors;
        this.params = parameters;
        this.results = results;
        this.className = className;
        this.exceptionMappings = exceptionMappings;
        this.packageName = packageName;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public List<ExceptionMappingConfig> getExceptionMappings() {
        return this.exceptionMappings;
    }

    public List<InterceptorMapping> getInterceptors() {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList<InterceptorMapping>();
        }
        return this.interceptors;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    @Override
    public Map<String, Object> getParams() {
        if (this.params == null) {
            this.params = new LinkedHashMap<String, Object>();
        }
        return this.params;
    }

    public void setResults(Map<String, ResultConfig> results) {
        this.results = results;
    }

    public Map<String, ResultConfig> getResults() {
        if (this.results == null) {
            this.results = new LinkedHashMap<String, ResultConfig>();
        }
        return this.results;
    }

    public void addExceptionMapping(ExceptionMappingConfig exceptionMapping) {
        this.getExceptionMappings().add(exceptionMapping);
    }

    public void addExceptionMappings(List<? extends ExceptionMappingConfig> mappings) {
        this.getExceptionMappings().addAll(mappings);
    }

    @Override
    public void addInterceptor(InterceptorMapping interceptor) {
        this.getInterceptors().add(interceptor);
    }

    @Override
    public void addInterceptors(List<InterceptorMapping> interceptors) {
        this.getInterceptors().addAll(interceptors);
    }

    @Override
    public void addParam(String name, Object value) {
        this.getParams().put(name, value);
    }

    public void addResultConfig(ResultConfig resultConfig) {
        this.getResults().put(resultConfig.getName(), resultConfig);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActionConfig)) {
            return false;
        }
        ActionConfig actionConfig = (ActionConfig)o;
        if (this.className != null ? !this.className.equals(actionConfig.className) : actionConfig.className != null) {
            return false;
        }
        if (this.interceptors != null ? !((Object)this.interceptors).equals(actionConfig.interceptors) : actionConfig.interceptors != null) {
            return false;
        }
        if (this.methodName != null ? !this.methodName.equals(actionConfig.methodName) : actionConfig.methodName != null) {
            return false;
        }
        if (this.params != null ? !((Object)this.params).equals(actionConfig.params) : actionConfig.params != null) {
            return false;
        }
        return !(this.results != null ? !((Object)this.results).equals(actionConfig.results) : actionConfig.results != null);
    }

    public int hashCode() {
        int result = this.interceptors != null ? ((Object)this.interceptors).hashCode() : 0;
        result = 29 * result + (this.params != null ? ((Object)this.params).hashCode() : 0);
        result = 29 * result + (this.results != null ? ((Object)this.results).hashCode() : 0);
        result = 29 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{ActionConfig ");
        sb.append(this.className);
        if (this.methodName != null) {
            sb.append(".").append(this.methodName).append("()");
        }
        sb.append(" - ").append(this.location);
        sb.append("}");
        return sb.toString();
    }
}

