/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.config.impl;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.ConfigurationProvider;
import com.opensymphony.xwork2.config.RuntimeConfiguration;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.ExceptionMappingConfig;
import com.opensymphony.xwork2.config.entities.InterceptorMapping;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.config.entities.ResultTypeConfig;
import com.opensymphony.xwork2.config.impl.ActionConfigMatcher;
import com.opensymphony.xwork2.config.impl.LocatableConstantFactory;
import com.opensymphony.xwork2.config.providers.InterceptorBuilder;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.ContainerBuilder;
import com.opensymphony.xwork2.inject.Context;
import com.opensymphony.xwork2.inject.Factory;
import com.opensymphony.xwork2.util.location.LocatableProperties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfiguration
implements Configuration {
    protected static final Log LOG;
    protected Map<String, PackageConfig> packageContexts = new LinkedHashMap<String, PackageConfig>();
    protected RuntimeConfiguration runtimeConfiguration;
    protected Container container;
    protected String defaultFrameworkBeanName;
    protected Set<String> loadedFileNames = new TreeSet<String>();
    ObjectFactory objectFactory;
    static /* synthetic */ Class class$com$opensymphony$xwork2$ObjectFactory;
    static /* synthetic */ Class class$com$opensymphony$xwork2$config$Configuration;
    static /* synthetic */ Class class$com$opensymphony$xwork2$config$impl$DefaultConfiguration;

    public DefaultConfiguration() {
        this("xwork");
    }

    public DefaultConfiguration(String defaultBeanName) {
        this.defaultFrameworkBeanName = defaultBeanName;
    }

    @Override
    public PackageConfig getPackageConfig(String name) {
        return this.packageContexts.get(name);
    }

    @Override
    public Set getPackageConfigNames() {
        return this.packageContexts.keySet();
    }

    @Override
    public Map getPackageConfigs() {
        return this.packageContexts;
    }

    @Override
    public Set<String> getLoadedFileNames() {
        return this.loadedFileNames;
    }

    @Override
    public RuntimeConfiguration getRuntimeConfiguration() {
        return this.runtimeConfiguration;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void addPackageConfig(String name, PackageConfig packageContext) {
        PackageConfig check = this.packageContexts.get(name);
        if (check != null) {
            if (check.getLocation() != null && packageContext.getLocation() != null && check.getLocation().equals(packageContext.getLocation())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)new StringBuffer().append("The package name '").append(name).append("' is already been loaded by the same location and could be removed: ").append(packageContext.getLocation()).toString());
                }
            } else {
                throw new ConfigurationException(new StringBuffer().append("The package name '").append(name).append("' at location ").append(packageContext.getLocation()).append(" is already been used by another package at location ").append(check.getLocation()).toString(), (Object)packageContext);
            }
        }
        this.packageContexts.put(name, packageContext);
    }

    @Override
    public void destroy() {
        this.packageContexts.clear();
        this.loadedFileNames.clear();
    }

    @Override
    public void rebuildRuntimeConfiguration() {
        this.runtimeConfiguration = this.buildRuntimeConfiguration();
    }

    @Override
    public synchronized void reload(List<ConfigurationProvider> providers) throws ConfigurationException {
        this.packageContexts.clear();
        this.loadedFileNames.clear();
        ContainerProperties props = new ContainerProperties();
        ContainerBuilder builder = new ContainerBuilder();
        for (ConfigurationProvider configurationProvider : providers) {
            configurationProvider.init(this);
            configurationProvider.register(builder, props);
        }
        props.setConstants(builder);
        Class<?> clazz = class$com$opensymphony$xwork2$config$Configuration;
        if (clazz == null) {
            clazz = class$com$opensymphony$xwork2$config$Configuration = new Configuration[0].getClass().getComponentType();
        }
        builder.factory(clazz, new Factory<Configuration>(){

            @Override
            public Configuration create(Context context) throws Exception {
                return DefaultConfiguration.this;
            }
        });
        this.container = builder.create(false);
        Class<?> clazz2 = class$com$opensymphony$xwork2$ObjectFactory;
        if (clazz2 == null) {
            clazz2 = class$com$opensymphony$xwork2$ObjectFactory = new ObjectFactory[0].getClass().getComponentType();
        }
        this.objectFactory = (ObjectFactory)this.container.getInstance(clazz2);
        for (ConfigurationProvider configurationProvider : providers) {
            this.container.inject(configurationProvider);
            configurationProvider.loadPackages();
        }
        this.rebuildRuntimeConfiguration();
    }

    @Override
    public void removePackageConfig(String name) {
        PackageConfig toBeRemoved = this.packageContexts.get(name);
        if (toBeRemoved != null) {
            for (PackageConfig packageConfig : this.packageContexts.values()) {
                packageConfig.removeParent(toBeRemoved);
            }
        }
    }

    protected synchronized RuntimeConfiguration buildRuntimeConfiguration() throws ConfigurationException {
        LinkedHashMap<String, Map<String, ActionConfig>> namespaceActionConfigs = new LinkedHashMap<String, Map<String, ActionConfig>>();
        LinkedHashMap<String, String> namespaceConfigs = new LinkedHashMap<String, String>();
        for (PackageConfig packageConfig : this.packageContexts.values()) {
            if (packageConfig.isAbstract()) continue;
            String namespace = packageConfig.getNamespace();
            LinkedHashMap<String, ActionConfig> configs = (LinkedHashMap<String, ActionConfig>)namespaceActionConfigs.get(namespace);
            if (configs == null) {
                configs = new LinkedHashMap<String, ActionConfig>();
            }
            Map<String, ActionConfig> actionConfigs = packageConfig.getAllActionConfigs();
            Iterator<String> i$ = actionConfigs.keySet().iterator();
            while (i$.hasNext()) {
                String o;
                String actionName = o = i$.next();
                ActionConfig baseConfig = actionConfigs.get(actionName);
                configs.put(actionName, this.buildFullActionConfig(packageConfig, baseConfig));
            }
            namespaceActionConfigs.put(namespace, configs);
            if (packageConfig.getFullDefaultActionRef() == null) continue;
            namespaceConfigs.put(namespace, packageConfig.getFullDefaultActionRef());
        }
        return new RuntimeConfigurationImpl(namespaceActionConfigs, namespaceConfigs);
    }

    private void setDefaultResults(Map<String, ResultConfig> results, PackageConfig packageContext) {
        String defaultResult = packageContext.getFullDefaultResultType();
        for (Map.Entry<String, ResultConfig> entry : results.entrySet()) {
            if (entry.getValue() != null) continue;
            ResultTypeConfig resultTypeConfig = packageContext.getAllResultTypeConfigs().get(defaultResult);
            entry.setValue(new ResultConfig(null, resultTypeConfig.getClazz()));
        }
    }

    private ActionConfig buildFullActionConfig(PackageConfig packageContext, ActionConfig baseConfig) throws ConfigurationException {
        String defaultInterceptorRefName;
        TreeMap<String, Object> params = new TreeMap<String, Object>(baseConfig.getParams());
        TreeMap<String, ResultConfig> results = new TreeMap<String, ResultConfig>(packageContext.getAllGlobalResults());
        if (baseConfig.getPackageName().equals(packageContext.getName())) {
            results = new TreeMap<String, ResultConfig>(packageContext.getAllGlobalResults());
            results.putAll(baseConfig.getResults());
        } else {
            PackageConfig baseConfigPackageConfig = this.packageContexts.get(baseConfig.getPackageName());
            if (baseConfigPackageConfig != null) {
                results = new TreeMap<String, ResultConfig>(baseConfigPackageConfig.getAllGlobalResults());
            }
            results.putAll(baseConfig.getResults());
        }
        this.setDefaultResults(results, packageContext);
        ArrayList<InterceptorMapping> interceptors = new ArrayList<InterceptorMapping>(baseConfig.getInterceptors());
        if (interceptors.size() <= 0 && (defaultInterceptorRefName = packageContext.getFullDefaultInterceptorRef()) != null) {
            interceptors.addAll(InterceptorBuilder.constructInterceptorReference(packageContext, defaultInterceptorRefName, new LinkedHashMap(), packageContext.getLocation(), this.objectFactory));
        }
        List<ExceptionMappingConfig> exceptionMappings = baseConfig.getExceptionMappings();
        exceptionMappings.addAll(packageContext.getAllExceptionMappingConfigs());
        ActionConfig config = new ActionConfig(baseConfig.getMethodName(), baseConfig.getClassName(), packageContext.getName(), params, results, interceptors, exceptionMappings);
        config.setLocation(baseConfig.getLocation());
        return config;
    }

    static {
        Class<?> clazz = class$com$opensymphony$xwork2$config$impl$DefaultConfiguration;
        if (clazz == null) {
            clazz = class$com$opensymphony$xwork2$config$impl$DefaultConfiguration = new DefaultConfiguration[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    class ContainerProperties
    extends LocatableProperties {
        private static final long serialVersionUID = -7320625750836896089L;
        static /* synthetic */ Class class$java$lang$String;

        ContainerProperties() {
        }

        public Object setProperty(String key, String value) {
            String oldValue = this.getProperty(key);
            if (oldValue != null && !oldValue.equals(value) && !DefaultConfiguration.this.defaultFrameworkBeanName.equals(oldValue)) {
                LOG.info((Object)("Overriding property " + key + " - old value: " + oldValue + " new value: " + value));
            }
            return super.setProperty(key, value);
        }

        public void setConstants(ContainerBuilder builder) {
            Iterator<Object> i$ = this.keySet().iterator();
            while (i$.hasNext()) {
                Object keyobj = i$.next();
                String key = (String)keyobj;
                Class<?> clazz = class$java$lang$String;
                if (clazz == null) {
                    clazz = new String[0].getClass().getComponentType();
                }
                builder.factory(clazz, key, new LocatableConstantFactory<String>(this.getProperty(key), this.getPropertyLocation(key)));
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RuntimeConfigurationImpl
    implements RuntimeConfiguration {
        private Map<String, Map<String, ActionConfig>> namespaceActionConfigs;
        private Map<String, ActionConfigMatcher> namespaceActionConfigMatchers;
        private Map<String, String> namespaceConfigs;

        public RuntimeConfigurationImpl(Map<String, Map<String, ActionConfig>> namespaceActionConfigs, Map<String, String> namespaceConfigs) {
            this.namespaceActionConfigs = namespaceActionConfigs;
            this.namespaceConfigs = namespaceConfigs;
            this.namespaceActionConfigMatchers = new LinkedHashMap<String, ActionConfigMatcher>();
            for (String ns : namespaceActionConfigs.keySet()) {
                this.namespaceActionConfigMatchers.put(ns, new ActionConfigMatcher(namespaceActionConfigs.get(ns), true));
            }
        }

        @Override
        public synchronized ActionConfig getActionConfig(String namespace, String name) {
            String defaultActionRef;
            ActionConfig config = null;
            Map<String, ActionConfig> actions = this.namespaceActionConfigs.get(namespace == null ? "" : namespace);
            if (actions != null && (config = actions.get(name)) == null && (config = this.namespaceActionConfigMatchers.get(namespace).match(name)) == null && (defaultActionRef = this.namespaceConfigs.get(namespace == null ? "" : namespace)) != null) {
                config = actions.get(defaultActionRef);
            }
            if (config == null && namespace != null && !namespace.trim().equals("") && (actions = this.namespaceActionConfigs.get("")) != null && (config = actions.get(name)) == null && (config = this.namespaceActionConfigMatchers.get("").match(name)) == null && (defaultActionRef = this.namespaceConfigs.get("")) != null) {
                config = actions.get(defaultActionRef);
            }
            return config;
        }

        @Override
        public synchronized Map getActionConfigs() {
            return this.namespaceActionConfigs;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer("RuntimeConfiguration - actions are\n");
            for (String namespace : this.namespaceActionConfigs.keySet()) {
                Map<String, ActionConfig> actionConfigs = this.namespaceActionConfigs.get(namespace);
                for (String s : actionConfigs.keySet()) {
                    buff.append(namespace).append("/").append(s).append("\n");
                }
            }
            return buff.toString();
        }
    }
}

