/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.config.providers;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.InterceptorConfig;
import com.opensymphony.xwork2.config.entities.InterceptorMapping;
import com.opensymphony.xwork2.config.entities.InterceptorStackConfig;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.interceptor.Interceptor;
import com.opensymphony.xwork2.util.location.Location;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorBuilder {
    private static final Log LOG;
    static /* synthetic */ Class class$com$opensymphony$xwork2$config$providers$InterceptorBuilder;

    public static List<InterceptorMapping> constructInterceptorReference(PackageConfig packageConfig, String refName, Map refParams, Location location, ObjectFactory objectFactory) throws ConfigurationException {
        Object referencedConfig = packageConfig.getAllInterceptorConfigs().get(refName);
        List<InterceptorMapping> result = new ArrayList<InterceptorMapping>();
        if (referencedConfig == null) {
            throw new ConfigurationException(new StringBuffer().append("Unable to find interceptor class referenced by ref-name ").append(refName).toString(), (Object)location);
        }
        if (referencedConfig instanceof InterceptorConfig) {
            InterceptorConfig config = (InterceptorConfig)referencedConfig;
            Interceptor inter = null;
            try {
                inter = objectFactory.buildInterceptor(config, refParams);
                result.add(new InterceptorMapping(refName, inter));
            }
            catch (ConfigurationException ex) {
                LOG.warn((Object)new StringBuffer().append("Unable to load config class ").append(config.getClassName()).append(" at ").append(ex.getLocation()).append(" probably due to a missing jar, which might ").append("be fine if you never plan to use the ").append(config.getName()).append(" interceptor").toString());
                LOG.error((Object)"Actual exception", (Throwable)ex);
            }
        } else if (referencedConfig instanceof InterceptorStackConfig) {
            InterceptorStackConfig stackConfig = (InterceptorStackConfig)referencedConfig;
            if (refParams != null && refParams.size() > 0) {
                result = InterceptorBuilder.constructParameterizedInterceptorReferences(packageConfig, stackConfig, refParams, objectFactory);
            } else {
                result.addAll(stackConfig.getInterceptors());
            }
        } else {
            LOG.error((Object)new StringBuffer().append("Got unexpected type for interceptor ").append(refName).append(". Got ").append(referencedConfig).toString());
        }
        return result;
    }

    private static List<InterceptorMapping> constructParameterizedInterceptorReferences(PackageConfig packageConfig, InterceptorStackConfig stackConfig, Map refParams, ObjectFactory objectFactory) {
        HashMap params = new HashMap();
        for (String key : refParams.keySet()) {
            String value = (String)refParams.get(key);
            try {
                String name = key.substring(0, key.indexOf(46));
                key = key.substring(key.indexOf(46) + 1);
                Map map = params.containsKey(name) ? (Map)params.get(name) : new HashMap();
                map.put(key, value);
                params.put(name, map);
            }
            catch (Exception e) {
                LOG.warn((Object)new StringBuffer().append("No interceptor found for name = ").append(key).toString());
            }
        }
        ArrayList<InterceptorMapping> result = new ArrayList<InterceptorMapping>(stackConfig.getInterceptors());
        for (String key : params.keySet()) {
            Map map = (Map)params.get(key);
            InterceptorConfig cfg = (InterceptorConfig)packageConfig.getAllInterceptorConfigs().get(key);
            Interceptor interceptor = objectFactory.buildInterceptor(cfg, map);
            InterceptorMapping mapping = new InterceptorMapping(key, interceptor);
            if (result != null && result.contains(mapping)) {
                int index = result.indexOf(mapping);
                result.set(index, mapping);
                continue;
            }
            result.add(mapping);
        }
        return result;
    }

    static {
        Class<?> clazz = class$com$opensymphony$xwork2$config$providers$InterceptorBuilder;
        if (clazz == null) {
            clazz = class$com$opensymphony$xwork2$config$providers$InterceptorBuilder = new InterceptorBuilder[0].getClass().getComponentType();
        }
        LOG = LogFactory.getLog((Class)clazz);
    }
}

