/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.inject;

import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.ContainerImpl;
import com.opensymphony.xwork2.inject.DependencyException;
import com.opensymphony.xwork2.inject.ExternalContext;
import com.opensymphony.xwork2.inject.Factory;
import com.opensymphony.xwork2.inject.InternalContext;
import com.opensymphony.xwork2.inject.InternalFactory;
import com.opensymphony.xwork2.inject.Key;
import com.opensymphony.xwork2.inject.Scope;
import com.opensymphony.xwork2.inject.Scoped;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.retrotranslator.runtime.java.lang.Enum_;
import net.sf.retrotranslator.runtime.java.lang._Character;
import net.sf.retrotranslator.runtime.java.lang._Class;
import net.sf.retrotranslator.runtime.java.lang._Double;
import net.sf.retrotranslator.runtime.java.lang._Float;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import net.sf.retrotranslator.runtime.java.lang._Long;
import net.sf.retrotranslator.runtime.java.lang._Short;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContainerBuilder {
    final Map<Key<?>, InternalFactory<?>> factories = new HashMap();
    final List<InternalFactory<?>> singletonFactories = new ArrayList();
    final List<Class<?>> staticInjections = new ArrayList();
    boolean created;
    private static final InternalFactory<Container> CONTAINER_FACTORY = new InternalFactory<Container>(){

        @Override
        public Container create(InternalContext context) {
            return context.getContainer();
        }
    };
    private static final InternalFactory<Logger> LOGGER_FACTORY = new InternalFactory<Logger>(){

        @Override
        public Logger create(InternalContext context) {
            Member member = context.getExternalContext().getMember();
            return member == null ? Logger.getAnonymousLogger() : Logger.getLogger(member.getDeclaringClass().getName());
        }
    };
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$opensymphony$xwork2$inject$Scoped;
    static /* synthetic */ Class class$java$util$logging$Logger;
    static /* synthetic */ Class class$com$opensymphony$xwork2$inject$Container;

    public ContainerBuilder() {
        Class<?> clazz = class$com$opensymphony$xwork2$inject$Container;
        if (clazz == null) {
            clazz = class$com$opensymphony$xwork2$inject$Container = new Container[0].getClass().getComponentType();
        }
        this.factories.put(Key.newInstance(clazz, "default"), CONTAINER_FACTORY);
        Class<?> clazz2 = class$java$util$logging$Logger;
        if (clazz2 == null) {
            clazz2 = class$java$util$logging$Logger = new Logger[0].getClass().getComponentType();
        }
        this.factories.put(Key.newInstance(clazz2, "default"), LOGGER_FACTORY);
    }

    private <T> ContainerBuilder factory(final Key<T> key, InternalFactory<? extends T> factory, Scope scope) {
        this.ensureNotCreated();
        this.checkKey(key);
        final InternalFactory<? extends T> scopedFactory = scope.scopeFactory(key.getType(), key.getName(), factory);
        this.factories.put(key, scopedFactory);
        if (scope == Scope.SINGLETON) {
            this.singletonFactories.add(new InternalFactory<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T create(InternalContext context) {
                    try {
                        context.setExternalContext(ExternalContext.newInstance(null, key, context.getContainerImpl()));
                        Object t = scopedFactory.create(context);
                        return t;
                    }
                    finally {
                        context.setExternalContext(null);
                    }
                }
            });
        }
        return this;
    }

    private void checkKey(Key<?> key) {
        if (this.factories.containsKey(key)) {
            throw new DependencyException(new StringBuffer().append("Dependency mapping for ").append(key).append(" already exists.").toString());
        }
    }

    public <T> ContainerBuilder factory(final Class<T> type, final String name, final Factory<? extends T> factory, Scope scope) {
        InternalFactory internalFactory = new InternalFactory<T>(){

            @Override
            public T create(InternalContext context) {
                try {
                    ExternalContext externalContext = context.getExternalContext();
                    return factory.create(externalContext);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public String toString() {
                return new LinkedHashMap<String, Object>(){
                    {
                        this.put("type", type);
                        this.put("name", name);
                        this.put("factory", factory);
                    }
                }.toString();
            }
        };
        return this.factory(Key.newInstance(type, name), internalFactory, scope);
    }

    public <T> ContainerBuilder factory(Class<T> type, Factory<? extends T> factory, Scope scope) {
        return this.factory(type, "default", factory, scope);
    }

    public <T> ContainerBuilder factory(Class<T> type, String name, Factory<? extends T> factory) {
        return this.factory(type, name, factory, Scope.DEFAULT);
    }

    public <T> ContainerBuilder factory(Class<T> type, Factory<? extends T> factory) {
        return this.factory(type, "default", factory, Scope.DEFAULT);
    }

    public <T> ContainerBuilder factory(final Class<T> type, final String name, final Class<? extends T> implementation, final Scope scope) {
        InternalFactory factory = new InternalFactory<T>(){
            volatile ContainerImpl.ConstructorInjector<? extends T> constructor;

            @Override
            public T create(InternalContext context) {
                if (this.constructor == null) {
                    this.constructor = context.getContainerImpl().getConstructor(implementation);
                }
                return this.constructor.construct(context, type);
            }

            public String toString() {
                return new LinkedHashMap<String, Object>(){
                    {
                        this.put("type", type);
                        this.put("name", name);
                        this.put("implementation", implementation);
                        this.put("scope", scope);
                    }
                }.toString();
            }
        };
        return this.factory(Key.newInstance(type, name), factory, scope);
    }

    public <T> ContainerBuilder factory(Class<T> type, String name, Class<? extends T> implementation) {
        Scoped scoped;
        Class<?> clazz = class$com$opensymphony$xwork2$inject$Scoped;
        if (clazz == null) {
            clazz = class$com$opensymphony$xwork2$inject$Scoped = new Scoped[0].getClass().getComponentType();
        }
        Scope scope = (scoped = (Scoped)_Class.getAnnotation(implementation, (Class)clazz)) == null ? Scope.DEFAULT : scoped.value();
        return this.factory(type, name, implementation, scope);
    }

    public <T> ContainerBuilder factory(Class<T> type, Class<? extends T> implementation) {
        return this.factory(type, "default", implementation);
    }

    public <T> ContainerBuilder factory(Class<T> type) {
        return this.factory(type, "default", type);
    }

    public <T> ContainerBuilder factory(Class<T> type, String name) {
        return this.factory(type, name, type);
    }

    public <T> ContainerBuilder factory(Class<T> type, Class<? extends T> implementation, Scope scope) {
        return this.factory(type, "default", implementation, scope);
    }

    public <T> ContainerBuilder factory(Class<T> type, Scope scope) {
        return this.factory(type, "default", type, scope);
    }

    public <T> ContainerBuilder factory(Class<T> type, String name, Scope scope) {
        return this.factory(type, name, type, scope);
    }

    public <T> ContainerBuilder alias(Class<T> type, String alias) {
        return this.alias(type, "default", alias);
    }

    public <T> ContainerBuilder alias(Class<T> type, String name, String alias) {
        return this.alias(Key.newInstance(type, name), Key.newInstance(type, alias));
    }

    private <T> ContainerBuilder alias(Key<T> key, Key<T> aliasKey) {
        this.ensureNotCreated();
        this.checkKey(aliasKey);
        InternalFactory<?> scopedFactory = this.factories.get(key);
        if (scopedFactory == null) {
            throw new DependencyException(new StringBuffer().append("Dependency mapping for ").append(key).append(" doesn't exists.").toString());
        }
        this.factories.put(aliasKey, scopedFactory);
        return this;
    }

    public ContainerBuilder constant(String name, String value) {
        Class<?> clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        return this.constant(clazz, name, value);
    }

    public ContainerBuilder constant(String name, int value) {
        return this.constant(Integer.TYPE, name, _Integer.valueOf((int)value));
    }

    public ContainerBuilder constant(String name, long value) {
        return this.constant(Long.TYPE, name, _Long.valueOf((long)value));
    }

    public ContainerBuilder constant(String name, boolean value) {
        return this.constant(Boolean.TYPE, name, value);
    }

    public ContainerBuilder constant(String name, double value) {
        return this.constant(Double.TYPE, name, _Double.valueOf((double)value));
    }

    public ContainerBuilder constant(String name, float value) {
        return this.constant(Float.TYPE, name, _Float.valueOf((float)value));
    }

    public ContainerBuilder constant(String name, short value) {
        return this.constant(Short.TYPE, name, _Short.valueOf((short)value));
    }

    public ContainerBuilder constant(String name, char value) {
        return this.constant(Character.TYPE, name, _Character.valueOf((char)value));
    }

    public ContainerBuilder constant(String name, Class value) {
        Class<?> clazz = class$java$lang$Class;
        if (clazz == null) {
            clazz = class$java$lang$Class = new Class[0].getClass().getComponentType();
        }
        return this.constant(clazz, name, value);
    }

    public <E extends Enum_<E>> ContainerBuilder constant(String name, E value) {
        return this.constant(value.getDeclaringClass(), name, value);
    }

    private <T> ContainerBuilder constant(final Class<T> type, final String name, final T value) {
        InternalFactory factory = new InternalFactory<T>(){

            @Override
            public T create(InternalContext ignored) {
                return value;
            }

            public String toString() {
                return new LinkedHashMap<String, Object>(){
                    {
                        this.put("type", type);
                        this.put("name", name);
                        this.put("value", value);
                    }
                }.toString();
            }
        };
        return this.factory(Key.newInstance(type, name), factory, Scope.DEFAULT);
    }

    public ContainerBuilder injectStatics(Class<?> ... types) {
        this.staticInjections.addAll(Arrays.asList(types));
        return this;
    }

    public boolean contains(Class<?> type, String name) {
        return this.factories.containsKey(Key.newInstance(type, name));
    }

    public boolean contains(Class<?> type) {
        return this.contains(type, "default");
    }

    public Container create(boolean loadSingletons) {
        this.ensureNotCreated();
        this.created = true;
        ContainerImpl container = new ContainerImpl(new HashMap(this.factories));
        if (loadSingletons) {
            container.callInContext(new ContainerImpl.ContextualCallable<Void>(){

                @Override
                public Void call(InternalContext context) {
                    for (InternalFactory<?> factory : ContainerBuilder.this.singletonFactories) {
                        factory.create(context);
                    }
                    return null;
                }
            });
        }
        container.injectStatics(this.staticInjections);
        return container;
    }

    private void ensureNotCreated() {
        if (this.created) {
            throw new IllegalStateException("Container already created.");
        }
    }

    public static interface Command {
        public void build(ContainerBuilder var1);
    }
}

