/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.inject;

import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.InternalContext;
import com.opensymphony.xwork2.inject.InternalFactory;
import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import net.sf.retrotranslator.runtime.java.lang.Enum_;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Scope
extends Enum_<Scope> {
    public static final /* enum */ Scope DEFAULT = new Scope("DEFAULT", 0){

        @Override
        <T> InternalFactory<? extends T> scopeFactory(Class<T> type, String name, InternalFactory<? extends T> factory) {
            return factory;
        }
    };
    public static final /* enum */ Scope SINGLETON = new Scope("SINGLETON", 1){

        @Override
        <T> InternalFactory<? extends T> scopeFactory(Class<T> type, String name, final InternalFactory<? extends T> factory) {
            return new InternalFactory<T>(){
                T instance;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T create(InternalContext context) {
                    Container container = context.getContainer();
                    synchronized (container) {
                        if (this.instance == null) {
                            this.instance = factory.create(context);
                        }
                        return this.instance;
                    }
                }

                public String toString() {
                    return factory.toString();
                }
            };
        }
    };
    public static final /* enum */ Scope THREAD = new Scope("THREAD", 2){

        @Override
        <T> InternalFactory<? extends T> scopeFactory(Class<T> type, String name, final InternalFactory<? extends T> factory) {
            return new InternalFactory<T>(){
                final ThreadLocal<T> threadLocal = new ThreadLocal();

                @Override
                public T create(InternalContext context) {
                    Object t = this.threadLocal.get();
                    if (t == null) {
                        t = factory.create(context);
                        this.threadLocal.set(t);
                    }
                    return t;
                }

                public String toString() {
                    return factory.toString();
                }
            };
        }
    };
    public static final /* enum */ Scope REQUEST = new Scope("REQUEST", 3){

        @Override
        <T> InternalFactory<? extends T> scopeFactory(final Class<T> type, final String name, final InternalFactory<? extends T> factory) {
            return new InternalFactory<T>(){

                @Override
                public T create(InternalContext context) {
                    Strategy strategy = context.getScopeStrategy();
                    try {
                        return strategy.findInRequest(type, name, this.toCallable(context, factory));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public String toString() {
                    return factory.toString();
                }
            };
        }
    };
    public static final /* enum */ Scope SESSION = new Scope("SESSION", 4){

        @Override
        <T> InternalFactory<? extends T> scopeFactory(final Class<T> type, final String name, final InternalFactory<? extends T> factory) {
            return new InternalFactory<T>(){

                @Override
                public T create(InternalContext context) {
                    Strategy strategy = context.getScopeStrategy();
                    try {
                        return strategy.findInSession(type, name, this.toCallable(context, factory));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public String toString() {
                    return factory.toString();
                }
            };
        }
    };
    public static final /* enum */ Scope WIZARD = new Scope("WIZARD", 5){

        @Override
        <T> InternalFactory<? extends T> scopeFactory(final Class<T> type, final String name, final InternalFactory<? extends T> factory) {
            return new InternalFactory<T>(){

                @Override
                public T create(InternalContext context) {
                    Strategy strategy = context.getScopeStrategy();
                    try {
                        return strategy.findInWizard(type, name, this.toCallable(context, factory));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public String toString() {
                    return factory.toString();
                }
            };
        }
    };
    private static final /* synthetic */ Scope[] $VALUES;
    static /* synthetic */ Class class$com$opensymphony$xwork2$inject$Scope;

    public static final Scope[] values() {
        return (Scope[])$VALUES.clone();
    }

    public static Scope valueOf(String name) {
        Class<?> clazz = class$com$opensymphony$xwork2$inject$Scope;
        if (clazz == null) {
            clazz = class$com$opensymphony$xwork2$inject$Scope = new Scope[0].getClass().getComponentType();
        }
        return (Scope)Enum_.valueOf((Class)clazz, (String)name);
    }

    private Scope(String string, int n) {
        super(string, n);
    }

    <T> Callable<? extends T> toCallable(final InternalContext context, final InternalFactory<? extends T> factory) {
        return new Callable<T>(){

            public T call() throws Exception {
                return factory.create(context);
            }
        };
    }

    abstract <T> InternalFactory<? extends T> scopeFactory(Class<T> var1, String var2, InternalFactory<? extends T> var3);

    static {
        $VALUES = new Scope[]{DEFAULT, SINGLETON, THREAD, REQUEST, SESSION, WIZARD};
        Class<?> clazz = class$com$opensymphony$xwork2$inject$Scope;
        if (clazz == null) {
            clazz = class$com$opensymphony$xwork2$inject$Scope = new Scope[0].getClass().getComponentType();
        }
        Enum_.setEnumConstants((Class)clazz, (Enum_[])Scope.values());
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Strategy {
        public <T> T findInRequest(Class<T> var1, String var2, Callable<? extends T> var3) throws Exception;

        public <T> T findInSession(Class<T> var1, String var2, Callable<? extends T> var3) throws Exception;

        public <T> T findInWizard(Class<T> var1, String var2, Callable<? extends T> var3) throws Exception;
    }
}

