/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrefixMethodInvocationUtil {
    private static final Log _log;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$opensymphony$xwork2$interceptor$PrefixMethodInvocationUtil;

    public static void invokePrefixMethod(ActionInvocation actionInvocation, String[] prefixes) throws InvocationTargetException, IllegalAccessException {
        Method method;
        Object action = actionInvocation.getAction();
        String methodName = actionInvocation.getProxy().getMethod();
        if (methodName == null) {
            methodName = "execute";
        }
        if ((method = PrefixMethodInvocationUtil.getPrefixedMethod(prefixes, methodName, action)) != null) {
            method.invoke(action, new Object[0]);
        }
    }

    public static Method getPrefixedMethod(String[] prefixes, String methodName, Object action) {
        if (!$assertionsDisabled && prefixes == null) {
            throw new AssertionError();
        }
        String capitalizedMethodName = PrefixMethodInvocationUtil.capitalizeMethodName(methodName);
        for (int a = 0; a < prefixes.length; ++a) {
            String prefixedMethodName = prefixes[a] + capitalizedMethodName;
            try {
                Method method = action.getClass().getMethod(prefixedMethodName, new Class[0]);
                return method;
            }
            catch (NoSuchMethodException e) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("cannot find method [" + prefixedMethodName + "] in action [" + action + "]"));
                continue;
            }
        }
        return null;
    }

    public static String capitalizeMethodName(String methodName) {
        if (!$assertionsDisabled && methodName == null) {
            throw new AssertionError();
        }
        methodName = methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        return methodName;
    }

    static {
        Class<?> clazz = class$com$opensymphony$xwork2$interceptor$PrefixMethodInvocationUtil;
        if (clazz == null) {
            clazz = class$com$opensymphony$xwork2$interceptor$PrefixMethodInvocationUtil = new PrefixMethodInvocationUtil[0].getClass().getComponentType();
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$com$opensymphony$xwork2$interceptor$PrefixMethodInvocationUtil;
        if (clazz2 == null) {
            clazz2 = class$com$opensymphony$xwork2$interceptor$PrefixMethodInvocationUtil = new PrefixMethodInvocationUtil[0].getClass().getComponentType();
        }
        _log = LogFactory.getLog((Class)clazz2);
    }
}

